/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.MaskFilter;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.MaskFilterSpan;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import com.tamsiree.rxkit.RxTool;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/tamsiree/rxkit/RxTextTool;", "", "()V", "getBuilder", "Lcom/tamsiree/rxkit/RxTextTool$Builder;", "text", "", "Builder", "RxKit_release"})
public final class RxTextTool {
    public static final RxTextTool INSTANCE;

    @JvmStatic
    @NotNull
    public static final Builder getBuilder(@NotNull CharSequence text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return new Builder(text);
    }

    private RxTextTool() {
    }

    static {
        RxTextTool rxTextTool;
        INSTANCE = rxTextTool = new RxTextTool();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u00104\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u00105\u001a\u00020'J\u0010\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000109J\u0010\u0010:\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010;\u001a\u00020\u00002\b\b\u0001\u0010<\u001a\u00020\bJ\u000e\u0010=\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010>\u001a\u00020\u00002\u0006\u0010+\u001a\u00020)2\b\u0010.\u001a\u0004\u0018\u00010/J\u0006\u0010?\u001a\u00020\u0000J\u0006\u0010@\u001a\u00020\u0000J\u0016\u0010A\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010<\u001a\u00020\bJ\u000e\u0010B\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010C\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\bJ\u0010\u0010E\u001a\u00020\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010F\u001a\u00020\u00002\b\b\u0001\u0010<\u001a\u00020\bJ\u0006\u0010G\u001a\u00020\u0000J\u0016\u0010H\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bJ\u000e\u0010I\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)J\u0010\u0010J\u001a\u00020\u00002\b\b\u0001\u0010<\u001a\u00020\bJ\u0010\u0010K\u001a\u00020\u00002\b\b\u0001\u0010,\u001a\u00020\bJ\b\u0010L\u001a\u000207H\u0002J\u0006\u0010M\u001a\u00020\u0000J\u0006\u0010N\u001a\u00020\u0000J\u0006\u0010O\u001a\u00020\u0000J\u0006\u0010P\u001a\u00020\u0000J\u000e\u0010Q\u001a\u00020\u00002\u0006\u00100\u001a\u000201J\u000e\u0010R\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0014J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010*\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010,\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/tamsiree/rxkit/RxTextTool$Builder;", "", "text", "", "(Ljava/lang/CharSequence;)V", "align", "Landroid/text/Layout$Alignment;", "backgroundColor", "", "bitmap", "Landroid/graphics/Bitmap;", "bulletColor", "clickSpan", "Landroid/text/style/ClickableSpan;", "defaultValue", "drawable", "Landroid/graphics/drawable/Drawable;", "first", "flag", "fontFamily", "", "foregroundColor", "gapWidth", "imageIsBitmap", "", "imageIsDrawable", "imageIsResourceId", "imageIsUri", "isBlur", "isBold", "isBoldItalic", "isBullet", "isItalic", "isLeadingMargin", "isStrikethrough", "isSubscript", "isSuperscript", "isUnderline", "mBuilder", "Landroid/text/SpannableStringBuilder;", "proportion", "", "quoteColor", "radius", "resourceId", "rest", "style", "Landroid/graphics/BlurMaskFilter$Blur;", "uri", "Landroid/net/Uri;", "url", "xProportion", "append", "create", "into", "", "textView", "Landroid/widget/TextView;", "setAlign", "setBackgroundColor", "color", "setBitmap", "setBlur", "setBold", "setBoldItalic", "setBullet", "setClickSpan", "setDrawable", "setFlag", "setFontFamily", "setForegroundColor", "setItalic", "setLeadingMargin", "setProportion", "setQuoteColor", "setResourceId", "setSpan", "setStrikethrough", "setSubscript", "setSuperscript", "setUnderline", "setUri", "setUrl", "setXProportion", "RxKit_release"})
    public static final class Builder {
        private final int defaultValue = 0x12000000;
        private int flag;
        @ColorInt
        private int foregroundColor;
        @ColorInt
        private int backgroundColor;
        @ColorInt
        private int quoteColor;
        private boolean isLeadingMargin;
        private int first;
        private int rest;
        private boolean isBullet;
        private int gapWidth;
        private int bulletColor;
        private float proportion;
        private float xProportion;
        private boolean isStrikethrough;
        private boolean isUnderline;
        private boolean isSuperscript;
        private boolean isSubscript;
        private boolean isBold;
        private boolean isItalic;
        private boolean isBoldItalic;
        private String fontFamily;
        private Layout.Alignment align;
        private boolean imageIsBitmap;
        private Bitmap bitmap;
        private boolean imageIsDrawable;
        private Drawable drawable;
        private boolean imageIsUri;
        private Uri uri;
        private boolean imageIsResourceId;
        @DrawableRes
        private int resourceId;
        private ClickableSpan clickSpan;
        private String url;
        private boolean isBlur;
        private float radius;
        private BlurMaskFilter.Blur style;
        private final SpannableStringBuilder mBuilder;
        private CharSequence text;

        @NotNull
        public final Builder setFlag(int flag) {
            this.flag = flag;
            return this;
        }

        @NotNull
        public final Builder setForegroundColor(@ColorInt int color) {
            this.foregroundColor = color;
            return this;
        }

        @NotNull
        public final Builder setBackgroundColor(@ColorInt int color) {
            this.backgroundColor = color;
            return this;
        }

        @NotNull
        public final Builder setQuoteColor(@ColorInt int color) {
            this.quoteColor = color;
            return this;
        }

        @NotNull
        public final Builder setLeadingMargin(int first, int rest) {
            this.first = first;
            this.rest = rest;
            this.isLeadingMargin = true;
            return this;
        }

        @NotNull
        public final Builder setBullet(int gapWidth, int color) {
            this.gapWidth = gapWidth;
            this.bulletColor = color;
            this.isBullet = true;
            return this;
        }

        @NotNull
        public final Builder setProportion(float proportion) {
            this.proportion = proportion;
            return this;
        }

        @NotNull
        public final Builder setXProportion(float proportion) {
            this.xProportion = proportion;
            return this;
        }

        @NotNull
        public final Builder setStrikethrough() {
            this.isStrikethrough = true;
            return this;
        }

        @NotNull
        public final Builder setUnderline() {
            this.isUnderline = true;
            return this;
        }

        @NotNull
        public final Builder setSuperscript() {
            this.isSuperscript = true;
            return this;
        }

        @NotNull
        public final Builder setSubscript() {
            this.isSubscript = true;
            return this;
        }

        @NotNull
        public final Builder setBold() {
            this.isBold = true;
            return this;
        }

        @NotNull
        public final Builder setItalic() {
            this.isItalic = true;
            return this;
        }

        @NotNull
        public final Builder setBoldItalic() {
            this.isBoldItalic = true;
            return this;
        }

        @NotNull
        public final Builder setFontFamily(@Nullable String fontFamily) {
            this.fontFamily = fontFamily;
            return this;
        }

        @NotNull
        public final Builder setAlign(@Nullable Layout.Alignment align) {
            this.align = align;
            return this;
        }

        @NotNull
        public final Builder setBitmap(@NotNull Bitmap bitmap) {
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            this.bitmap = bitmap;
            this.imageIsBitmap = true;
            return this;
        }

        @NotNull
        public final Builder setDrawable(@NotNull Drawable drawable) {
            Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
            this.drawable = drawable;
            this.imageIsDrawable = true;
            return this;
        }

        @NotNull
        public final Builder setUri(@NotNull Uri uri) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            this.uri = uri;
            this.imageIsUri = true;
            return this;
        }

        @NotNull
        public final Builder setResourceId(@DrawableRes int resourceId) {
            this.resourceId = resourceId;
            this.imageIsResourceId = true;
            return this;
        }

        @NotNull
        public final Builder setClickSpan(@NotNull ClickableSpan clickSpan) {
            Intrinsics.checkParameterIsNotNull((Object)clickSpan, (String)"clickSpan");
            this.clickSpan = clickSpan;
            return this;
        }

        @NotNull
        public final Builder setUrl(@NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            this.url = url;
            return this;
        }

        @NotNull
        public final Builder setBlur(float radius, @Nullable BlurMaskFilter.Blur style2) {
            this.radius = radius;
            this.style = style2;
            this.isBlur = true;
            return this;
        }

        @NotNull
        public final Builder append(@NotNull CharSequence text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this.setSpan();
            this.text = text;
            return this;
        }

        @NotNull
        public final SpannableStringBuilder create() {
            this.setSpan();
            return this.mBuilder;
        }

        public final void into(@Nullable TextView textView) {
            this.setSpan();
            if (textView != null) {
                textView.setText((CharSequence)this.mBuilder);
            }
        }

        private final void setSpan() {
            int start = this.mBuilder.length();
            this.mBuilder.append(this.text);
            int end = this.mBuilder.length();
            if (this.foregroundColor != this.defaultValue) {
                this.mBuilder.setSpan((Object)new ForegroundColorSpan(this.foregroundColor), start, end, this.flag);
                this.foregroundColor = this.defaultValue;
            }
            if (this.backgroundColor != this.defaultValue) {
                this.mBuilder.setSpan((Object)new BackgroundColorSpan(this.backgroundColor), start, end, this.flag);
                this.backgroundColor = this.defaultValue;
            }
            if (this.isLeadingMargin) {
                this.mBuilder.setSpan((Object)new LeadingMarginSpan.Standard(this.first, this.rest), start, end, this.flag);
                this.isLeadingMargin = false;
            }
            if (this.quoteColor != this.defaultValue) {
                this.mBuilder.setSpan((Object)new QuoteSpan(this.quoteColor), start, end, 0);
                this.quoteColor = this.defaultValue;
            }
            if (this.isBullet) {
                this.mBuilder.setSpan((Object)new BulletSpan(this.gapWidth, this.bulletColor), start, end, 0);
                this.isBullet = false;
            }
            if (this.proportion != -1.0f) {
                this.mBuilder.setSpan((Object)new RelativeSizeSpan(this.proportion), start, end, this.flag);
                this.proportion = -1.0f;
            }
            if (this.xProportion != -1.0f) {
                this.mBuilder.setSpan((Object)new ScaleXSpan(this.xProportion), start, end, this.flag);
                this.xProportion = -1.0f;
            }
            if (this.isStrikethrough) {
                this.mBuilder.setSpan((Object)new StrikethroughSpan(), start, end, this.flag);
                this.isStrikethrough = false;
            }
            if (this.isUnderline) {
                this.mBuilder.setSpan((Object)new UnderlineSpan(), start, end, this.flag);
                this.isUnderline = false;
            }
            if (this.isSuperscript) {
                this.mBuilder.setSpan((Object)new SuperscriptSpan(), start, end, this.flag);
                this.isSuperscript = false;
            }
            if (this.isSubscript) {
                this.mBuilder.setSpan((Object)new SubscriptSpan(), start, end, this.flag);
                this.isSubscript = false;
            }
            if (this.isBold) {
                this.mBuilder.setSpan((Object)new StyleSpan(1), start, end, this.flag);
                this.isBold = false;
            }
            if (this.isItalic) {
                this.mBuilder.setSpan((Object)new StyleSpan(2), start, end, this.flag);
                this.isItalic = false;
            }
            if (this.isBoldItalic) {
                this.mBuilder.setSpan((Object)new StyleSpan(3), start, end, this.flag);
                this.isBoldItalic = false;
            }
            if (this.fontFamily != null) {
                this.mBuilder.setSpan((Object)new TypefaceSpan(this.fontFamily), start, end, this.flag);
                this.fontFamily = null;
            }
            if (this.align != null) {
                Layout.Alignment alignment = this.align;
                if (alignment == null) {
                    Intrinsics.throwNpe();
                }
                this.mBuilder.setSpan((Object)new AlignmentSpan.Standard(alignment), start, end, this.flag);
                this.align = null;
            }
            if (this.imageIsBitmap || this.imageIsDrawable || this.imageIsUri || this.imageIsResourceId) {
                if (this.imageIsBitmap) {
                    Context context = RxTool.getContext();
                    Bitmap bitmap = this.bitmap;
                    if (bitmap == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mBuilder.setSpan((Object)new ImageSpan(context, bitmap), start, end, this.flag);
                    this.bitmap = null;
                    this.imageIsBitmap = false;
                } else if (this.imageIsDrawable) {
                    Drawable drawable = this.drawable;
                    if (drawable == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mBuilder.setSpan((Object)new ImageSpan(drawable), start, end, this.flag);
                    this.drawable = null;
                    this.imageIsDrawable = false;
                } else if (this.imageIsUri) {
                    Context context = RxTool.getContext();
                    Uri uri = this.uri;
                    if (uri == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mBuilder.setSpan((Object)new ImageSpan(context, uri), start, end, this.flag);
                    this.uri = null;
                    this.imageIsUri = false;
                } else {
                    this.mBuilder.setSpan((Object)new ImageSpan(RxTool.getContext(), this.resourceId), start, end, this.flag);
                    this.resourceId = 0;
                    this.imageIsResourceId = false;
                }
            }
            if (this.clickSpan != null) {
                this.mBuilder.setSpan((Object)this.clickSpan, start, end, this.flag);
                this.clickSpan = null;
            }
            if (this.url != null) {
                this.mBuilder.setSpan((Object)new URLSpan(this.url), start, end, this.flag);
                this.url = null;
            }
            if (this.isBlur) {
                this.mBuilder.setSpan((Object)new MaskFilterSpan((MaskFilter)new BlurMaskFilter(this.radius, this.style)), start, end, this.flag);
                this.isBlur = false;
            }
            this.flag = 33;
        }

        public Builder(@NotNull CharSequence text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this.text = text;
            this.defaultValue = 0x12000000;
            this.flag = 33;
            this.foregroundColor = this.defaultValue;
            this.backgroundColor = this.defaultValue;
            this.quoteColor = this.defaultValue;
            this.proportion = -1.0f;
            this.xProportion = -1.0f;
            this.mBuilder = new SpannableStringBuilder();
        }
    }
}

