/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.content.Context;
import android.content.SharedPreferences;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007J\"\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\fH\u0007J$\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0007J\"\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0010H\u0007J\"\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0012H\u0007J$\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0007J\"\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0014H\u0007J$\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0007J\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010 \u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/tamsiree/rxkit/RxSPTool;", "", "()V", "JSON_CACHE", "", "clearPreference", "", "context", "Landroid/content/Context;", "name", "key", "getBoolean", "", "getContent", "tag", "getFloat", "", "getInt", "", "getLong", "", "getString", "putBoolean", "value", "putContent", "content", "putFloat", "putInt", "putJSONCache", "putLong", "putString", "readJSONCache", "remove", "RxKit_release"})
public final class RxSPTool {
    private static final String JSON_CACHE = "JSON_CACHE";
    public static final RxSPTool INSTANCE;

    @JvmStatic
    public static final void putContent(@NotNull Context context, @Nullable String tag, @Nullable String content) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        RxSPTool.putString(context, tag, content);
    }

    @JvmStatic
    @NotNull
    public static final String getContent(@NotNull Context context, @Nullable String tag) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return RxSPTool.getString(context, tag);
    }

    @JvmStatic
    public static final void putString(@NotNull Context context, @Nullable String key, @Nullable String value) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sp = context.getSharedPreferences(key, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(key, value);
        editor.apply();
    }

    @JvmStatic
    @NotNull
    public static final String getString(@NotNull Context context, @Nullable String key) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sp = context.getSharedPreferences(key, 0);
        String value = null;
        String string = sp.getString(key, "");
        if (string == null) {
            Intrinsics.throwNpe();
        }
        value = string;
        return value;
    }

    @JvmStatic
    public static final void putInt(@NotNull Context context, @Nullable String key, int value) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sp = context.getSharedPreferences(key, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt(key, value);
        editor.apply();
    }

    @JvmStatic
    public static final int getInt(@NotNull Context context, @Nullable String key) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sp = context.getSharedPreferences(key, 0);
        int value = 0;
        value = sp.getInt(key, -1);
        return value;
    }

    @JvmStatic
    public static final void putLong(@NotNull Context context, @Nullable String key, long value) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sp = context.getSharedPreferences(key, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putLong(key, value);
        editor.apply();
    }

    @JvmStatic
    public static final long getLong(@NotNull Context context, @Nullable String key) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sp = context.getSharedPreferences(key, 0);
        long value = 0L;
        value = sp.getLong(key, -1L);
        return value;
    }

    @JvmStatic
    public static final void putFloat(@NotNull Context context, @Nullable String key, float value) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sp = context.getSharedPreferences(key, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putFloat(key, value);
        editor.apply();
    }

    @JvmStatic
    public static final float getFloat(@NotNull Context context, @Nullable String key) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sp = context.getSharedPreferences(key, 0);
        float value = 0.0f;
        value = sp.getFloat(key, -1.0f);
        return value;
    }

    @JvmStatic
    public static final void putBoolean(@NotNull Context context, @Nullable String key, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sp = context.getSharedPreferences(key, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean(key, value);
        editor.apply();
    }

    @JvmStatic
    public static final boolean getBoolean(@NotNull Context context, @Nullable String key) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sp = context.getSharedPreferences(key, 0);
        boolean value = false;
        value = sp.getBoolean(key, false);
        return value;
    }

    @JvmStatic
    public static final void remove(@NotNull Context context, @Nullable String key) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sp = context.getSharedPreferences(key, 0);
        sp.edit().remove(key).apply();
    }

    @JvmStatic
    public static final void putJSONCache(@NotNull Context context, @Nullable String key, @Nullable String content) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sp = context.getSharedPreferences(JSON_CACHE, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(key, content);
        editor.apply();
    }

    @JvmStatic
    @Nullable
    public static final String readJSONCache(@NotNull Context context, @Nullable String key) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sp = context.getSharedPreferences(JSON_CACHE, 0);
        return sp.getString(key, null);
    }

    @JvmStatic
    public static final void clearPreference(@NotNull Context context, @Nullable String name, @Nullable String key) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sharedPreferences = context.getSharedPreferences(name, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        if (key != null) {
            editor.remove(key);
        } else {
            editor.clear();
        }
        editor.apply();
    }

    private RxSPTool() {
    }

    static {
        RxSPTool rxSPTool;
        INSTANCE = rxSPTool = new RxSPTool();
    }
}

