/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.location.Location;
import android.media.ExifInterface;
import com.orhanobut.logger.Logger;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Lcom/tamsiree/rxkit/RxExifTool;", "", "()V", "gpsInfoConvert", "", "gpsInfo", "", "writeLatLonIntoJpeg", "", "picPath", "dLat", "dLon", "RxKit_release"})
public final class RxExifTool {
    public static final RxExifTool INSTANCE;

    @JvmStatic
    public static final void writeLatLonIntoJpeg(@Nullable String picPath, double dLat, double dLon) {
        File file = new File(picPath);
        if (file.exists()) {
            try {
                ExifInterface exif = new ExifInterface(picPath);
                String tagLat = exif.getAttribute("GPSLatitude");
                String tagLon = exif.getAttribute("GPSLongitude");
                if (tagLat == null && tagLon == null) {
                    exif.setAttribute("GPSLatitude", INSTANCE.gpsInfoConvert(dLat));
                    exif.setAttribute("GPSLatitudeRef", dLat > 0.0 ? "N" : "S");
                    exif.setAttribute("GPSLongitude", INSTANCE.gpsInfoConvert(dLon));
                    exif.setAttribute("GPSLongitudeRef", dLon > 0.0 ? "E" : "W");
                    exif.saveAttributes();
                }
                exif.saveAttributes();
                Logger.d((String)StringsKt.trimIndent((String)("\n    " + exif.getAttribute("GPSLatitude") + "\n    " + exif.getAttribute("GPSLongitude") + "\n    " + exif.getAttribute("GPSProcessingMethod") + "\n    " + exif.getAttribute("ImageLength") + "\n    " + exif.getAttribute("ImageWidth") + "\n    ")), (Object[])new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final String gpsInfoConvert(double gpsInfo) {
        String dms;
        double gpsInfo2 = gpsInfo;
        gpsInfo2 = Math.abs(gpsInfo2);
        String string = dms = Location.convert((double)gpsInfo2, (int)2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dms");
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] splits = stringArray;
        Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)splits[2], (String[])new String[]{"\\."}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] secnds = stringArray2;
        String seconds = null;
        seconds = secnds.length == 0 ? splits[2] : secnds[0];
        return splits[0] + "/1," + splits[1] + "/1," + seconds + "/1";
    }

    private RxExifTool() {
    }

    static {
        RxExifTool rxExifTool;
        INSTANCE = rxExifTool = new RxExifTool();
    }
}

