/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit.photomagic;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import androidx.exifinterface.media.ExifInterface;
import com.tamsiree.rxkit.photomagic.Checker;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\u0005J\b\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/tamsiree/rxkit/photomagic/Engine;", "", "srcImg", "", "tagImg", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "srcExif", "Landroidx/exifinterface/media/ExifInterface;", "srcHeight", "", "srcWidth", "compress", "computeSize", "rotatingImage", "Landroid/graphics/Bitmap;", "bitmap", "RxKit_release"})
public final class Engine {
    private ExifInterface srcExif;
    private final String srcImg;
    private final File tagImg;
    private int srcWidth;
    private int srcHeight;

    private final int computeSize() {
        int n;
        this.srcWidth = this.srcWidth % 2 == 1 ? this.srcWidth + 1 : this.srcWidth;
        this.srcHeight = this.srcHeight % 2 == 1 ? this.srcHeight + 1 : this.srcHeight;
        int n2 = this.srcWidth;
        int n3 = this.srcHeight;
        int n4 = 0;
        int longSide = Math.max(n2, n3);
        n3 = this.srcWidth;
        n4 = this.srcHeight;
        boolean bl = false;
        int shortSide = Math.min(n3, n4);
        float scale = (float)shortSide / (float)longSide;
        if (scale <= 1.0f && (double)scale > 0.5625) {
            n = longSide < 1664 ? 2 : (1664 <= (n4 = longSide) && 4989 >= n4 ? 4 : (4991 <= (n4 = longSide) && 10239 >= n4 ? 8 : (longSide / 1280 == 0 ? 2 : longSide / 1280 + 1)));
        } else if ((double)scale <= 0.5625 && (double)scale > 0.5) {
            n = longSide / 1280 == 0 ? 2 : longSide / 1280 + 1;
        } else {
            double d = (double)longSide / (1280.0 / (double)scale);
            boolean bl2 = false;
            n = (int)Math.ceil(d) + 1;
        }
        return n;
    }

    private final Bitmap rotatingImage(Bitmap bitmap) {
        if (this.srcExif == null) {
            return bitmap;
        }
        Matrix matrix = new Matrix();
        int angle = 0;
        ExifInterface exifInterface = this.srcExif;
        if (exifInterface == null) {
            Intrinsics.throwNpe();
        }
        switch (exifInterface.getAttributeInt("Orientation", 1)) {
            case 6: {
                angle = 90;
                break;
            }
            case 3: {
                angle = 180;
                break;
            }
            case 8: {
                angle = 270;
                break;
            }
        }
        matrix.postRotate((float)angle);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(bitm\u2026map.height, matrix, true)");
        return bitmap2;
    }

    @NotNull
    public final File compress() throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = this.computeSize();
        Bitmap tagBitmap = BitmapFactory.decodeFile((String)this.srcImg, (BitmapFactory.Options)options);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Bitmap bitmap = tagBitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"tagBitmap");
        tagBitmap = this.rotatingImage(bitmap);
        tagBitmap.compress(Bitmap.CompressFormat.JPEG, 35, (OutputStream)stream);
        tagBitmap.recycle();
        FileOutputStream fos = new FileOutputStream(this.tagImg);
        fos.write(stream.toByteArray());
        fos.flush();
        fos.close();
        stream.close();
        return this.tagImg;
    }

    public Engine(@NotNull String srcImg, @NotNull File tagImg) {
        Intrinsics.checkParameterIsNotNull((Object)srcImg, (String)"srcImg");
        Intrinsics.checkParameterIsNotNull((Object)tagImg, (String)"tagImg");
        if (Checker.isJPG(srcImg)) {
            this.srcExif = new ExifInterface(srcImg);
        }
        this.tagImg = tagImg;
        this.srcImg = srcImg;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inSampleSize = 1;
        BitmapFactory.decodeFile((String)srcImg, (BitmapFactory.Options)options);
        this.srcWidth = options.outWidth;
        this.srcHeight = options.outHeight;
    }
}

