/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.os.Build;
import android.text.Html;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\b\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\n\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0007J\u001c\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u000f"}, d2={"Lcom/tamsiree/rxkit/RxEncodeTool;", "", "()V", "base64Decode", "", "input", "", "base64Encode", "base64Encode2String", "base64UrlSafeEncode", "htmlDecode", "htmlEncode", "urlDecode", "charset", "urlEncode", "RxKit_release"})
public final class RxEncodeTool {
    public static final RxEncodeTool INSTANCE;

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String urlEncode(@NotNull String input, @Nullable String charset) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        try {
            String string3 = URLEncoder.encode(input, charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"URLEncoder.encode(input, charset)");
            string2 = string3;
        }
        catch (UnsupportedEncodingException e) {
            string2 = input;
        }
        return string2;
    }

    public static /* synthetic */ String urlEncode$default(String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "UTF-8";
        }
        return RxEncodeTool.urlEncode(string2, string3);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String urlEncode(@NotNull String input) {
        return RxEncodeTool.urlEncode$default(input, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String urlDecode(@NotNull String input, @Nullable String charset) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        try {
            String string3 = URLDecoder.decode(input, charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"URLDecoder.decode(input, charset)");
            string2 = string3;
        }
        catch (UnsupportedEncodingException e) {
            string2 = input;
        }
        return string2;
    }

    public static /* synthetic */ String urlDecode$default(String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "UTF-8";
        }
        return RxEncodeTool.urlDecode(string2, string3);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String urlDecode(@NotNull String input) {
        return RxEncodeTool.urlDecode$default(input, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64Encode(@NotNull String input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        String string2 = input;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return RxEncodeTool.base64Encode(byArray);
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64Encode(@Nullable byte[] input) {
        byte[] byArray = Base64.encode((byte[])input, (int)2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.encode(input, Base64.NO_WRAP)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final String base64Encode2String(@Nullable byte[] input) {
        String string2 = Base64.encodeToString((byte[])input, (int)2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Base64.encodeToString(input, Base64.NO_WRAP)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64Decode(@Nullable String input) {
        byte[] byArray = Base64.decode((String)input, (int)2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.decode(input, Base64.NO_WRAP)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64Decode(@Nullable byte[] input) {
        byte[] byArray = Base64.decode((byte[])input, (int)2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.decode(input, Base64.NO_WRAP)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64UrlSafeEncode(@NotNull String input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        String string2 = input;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = Base64.encode((byte[])byArray, (int)8);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"Base64.encode(input.toBy\u2026Array(), Base64.URL_SAFE)");
        return byArray2;
    }

    @JvmStatic
    @NotNull
    public static final String htmlEncode(@NotNull String input) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (Build.VERSION.SDK_INT >= 16) {
            String string3 = Html.escapeHtml((CharSequence)input);
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Html.escapeHtml(input)");
        } else {
            StringBuilder out = new StringBuilder();
            int len = input.length();
            for (int i = 0; i < len; ++i) {
                char c = input.charAt(i);
                if (c == '<') {
                    Intrinsics.checkExpressionValueIsNotNull((Object)out.append("&lt;"), (String)"out.append(\"&lt;\")");
                    continue;
                }
                if (c == '>') {
                    Intrinsics.checkExpressionValueIsNotNull((Object)out.append("&gt;"), (String)"out.append(\"&gt;\")");
                    continue;
                }
                if (c == '&') {
                    Intrinsics.checkExpressionValueIsNotNull((Object)out.append("&amp;"), (String)"out.append(\"&amp;\")");
                    continue;
                }
                if (c >= '\ud800' && c <= '\udfff') {
                    char d;
                    if (c >= '\udc00' || i + 1 >= len || (d = input.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                    ++i;
                    int codepoint = 0x10000 | c - 55296 << 10 | d - 56320;
                    out.append("&#").append(codepoint).append(";");
                    continue;
                }
                if (c > '~' || c < ' ') {
                    out.append("&#").append((int)c).append(";");
                    continue;
                }
                if (c == ' ') {
                    while (i + 1 < len && input.charAt(i + 1) == ' ') {
                        out.append("&nbsp;");
                        ++i;
                    }
                    out.append(' ');
                    continue;
                }
                out.append(c);
            }
            String string4 = out.toString();
            string2 = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"out.toString()");
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String htmlDecode(@Nullable String input) {
        return Html.fromHtml((String)input).toString();
    }

    private RxEncodeTool() {
    }

    static {
        RxEncodeTool rxEncodeTool;
        INSTANCE = rxEncodeTool = new RxEncodeTool();
    }
}

