/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.res.ResourcesCompat;
import androidx.fragment.app.FragmentActivity;
import com.tamsiree.rxkit.R;
import com.tamsiree.rxkit.RxAppTool;
import com.tamsiree.rxkit.RxLogTool;
import com.tamsiree.rxkit.crash.RxCrashConfig;
import com.tamsiree.rxkit.crash.RxCrashTool;
import java.io.File;

public class ActivityCrash
extends FragmentActivity {
    @SuppressLint(value={"PrivateResource"})
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TypedArray a = this.obtainStyledAttributes(R.styleable.AppCompatTheme);
        if (!a.hasValue(R.styleable.AppCompatTheme_windowActionBar)) {
            this.setTheme(R.style.Theme_AppCompat_Light_DarkActionBar);
        }
        a.recycle();
        this.setContentView(R.layout.activity_crash);
        Button restartButton = (Button)this.findViewById(R.id.crash_error_activity_restart_button);
        Button closeButton = (Button)this.findViewById(R.id.crash_error_activity_close_button);
        TextView tvCrashTool = (TextView)this.findViewById(R.id.rx_crash_tool);
        final RxCrashConfig config = RxCrashTool.getConfigFromIntent(this.getIntent());
        if (config == null) {
            this.finish();
            return;
        }
        if (config.isShowRestartButton() && config.getRestartActivityClass() != null) {
            restartButton.setText(R.string.crash_error_restart_app);
            restartButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    RxCrashTool.restartApplication((Activity)ActivityCrash.this, config);
                }
            });
            closeButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    RxCrashTool.closeApplication((Activity)ActivityCrash.this, config);
                }
            });
        } else {
            closeButton.setVisibility(8);
        }
        final String message = RxCrashTool.getAllErrorDetailsFromIntent((Context)this, this.getIntent());
        File file = RxLogTool.e(message);
        String appName = RxAppTool.getAppName((Context)this);
        tvCrashTool.setText((CharSequence)appName);
        TextView locateButton = (TextView)this.findViewById(R.id.crash_error_locate_more_info_button);
        locateButton.setText((CharSequence)(locateButton.getText() + "\n\n" + file.getAbsolutePath() + "\n"));
        Button moreInfoButton = (Button)this.findViewById(R.id.crash_error_activity_more_info_button);
        if (config.isShowErrorDetails()) {
            moreInfoButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AlertDialog dialog = new AlertDialog.Builder((Context)ActivityCrash.this).setTitle(R.string.crash_error_details_title).setMessage((CharSequence)message).setPositiveButton(R.string.crash_error_details_close, null).setNeutralButton(R.string.crash_error_details_copy, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            ActivityCrash.this.copyErrorToClipboard();
                        }
                    }).show();
                    TextView textView = (TextView)dialog.findViewById(16908299);
                    if (textView != null) {
                        textView.setTextSize(0, ActivityCrash.this.getResources().getDimension(R.dimen.customactivityoncrash_error_activity_error_details_text_size));
                    }
                }
            });
        } else {
            moreInfoButton.setVisibility(8);
        }
        Integer defaultErrorActivityDrawableId = config.getErrorDrawable();
        ImageView errorImageView = (ImageView)this.findViewById(R.id.crash_error_activity_image);
        if (defaultErrorActivityDrawableId != null) {
            errorImageView.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)defaultErrorActivityDrawableId, (Resources.Theme)this.getTheme()));
        }
    }

    private void copyErrorToClipboard() {
        String errorInformation = RxCrashTool.getAllErrorDetailsFromIntent((Context)this, this.getIntent());
        ClipboardManager clipboard = (ClipboardManager)this.getSystemService("clipboard");
        if (clipboard != null) {
            ClipData clip = ClipData.newPlainText((CharSequence)this.getString(R.string.crash_error_details_clipboard_label), (CharSequence)errorInformation);
            clipboard.setPrimaryClip(clip);
            Toast.makeText((Context)this, (int)R.string.crash_error_details_copied, (int)0).show();
        }
    }
}

