/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.tamsiree.rxkit.RxLogTool;
import com.tamsiree.rxkit.RxVibrateTool;
import com.tamsiree.rxkit.interfaces.OnDoListener;
import com.tamsiree.rxkit.interfaces.OnSimpleListener;
import com.tamsiree.rxkit.view.RxToast;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RxTool {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context context;
    private static long lastClickTime;

    public static void init(Context context) {
        RxTool.context = context.getApplicationContext();
        RxLogTool.init(context);
    }

    public static Context getContext() {
        if (context != null) {
            return context;
        }
        throw new NullPointerException("\u8bf7\u5148\u8c03\u7528init()\u65b9\u6cd5");
    }

    public static void delayToDo(long delayTime, final OnSimpleListener onSimpleListener) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                onSimpleListener.doSomething();
            }
        }, delayTime);
    }

    public static void countDown(final TextView textView, long waitTime, long interval, final String hint) {
        textView.setEnabled(false);
        CountDownTimer timer = new CountDownTimer(waitTime, interval){

            @SuppressLint(value={"DefaultLocale"})
            public void onTick(long millisUntilFinished) {
                textView.setText((CharSequence)String.format("\u5269\u4e0b %d S", millisUntilFinished / 1000L));
            }

            public void onFinish() {
                textView.setEnabled(true);
                textView.setText((CharSequence)hint);
            }
        };
        timer.start();
    }

    public static void fixListViewHeight(ListView listView) {
        ListAdapter listAdapter = listView.getAdapter();
        int totalHeight = 0;
        if (listAdapter == null) {
            return;
        }
        int len = listAdapter.getCount();
        for (int index = 0; index < len; ++index) {
            View listViewItem = listAdapter.getView(index, null, (ViewGroup)listView);
            listViewItem.measure(0, 0);
            totalHeight += listViewItem.getMeasuredHeight();
        }
        ViewGroup.LayoutParams params = listView.getLayoutParams();
        params.height = totalHeight + listView.getDividerHeight() * (listAdapter.getCount() - 1);
        listView.setLayoutParams(params);
    }

    public static String Md5(String MStr) {
        try {
            MessageDigest mDigest = MessageDigest.getInstance("MD5");
            mDigest.update(MStr.getBytes());
            return RxTool.bytesToHexString(mDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return String.valueOf(MStr.hashCode());
        }
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static final int getResIdByName(Context context, String name, String defType) {
        return context.getResources().getIdentifier(name, defType, context.getPackageName());
    }

    public static boolean isFastClick(int millisecond) {
        long curClickTime = System.currentTimeMillis();
        long interval = curClickTime - lastClickTime;
        if (0L < interval && interval < (long)millisecond) {
            return true;
        }
        lastClickTime = curClickTime;
        return false;
    }

    public static void setEdTwoDecimal(EditText editText) {
        RxTool.setEdDecimal(editText, 2);
    }

    public static void setEdType(final EditText editText) {
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                String str;
                String editable = editText.getText().toString();
                if (!editable.equals(str = RxTool.stringFilter(editable))) {
                    editText.setText((CharSequence)str);
                    editText.setSelection(str.length());
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    public static String stringFilter(String str) throws PatternSyntaxException {
        String regEx = "[^0-9\u4e00-\u9fa5]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static void setEdDecimal(EditText editText, int count) {
        if (count < 0) {
            count = 0;
        }
        editText.setInputType(8194);
        final int finalCount = ++count;
        editText.setFilters(new InputFilter[]{new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                if (".".contentEquals(source) && dest.toString().length() == 0) {
                    return "0.";
                }
                if (dest.toString().contains(".")) {
                    int index = dest.toString().indexOf(".");
                    int mlength = dest.toString().substring(index).length();
                    if (mlength == finalCount) {
                        return "";
                    }
                }
                if (dest.toString().equals("0") && source.equals("0")) {
                    return "";
                }
                return null;
            }
        }});
    }

    public static void setEditNumberAuto(final EditText editText, final int number, final boolean isStartForZero) {
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    RxTool.setEditNumber(editText, number, isStartForZero);
                }
            }
        });
    }

    public static void setEditNumber(EditText editText, int number, boolean isStartForZero) {
        int i;
        StringBuilder s = new StringBuilder(editText.getText().toString());
        StringBuilder temp = new StringBuilder();
        for (i = s.length(); i < number; ++i) {
            s.insert(0, "0");
        }
        if (!isStartForZero) {
            for (i = 0; i < number; ++i) {
                temp.append("0");
            }
            if (s.toString().equals(temp.toString())) {
                s = new StringBuilder(temp.substring(1) + "1");
            }
        }
        editText.setText((CharSequence)s.toString());
    }

    public static Handler getBackgroundHandler() {
        HandlerThread thread = new HandlerThread("background");
        thread.start();
        return new Handler(thread.getLooper());
    }

    public static void initFastClickAndVibrate(Context mContext, OnDoListener onRxSimple) {
        if (RxTool.isFastClick(100)) {
            RxToast.normal("\u8bf7\u4e0d\u8981\u91cd\u590d\u70b9\u51fb");
            return;
        }
        RxVibrateTool.vibrateOnce(mContext, 100);
        onRxSimple.doSomething();
    }
}

