/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.content.Context;
import android.util.Log;
import com.tamsiree.rxkit.RxDataTool;
import com.tamsiree.rxkit.RxFileTool;
import com.tamsiree.rxkit.RxTimeTool;
import com.tamsiree.rxkit.RxTool;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class RxLogTool {
    private static final SimpleDateFormat LOG_FORMAT = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5_HH\u70b9mm\u5206ss\u79d2");
    private static final SimpleDateFormat FILE_SUFFIX = new SimpleDateFormat("HH\u70b9mm\u5206ss\u79d2");
    private static final SimpleDateFormat FILE_DIR = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
    private static Boolean LOG_SWITCH = true;
    private static Boolean LOG_TO_FILE = true;
    private static String LOG_TAG = "RxLogTool";
    private static char LOG_TYPE = (char)118;
    private static int LOG_SAVE_DAYS = 7;
    private static String LOG_FILE_PATH;
    private static String LOG_FILE_NAME;

    public static void init(Context context) {
        LOG_FILE_PATH = RxFileTool.getRootPath().getPath() + File.separator + context.getPackageName() + File.separator + "Log";
        LOG_FILE_NAME = "RxLogTool_";
    }

    public static File w(Object msg) {
        return RxLogTool.w(LOG_TAG, msg);
    }

    public static File w(String tag, Object msg) {
        return RxLogTool.w(tag, msg, null);
    }

    public static File w(String tag, Object msg, Throwable tr) {
        return RxLogTool.log(tag, msg.toString(), tr, 'w');
    }

    public static File e(Object msg) {
        return RxLogTool.e(LOG_TAG, msg);
    }

    public static File e(String tag, Object msg) {
        return RxLogTool.e(tag, msg, null);
    }

    public static File e(String tag, Object msg, Throwable tr) {
        return RxLogTool.log(tag, msg.toString(), tr, 'e');
    }

    public static File d(Object msg) {
        return RxLogTool.d(LOG_TAG, msg);
    }

    public static File d(String tag, Object msg) {
        return RxLogTool.d(tag, msg, null);
    }

    public static File d(String tag, Object msg, Throwable tr) {
        return RxLogTool.log(tag, msg.toString(), tr, 'd');
    }

    public static File i(Object msg) {
        return RxLogTool.i(LOG_TAG, msg);
    }

    public static File i(String tag, Object msg) {
        return RxLogTool.i(tag, msg, null);
    }

    public static File i(String tag, Object msg, Throwable tr) {
        return RxLogTool.log(tag, msg.toString(), tr, 'i');
    }

    public static File v(Object msg) {
        return RxLogTool.v(LOG_TAG, msg);
    }

    public static File v(String tag, Object msg) {
        return RxLogTool.v(tag, msg, null);
    }

    public static File v(String tag, Object msg, Throwable tr) {
        return RxLogTool.log(tag, msg.toString(), tr, 'v');
    }

    private static File log(String tag, String msg, Throwable tr, char level) {
        File logFile = new File("");
        if (LOG_SWITCH.booleanValue()) {
            if ('e' == level && ('e' == LOG_TYPE || 'v' == LOG_TYPE)) {
                Log.e((String)tag, (String)msg, (Throwable)tr);
            } else if ('w' == level && ('w' == LOG_TYPE || 'v' == LOG_TYPE)) {
                Log.w((String)tag, (String)msg, (Throwable)tr);
            } else if ('d' == level && ('d' == LOG_TYPE || 'v' == LOG_TYPE)) {
                Log.d((String)tag, (String)msg, (Throwable)tr);
            } else if ('i' == level && ('d' == LOG_TYPE || 'v' == LOG_TYPE)) {
                Log.i((String)tag, (String)msg, (Throwable)tr);
            } else {
                Log.v((String)tag, (String)msg, (Throwable)tr);
            }
            if (LOG_TO_FILE.booleanValue()) {
                String content = "";
                if (!RxDataTool.isNullString(msg)) {
                    content = content + msg;
                }
                if (tr != null) {
                    content = content + "\n";
                    content = content + Log.getStackTraceString((Throwable)tr);
                }
                logFile = RxLogTool.log2File(String.valueOf(level), tag, content);
            }
        }
        return logFile;
    }

    private static synchronized File log2File(String mylogtype, String tag, String text) {
        Date nowtime = new Date();
        String date = FILE_SUFFIX.format(nowtime);
        String dateLogContent = "Date:" + LOG_FORMAT.format(nowtime) + "\nLogType:" + mylogtype + "\nTag:" + tag + "\nContent:\n" + text;
        String path = LOG_FILE_PATH + File.separator + FILE_DIR.format(nowtime);
        File destDir = new File(path);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File file = new File(path, LOG_FILE_NAME + date + ".txt");
        try {
            FileWriter filerWriter = new FileWriter(file, true);
            BufferedWriter bufWriter = new BufferedWriter(filerWriter);
            bufWriter.write(dateLogContent);
            bufWriter.newLine();
            bufWriter.close();
            filerWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static void delAllLogFile() {
        RxFileTool.deleteDir(LOG_FILE_PATH);
    }

    private static Date getDateBefore() {
        Date nowtime = new Date();
        Calendar now = Calendar.getInstance();
        now.setTime(nowtime);
        now.set(5, now.get(5) - LOG_SAVE_DAYS);
        return now.getTime();
    }

    public static void saveLogFile(String message) {
        File fileDir = new File(RxFileTool.getRootPath() + File.separator + RxTool.getContext().getPackageName());
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        File file = new File(fileDir, RxTimeTool.getCurrentDateTime("yyyyMMdd") + ".txt");
        try {
            if (file.exists()) {
                PrintStream ps = new PrintStream(new FileOutputStream(file, true));
                ps.append(RxTimeTool.getCurrentDateTime("\n\n\nyyyy-MM-dd HH:mm:ss") + "\n" + message);
            } else {
                PrintStream ps = new PrintStream(new FileOutputStream(file));
                file.createNewFile();
                ps.println(RxTimeTool.getCurrentDateTime("yyyy-MM-dd HH:mm:ss") + "\n" + message);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

