/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.Log;
import com.tamsiree.rxkit.RxDataTool;
import com.tamsiree.rxkit.RxEncryptTool;
import com.tamsiree.rxkit.RxFileTool;
import com.tamsiree.rxkit.RxIntentTool;
import com.tamsiree.rxkit.RxProcessTool;
import com.tamsiree.rxkit.RxShellTool;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class RxAppTool {
    public static void installApp(Context context, String filePath) {
        context.startActivity(RxIntentTool.getInstallAppIntent(context, filePath));
    }

    public static void installApp(Context context, File file) {
        if (!RxFileTool.isFileExists(file)) {
            return;
        }
        RxAppTool.installApp(context, file.getAbsolutePath());
    }

    public static void installApp(Activity activity, String filePath, int requestCode) {
        activity.startActivityForResult(RxIntentTool.getInstallAppIntent((Context)activity, filePath), requestCode);
    }

    public static void installApp(Activity activity, File file, int requestCode) {
        if (!RxFileTool.isFileExists(file)) {
            return;
        }
        RxAppTool.installApp(activity, file.getAbsolutePath(), requestCode);
    }

    public static boolean installAppSilent(Context context, String filePath) {
        File file = RxFileTool.getFileByPath(filePath);
        if (!RxFileTool.isFileExists(file)) {
            return false;
        }
        String command = "LD_LIBRARY_PATH=/vendor/lib:/system/lib pm install " + filePath;
        RxShellTool.CommandResult commandResult = RxShellTool.execCmd(command, !RxAppTool.isSystemApp(context), true);
        return commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success");
    }

    public static boolean isSystemApp(Context context) {
        return RxAppTool.isSystemApp(context, context.getPackageName());
    }

    public static boolean isSystemApp(Context context, String packageName) {
        if (RxDataTool.isNullString(packageName)) {
            return false;
        }
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
            return ai != null && (ai.flags & 1) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void uninstallApp(Context context, String packageName) {
        if (RxDataTool.isNullString(packageName)) {
            return;
        }
        context.startActivity(RxIntentTool.getUninstallAppIntent(packageName));
    }

    public static void uninstallApp(Activity activity, String packageName, int requestCode) {
        if (RxDataTool.isNullString(packageName)) {
            return;
        }
        activity.startActivityForResult(RxIntentTool.getUninstallAppIntent(packageName), requestCode);
    }

    public static boolean uninstallAppSilent(Context context, String packageName, boolean isKeepData) {
        if (RxDataTool.isNullString(packageName)) {
            return false;
        }
        String command = "LD_LIBRARY_PATH=/vendor/lib:/system/lib pm uninstall " + (isKeepData ? "-k " : "") + packageName;
        RxShellTool.CommandResult commandResult = RxShellTool.execCmd(command, !RxAppTool.isSystemApp(context), true);
        return commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success");
    }

    public static boolean isAppRoot() {
        RxShellTool.CommandResult result = RxShellTool.execCmd("echo root", true);
        if (result.result == 0) {
            return true;
        }
        if (result.errorMsg != null) {
            Log.d((String)"isAppRoot", (String)result.errorMsg);
        }
        return false;
    }

    public static void launchApp(Context context, String packageName) {
        if (RxDataTool.isNullString(packageName)) {
            return;
        }
        context.startActivity(RxIntentTool.getLaunchAppIntent(context, packageName));
    }

    public static void launchApp(Activity activity, String packageName, int requestCode) {
        if (RxDataTool.isNullString(packageName)) {
            return;
        }
        activity.startActivityForResult(RxIntentTool.getLaunchAppIntent((Context)activity, packageName), requestCode);
    }

    public static String getAppPackageName(Context context) {
        return context.getPackageName();
    }

    public static void getAppDetailsSettings(Context context) {
        RxAppTool.getAppDetailsSettings(context, context.getPackageName());
    }

    public static void getAppDetailsSettings(Context context, String packageName) {
        if (RxDataTool.isNullString(packageName)) {
            return;
        }
        context.startActivity(RxIntentTool.getAppDetailsSettingsIntent(packageName));
    }

    public static String getAppName(Context context) {
        return RxAppTool.getAppName(context, context.getPackageName());
    }

    public static String getAppName(Context context, String packageName) {
        if (RxDataTool.isNullString(packageName)) {
            return null;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.loadLabel(pm).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Drawable getAppIcon(Context context) {
        return RxAppTool.getAppIcon(context, context.getPackageName());
    }

    public static Drawable getAppIcon(Context context, String packageName) {
        if (RxDataTool.isNullString(packageName)) {
            return null;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.loadIcon(pm);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppPath(Context context) {
        return RxAppTool.getAppPath(context, context.getPackageName());
    }

    public static String getAppPath(Context context, String packageName) {
        if (RxDataTool.isNullString(packageName)) {
            return null;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.sourceDir;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppVersionName(Context context) {
        return RxAppTool.getAppVersionName(context, context.getPackageName());
    }

    public static String getAppVersionName(Context context, String packageName) {
        if (RxDataTool.isNullString(packageName)) {
            return null;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getAppVersionCode(Context context) {
        return RxAppTool.getAppVersionCode(context, context.getPackageName());
    }

    public static int getAppVersionCode(Context context, String packageName) {
        if (RxDataTool.isNullString(packageName)) {
            return -1;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? -1 : pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static boolean isAppDebug(Context context) {
        return RxAppTool.isAppDebug(context, context.getPackageName());
    }

    public static boolean isAppDebug(Context context, String packageName) {
        if (RxDataTool.isNullString(packageName)) {
            return false;
        }
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
            return ai != null && (ai.flags & 2) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Signature[] getAppSignature(Context context) {
        return RxAppTool.getAppSignature(context, context.getPackageName());
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    public static Signature[] getAppSignature(Context context, String packageName) {
        if (RxDataTool.isNullString(packageName)) {
            return null;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 64);
            return pi == null ? null : pi.signatures;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppSignatureSHA1(Context context) {
        return RxAppTool.getAppSignatureSHA1(context, context.getPackageName());
    }

    public static String getAppSignatureSHA1(Context context, String packageName) {
        Signature[] signature = RxAppTool.getAppSignature(context, packageName);
        if (signature == null) {
            return null;
        }
        return RxEncryptTool.encryptSHA1ToString(signature[0].toByteArray()).replaceAll("(?<=[0-9A-F]{2})[0-9A-F]{2}", ":$0");
    }

    public static boolean isAppForeground(Context context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List infos = manager.getRunningAppProcesses();
        if (infos == null || infos.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            if (info.importance != 100) continue;
            return info.processName.equals(context.getPackageName());
        }
        return false;
    }

    public static boolean isAppForeground(Context context, String packageName) {
        return !RxDataTool.isNullString(packageName) && packageName.equals(RxProcessTool.getForegroundProcessName(context));
    }

    public static boolean isInstallApp(Context context, String packageName) {
        return !RxDataTool.isNullString(packageName) && RxIntentTool.getLaunchAppIntent(context, packageName) != null;
    }

    public static void InstallAPK(Context context, String APK_PATH) {
        Intent i = new Intent("android.intent.action.VIEW");
        i.setFlags(0x10000000);
        i.setDataAndType(Uri.parse((String)("file://" + APK_PATH)), "application/vnd.android.package-archive");
        context.startActivity(i);
    }

    public static AppInfo getAppInfo(Context context) {
        PackageManager pm = context.getPackageManager();
        PackageInfo pi = null;
        try {
            pi = pm.getPackageInfo(context.getApplicationContext().getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return pi != null ? RxAppTool.getBean(pm, pi) : null;
    }

    private static AppInfo getBean(PackageManager pm, PackageInfo pi) {
        ApplicationInfo ai = pi.applicationInfo;
        String name = ai.loadLabel(pm).toString();
        Drawable icon = ai.loadIcon(pm);
        String packageName = pi.packageName;
        String packagePath = ai.sourceDir;
        String versionName = pi.versionName;
        int versionCode = pi.versionCode;
        boolean isSD = (1 & ai.flags) != 1;
        boolean isUser = (1 & ai.flags) != 1;
        return new AppInfo(name, icon, packageName, packagePath, versionName, versionCode, isSD, isUser);
    }

    public static List<AppInfo> getAllAppsInfo(Context context) {
        ArrayList<AppInfo> list = new ArrayList<AppInfo>();
        PackageManager pm = context.getPackageManager();
        List installedPackages = pm.getInstalledPackages(0);
        for (PackageInfo pi : installedPackages) {
            if (pi == null) continue;
            list.add(RxAppTool.getBean(pm, pi));
        }
        return list;
    }

    public static boolean isAppBackground(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List tasks = am.getRunningTasks(1);
        if (!tasks.isEmpty()) {
            ComponentName topActivity = ((ActivityManager.RunningTaskInfo)tasks.get((int)0)).topActivity;
            return !topActivity.getPackageName().equals(context.getPackageName());
        }
        return false;
    }

    public static boolean cleanAppData(Context context, String ... dirPaths) {
        File[] dirs = new File[dirPaths.length];
        int i = 0;
        for (String dirPath : dirPaths) {
            dirs[i++] = new File(dirPath);
        }
        return RxAppTool.cleanAppData(context, dirs);
    }

    public static boolean cleanAppData(Context context, File ... dirs) {
        boolean isSuccess = RxFileTool.cleanInternalCache(context);
        isSuccess &= RxFileTool.cleanInternalDbs(context);
        isSuccess &= RxFileTool.cleanInternalSP(context);
        isSuccess &= RxFileTool.cleanInternalFiles(context);
        isSuccess &= RxFileTool.cleanExternalCache(context);
        for (File dir : dirs) {
            isSuccess &= RxFileTool.cleanCustomCache(dir);
        }
        return isSuccess;
    }

    public static class AppInfo {
        private String name;
        private Drawable icon;
        private String packageName;
        private String packagePath;
        private String versionName;
        private int versionCode;
        private boolean isSD;
        private boolean isUser;

        public AppInfo(String name, Drawable icon, String packageName, String packagePath, String versionName, int versionCode, boolean isSD, boolean isUser) {
            this.setName(name);
            this.setIcon(icon);
            this.setPackageName(packageName);
            this.setPackagePath(packagePath);
            this.setVersionName(versionName);
            this.setVersionCode(versionCode);
            this.setSD(isSD);
            this.setUser(isUser);
        }

        public Drawable getIcon() {
            return this.icon;
        }

        public void setIcon(Drawable icon) {
            this.icon = icon;
        }

        public boolean isSD() {
            return this.isSD;
        }

        public void setSD(boolean SD) {
            this.isSD = SD;
        }

        public boolean isUser() {
            return this.isUser;
        }

        public void setUser(boolean user) {
            this.isUser = user;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packagName) {
            this.packageName = packagName;
        }

        public String getPackagePath() {
            return this.packagePath;
        }

        public void setPackagePath(String packagePath) {
            this.packagePath = packagePath;
        }

        public int getVersionCode() {
            return this.versionCode;
        }

        public void setVersionCode(int versionCode) {
            this.versionCode = versionCode;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public void setVersionName(String versionName) {
            this.versionName = versionName;
        }
    }
}

