/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxtool.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.CheckResult;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import com.tamsiree.rxtool.R;
import com.tamsiree.rxtool.RxTool;

@SuppressLint(value={"InflateParams"})
public class RxToast {
    @ColorInt
    private static final int DEFAULT_TEXT_COLOR = Color.parseColor((String)"#FFFFFF");
    @ColorInt
    private static final int ERROR_COLOR = Color.parseColor((String)"#FD4C5B");
    @ColorInt
    private static final int INFO_COLOR = Color.parseColor((String)"#3F51B5");
    @ColorInt
    private static final int SUCCESS_COLOR = Color.parseColor((String)"#388E3C");
    @ColorInt
    private static final int WARNING_COLOR = Color.parseColor((String)"#FFA900");
    private static final String TOAST_TYPEFACE = "sans-serif-condensed";
    private static Toast currentToast;
    private static Toast mToast;
    private static long mExitTime;

    public static void normal(@NonNull String message) {
        RxToast.normal(RxTool.getContext(), message, 0, null, false).show();
    }

    public static void normal(@NonNull String message, Drawable icon) {
        RxToast.normal(RxTool.getContext(), message, 0, icon, true).show();
    }

    public static void normal(@NonNull String message, int duration) {
        RxToast.normal(RxTool.getContext(), message, duration, null, false).show();
    }

    public static void normal(@NonNull String message, int duration, Drawable icon) {
        RxToast.normal(RxTool.getContext(), message, duration, icon, true).show();
    }

    public static Toast normal(@NonNull String message, int duration, Drawable icon, boolean withIcon) {
        return RxToast.custom(RxTool.getContext(), message, icon, DEFAULT_TEXT_COLOR, duration, withIcon);
    }

    public static void warning(@NonNull String message) {
        RxToast.warning(RxTool.getContext(), message, 0, true).show();
    }

    public static void warning(@NonNull String message, int duration) {
        RxToast.warning(RxTool.getContext(), message, duration, true).show();
    }

    public static Toast warning(@NonNull String message, int duration, boolean withIcon) {
        return RxToast.custom(RxTool.getContext(), message, RxToast.getDrawable(RxTool.getContext(), R.drawable.ic_error_outline_white_48dp), DEFAULT_TEXT_COLOR, WARNING_COLOR, duration, withIcon, true);
    }

    public static void info(@NonNull String message) {
        RxToast.info(RxTool.getContext(), message, 0, true).show();
    }

    public static void info(@NonNull String message, int duration) {
        RxToast.info(RxTool.getContext(), message, duration, true).show();
    }

    public static Toast info(@NonNull String message, int duration, boolean withIcon) {
        return RxToast.custom(RxTool.getContext(), message, RxToast.getDrawable(RxTool.getContext(), R.drawable.ic_info_outline_white_48dp), DEFAULT_TEXT_COLOR, INFO_COLOR, duration, withIcon, true);
    }

    public static void success(@NonNull String message) {
        RxToast.success(RxTool.getContext(), message, 0, true).show();
    }

    public static void success(@NonNull String message, int duration) {
        RxToast.success(RxTool.getContext(), message, duration, true).show();
    }

    public static Toast success(@NonNull String message, int duration, boolean withIcon) {
        return RxToast.custom(RxTool.getContext(), message, RxToast.getDrawable(RxTool.getContext(), R.drawable.ic_check_white_48dp), DEFAULT_TEXT_COLOR, SUCCESS_COLOR, duration, withIcon, true);
    }

    public static void error(@NonNull String message) {
        RxToast.error(RxTool.getContext(), message, 0, true).show();
    }

    public static void error(@NonNull String message, int duration) {
        RxToast.error(RxTool.getContext(), message, duration, true).show();
    }

    public static Toast error(@NonNull String message, int duration, boolean withIcon) {
        return RxToast.custom(RxTool.getContext(), message, RxToast.getDrawable(RxTool.getContext(), R.drawable.ic_clear_white_48dp), DEFAULT_TEXT_COLOR, ERROR_COLOR, duration, withIcon, true);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull String message) {
        return RxToast.normal(context, message, 0, null, false);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull String message, Drawable icon) {
        return RxToast.normal(context, message, 0, icon, true);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull String message, int duration) {
        return RxToast.normal(context, message, duration, null, false);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull String message, int duration, Drawable icon) {
        return RxToast.normal(context, message, duration, icon, true);
    }

    @CheckResult
    public static Toast normal(@NonNull Context context, @NonNull String message, int duration, Drawable icon, boolean withIcon) {
        return RxToast.custom(context, message, icon, DEFAULT_TEXT_COLOR, duration, withIcon);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @NonNull String message) {
        return RxToast.warning(context, message, 0, true);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @NonNull String message, int duration) {
        return RxToast.warning(context, message, duration, true);
    }

    @CheckResult
    public static Toast warning(@NonNull Context context, @NonNull String message, int duration, boolean withIcon) {
        return RxToast.custom(context, message, RxToast.getDrawable(context, R.drawable.ic_error_outline_white_48dp), DEFAULT_TEXT_COLOR, WARNING_COLOR, duration, withIcon, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @NonNull String message) {
        return RxToast.info(context, message, 0, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @NonNull String message, int duration) {
        return RxToast.info(context, message, duration, true);
    }

    @CheckResult
    public static Toast info(@NonNull Context context, @NonNull String message, int duration, boolean withIcon) {
        return RxToast.custom(context, message, RxToast.getDrawable(context, R.drawable.ic_info_outline_white_48dp), DEFAULT_TEXT_COLOR, INFO_COLOR, duration, withIcon, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @NonNull String message) {
        return RxToast.success(context, message, 0, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @NonNull String message, int duration) {
        return RxToast.success(context, message, duration, true);
    }

    @CheckResult
    public static Toast success(@NonNull Context context, @NonNull String message, int duration, boolean withIcon) {
        return RxToast.custom(context, message, RxToast.getDrawable(context, R.drawable.ic_check_white_48dp), DEFAULT_TEXT_COLOR, SUCCESS_COLOR, duration, withIcon, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @NonNull String message) {
        return RxToast.error(context, message, 0, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @NonNull String message, int duration) {
        return RxToast.error(context, message, duration, true);
    }

    @CheckResult
    public static Toast error(@NonNull Context context, @NonNull String message, int duration, boolean withIcon) {
        return RxToast.custom(context, message, RxToast.getDrawable(context, R.drawable.ic_clear_white_48dp), DEFAULT_TEXT_COLOR, ERROR_COLOR, duration, withIcon, true);
    }

    @CheckResult
    public static Toast custom(@NonNull Context context, @NonNull String message, Drawable icon, @ColorInt int textColor, int duration, boolean withIcon) {
        return RxToast.custom(context, message, icon, textColor, -1, duration, withIcon, false);
    }

    @CheckResult
    public static Toast custom(@NonNull Context context, @NonNull String message, @DrawableRes int iconRes, @ColorInt int textColor, @ColorInt int tintColor, int duration, boolean withIcon, boolean shouldTint) {
        return RxToast.custom(context, message, RxToast.getDrawable(context, iconRes), textColor, tintColor, duration, withIcon, shouldTint);
    }

    @CheckResult
    public static Toast custom(@NonNull Context context, @NonNull String message, Drawable icon, @ColorInt int textColor, @ColorInt int tintColor, int duration, boolean withIcon, boolean shouldTint) {
        if (currentToast == null) {
            currentToast = new Toast(context);
        } else {
            currentToast.cancel();
            currentToast = null;
            currentToast = new Toast(context);
        }
        View toastLayout = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(R.layout.toast_layout, null);
        ImageView toastIcon = (ImageView)toastLayout.findViewById(R.id.toast_icon);
        TextView toastTextView = (TextView)toastLayout.findViewById(R.id.toast_text);
        Drawable drawableFrame = shouldTint ? RxToast.tint9PatchDrawableFrame(context, tintColor) : RxToast.getDrawable(context, R.drawable.toast_frame);
        RxToast.setBackground(toastLayout, drawableFrame);
        if (withIcon) {
            if (icon == null) {
                throw new IllegalArgumentException("Avoid passing 'icon' as null if 'withIcon' is set to true");
            }
            RxToast.setBackground((View)toastIcon, icon);
        } else {
            toastIcon.setVisibility(8);
        }
        toastTextView.setTextColor(textColor);
        toastTextView.setText((CharSequence)message);
        toastTextView.setTypeface(Typeface.create((String)TOAST_TYPEFACE, (int)0));
        currentToast.setView(toastLayout);
        currentToast.setDuration(duration);
        return currentToast;
    }

    public static final Drawable tint9PatchDrawableFrame(@NonNull Context context, @ColorInt int tintColor) {
        NinePatchDrawable toastDrawable = (NinePatchDrawable)RxToast.getDrawable(context, R.drawable.toast_frame);
        toastDrawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(tintColor, PorterDuff.Mode.SRC_IN));
        return toastDrawable;
    }

    public static final void setBackground(@NonNull View view, Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable2);
        } else {
            view.setBackgroundDrawable(drawable2);
        }
    }

    public static final Drawable getDrawable(@NonNull Context context, @DrawableRes int id2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(id2);
        }
        return context.getResources().getDrawable(id2);
    }

    public static void showToast(Context context, String str, boolean isLong) {
        if (isLong) {
            Toast.makeText((Context)context, (CharSequence)str, (int)1).show();
        } else {
            Toast.makeText((Context)context, (CharSequence)str, (int)0).show();
        }
    }

    public static void showToastShort(String str) {
        Toast.makeText((Context)RxTool.getContext(), (CharSequence)str, (int)0).show();
    }

    public static void showToastShort(int resId) {
        Toast.makeText((Context)RxTool.getContext(), (CharSequence)RxTool.getContext().getString(resId), (int)0).show();
    }

    public static void showToastLong(String str) {
        Toast.makeText((Context)RxTool.getContext(), (CharSequence)str, (int)1).show();
    }

    public static void showToastLong(int resId) {
        Toast.makeText((Context)RxTool.getContext(), (CharSequence)RxTool.getContext().getString(resId), (int)1).show();
    }

    public static void showToast(String msg) {
        if (mToast == null) {
            mToast = Toast.makeText((Context)RxTool.getContext(), (CharSequence)msg, (int)1);
        } else {
            mToast.setText((CharSequence)msg);
        }
        mToast.show();
    }

    @SuppressLint(value={"ShowToast"})
    public static void showToast(int resId) {
        if (mToast == null) {
            mToast = Toast.makeText((Context)RxTool.getContext(), (CharSequence)RxTool.getContext().getString(resId), (int)1);
        } else {
            mToast.setText((CharSequence)RxTool.getContext().getString(resId));
        }
        mToast.show();
    }

    public static void showToast(Context context, int resId, int duration) {
        RxToast.showToast(context, context.getString(resId), duration);
    }

    @SuppressLint(value={"ShowToast"})
    public static void showToast(Context context, String msg, int duration) {
        if (mToast == null) {
            mToast = Toast.makeText((Context)context, (CharSequence)msg, (int)duration);
        } else {
            mToast.setText((CharSequence)msg);
        }
        mToast.show();
    }

    public static boolean doubleClickExit() {
        if (System.currentTimeMillis() - mExitTime > 2000L) {
            RxToast.normal("\u518d\u6309\u4e00\u6b21\u9000\u51fa");
            mExitTime = System.currentTimeMillis();
            return false;
        }
        return true;
    }
}

