/*
 * Decompiled with CFR 0.152.
 */
package com.vondear.rxtool.module.photomagic;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.vondear.rxtool.module.photomagic.Checker;
import com.vondear.rxtool.module.photomagic.Engine;
import com.vondear.rxtool.module.photomagic.OnCompressListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RxMagic
implements Handler.Callback {
    private static final String TAG = "RxMagic";
    private static final String DEFAULT_DISK_CACHE_DIR = "rxmagic_disk_cache";
    private static final int MSG_COMPRESS_SUCCESS = 0;
    private static final int MSG_COMPRESS_START = 1;
    private static final int MSG_COMPRESS_ERROR = 2;
    private String mTargetDir;
    private List<String> mPaths;
    private int mLeastCompressSize;
    private OnCompressListener mCompressListener;
    private Handler mHandler;

    private RxMagic(Builder builder) {
        this.mPaths = builder.mPaths;
        this.mTargetDir = builder.mTargetDir;
        this.mCompressListener = builder.mCompressListener;
        this.mLeastCompressSize = builder.mLeastCompressSize;
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    public static Builder with(Context context) {
        return new Builder(context);
    }

    private File getImageCacheFile(Context context, String suffix) {
        if (TextUtils.isEmpty((CharSequence)this.mTargetDir)) {
            this.mTargetDir = this.getImageCacheDir(context).getAbsolutePath();
        }
        String cacheBuilder = this.mTargetDir + "/" + System.currentTimeMillis() + (int)(Math.random() * 1000.0) + (TextUtils.isEmpty((CharSequence)suffix) ? ".jpg" : suffix);
        return new File(cacheBuilder);
    }

    @Nullable
    private File getImageCacheDir(Context context) {
        return this.getImageCacheDir(context, DEFAULT_DISK_CACHE_DIR);
    }

    @Nullable
    private File getImageCacheDir(Context context, String cacheName) {
        File cacheDir = context.getExternalCacheDir();
        if (cacheDir != null) {
            File result = new File(cacheDir, cacheName);
            if (!(result.mkdirs() || result.exists() && result.isDirectory())) {
                return null;
            }
            return result;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return null;
    }

    @UiThread
    private void launch(final Context context) {
        if (this.mPaths == null || this.mPaths.size() == 0 && this.mCompressListener != null) {
            this.mCompressListener.onError(new NullPointerException("image file cannot be null"));
        }
        Iterator<String> iterator = this.mPaths.iterator();
        while (iterator.hasNext()) {
            final String path = iterator.next();
            if (Checker.isImage(path)) {
                AsyncTask.SERIAL_EXECUTOR.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RxMagic.this.mHandler.sendMessage(RxMagic.this.mHandler.obtainMessage(1));
                            File result = Checker.isNeedCompress(RxMagic.this.mLeastCompressSize, path) ? new Engine(path, RxMagic.this.getImageCacheFile(context, Checker.checkSuffix(path))).compress() : new File(path);
                            RxMagic.this.mHandler.sendMessage(RxMagic.this.mHandler.obtainMessage(0, (Object)result));
                        }
                        catch (IOException e) {
                            RxMagic.this.mHandler.sendMessage(RxMagic.this.mHandler.obtainMessage(2, (Object)e));
                        }
                    }
                });
            } else {
                this.mCompressListener.onError(new IllegalArgumentException("can not read the path : " + path));
            }
            iterator.remove();
        }
    }

    @WorkerThread
    private File get(String path, Context context) throws IOException {
        return new Engine(path, this.getImageCacheFile(context, Checker.checkSuffix(path))).compress();
    }

    @WorkerThread
    private List<File> get(Context context) throws IOException {
        ArrayList<File> results = new ArrayList<File>();
        Iterator<String> iterator = this.mPaths.iterator();
        while (iterator.hasNext()) {
            String path = iterator.next();
            if (Checker.isImage(path)) {
                results.add(new Engine(path, this.getImageCacheFile(context, Checker.checkSuffix(path))).compress());
            }
            iterator.remove();
        }
        return results;
    }

    public boolean handleMessage(Message msg) {
        if (this.mCompressListener == null) {
            return false;
        }
        switch (msg.what) {
            case 1: {
                this.mCompressListener.onStart();
                break;
            }
            case 0: {
                this.mCompressListener.onSuccess((File)msg.obj);
                break;
            }
            case 2: {
                this.mCompressListener.onError((Throwable)msg.obj);
                break;
            }
        }
        return false;
    }

    public static class Builder {
        private Context context;
        private String mTargetDir;
        private List<String> mPaths;
        private int mLeastCompressSize = 100;
        private OnCompressListener mCompressListener;

        Builder(Context context) {
            this.context = context;
            this.mPaths = new ArrayList<String>();
        }

        private RxMagic build() {
            return new RxMagic(this);
        }

        public Builder load(File file) {
            this.mPaths.add(file.getAbsolutePath());
            return this;
        }

        public Builder load(String string) {
            this.mPaths.add(string);
            return this;
        }

        public Builder load(List<String> list) {
            this.mPaths.addAll(list);
            return this;
        }

        public Builder putGear(int gear) {
            return this;
        }

        public Builder setCompressListener(OnCompressListener listener) {
            this.mCompressListener = listener;
            return this;
        }

        public Builder setTargetDir(String targetDir) {
            this.mTargetDir = targetDir;
            return this;
        }

        public Builder ignoreBy(int size) {
            this.mLeastCompressSize = size;
            return this;
        }

        public void launch() {
            this.build().launch(this.context);
        }

        public File get(String path) throws IOException {
            return this.build().get(path, this.context);
        }

        public List<File> get() throws IOException {
            return this.build().get(this.context);
        }
    }
}

