/*
 * Decompiled with CFR 0.152.
 */
package com.vondear.rxtool;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.vondear.rxtool.RxDataTool;
import com.vondear.rxtool.RxFileTool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.progress.ProgressMonitor;

public class RxZipTool {
    public static boolean zipFiles(Collection<File> resFiles, String zipFilePath) throws IOException {
        return RxZipTool.zipFiles(resFiles, zipFilePath, null);
    }

    public static boolean zipFiles(Collection<File> resFiles, String zipFilePath, String comment) throws IOException {
        return RxZipTool.zipFiles(resFiles, RxFileTool.getFileByPath(zipFilePath), comment);
    }

    public static boolean zipFiles(Collection<File> resFiles, File zipFile) throws IOException {
        return RxZipTool.zipFiles(resFiles, zipFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zipFiles(Collection<File> resFiles, File zipFile, String comment) throws IOException {
        block8: {
            block6: {
                block7: {
                    if (resFiles == null || zipFile == null) {
                        return false;
                    }
                    zos = null;
                    try {
                        zos = new ZipOutputStream(new FileOutputStream(zipFile));
                        for (File resFile : resFiles) {
                            if (RxZipTool.zipFile(resFile, "", zos, comment)) continue;
                            var6_7 = false;
                            if (zos == null) break block6;
                            break block7;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var7_8) {
                        if (zos != null) {
                            zos.finish();
                            RxFileTool.closeIO(new Closeable[]{zos});
                        }
                        throw var7_8;
                    }
                }
                zos.finish();
                RxFileTool.closeIO(new Closeable[]{zos});
            }
            return var6_7;
lbl-1000:
            // 1 sources

            {
                var4_5 = true;
                if (zos == null) break block8;
            }
            zos.finish();
            RxFileTool.closeIO(new Closeable[]{zos});
        }
        return var4_5;
    }

    public static boolean zipFile(String resFilePath, String zipFilePath) throws IOException {
        return RxZipTool.zipFile(resFilePath, zipFilePath, null);
    }

    public static boolean zipFile(String resFilePath, String zipFilePath, String comment) throws IOException {
        return RxZipTool.zipFile(RxFileTool.getFileByPath(resFilePath), RxFileTool.getFileByPath(zipFilePath), comment);
    }

    public static boolean zipFile(File resFile, File zipFile) throws IOException {
        return RxZipTool.zipFile(resFile, zipFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipFile(File resFile, File zipFile, String comment) throws IOException {
        boolean bl;
        block4: {
            if (resFile == null || zipFile == null) {
                return false;
            }
            ZipOutputStream zos = null;
            try {
                zos = new ZipOutputStream(new FileOutputStream(zipFile));
                bl = RxZipTool.zipFile(resFile, "", zos, comment);
                if (zos == null) break block4;
            }
            catch (Throwable throwable) {
                if (zos != null) {
                    zos.finish();
                    RxFileTool.closeIO(zos);
                }
                throw throwable;
            }
            zos.finish();
            RxFileTool.closeIO(zos);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean zipFile(File resFile, String rootPath, ZipOutputStream zos, String comment) throws IOException {
        rootPath = rootPath + (RxDataTool.isNullString(rootPath) ? "" : File.separator) + resFile.getName();
        if (resFile.isDirectory()) {
            File[] fileList = resFile.listFiles();
            if (fileList.length <= 0) {
                ZipEntry entry = new ZipEntry(rootPath + '/');
                if (!RxDataTool.isNullString(comment)) {
                    entry.setComment(comment);
                }
                zos.putNextEntry(entry);
                zos.closeEntry();
                return true;
            }
            File[] entry = fileList;
            int n = entry.length;
            int n2 = 0;
            while (n2 < n) {
                File file = entry[n2];
                if (!RxZipTool.zipFile(file, rootPath, zos, comment)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        BufferedInputStream is = null;
        try {
            int len;
            is = new BufferedInputStream(new FileInputStream(resFile));
            ZipEntry entry = new ZipEntry(rootPath);
            if (!RxDataTool.isNullString(comment)) {
                entry.setComment(comment);
            }
            zos.putNextEntry(entry);
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)is).read(buffer, 0, 1024)) != -1) {
                zos.write(buffer, 0, len);
            }
            zos.closeEntry();
        }
        catch (Throwable throwable) {
            RxFileTool.closeIO(is);
            throw throwable;
        }
        RxFileTool.closeIO(is);
        return true;
    }

    public static boolean unzipFiles(Collection<File> zipFiles, String destDirPath) {
        return RxZipTool.unzipFiles(zipFiles, RxFileTool.getFileByPath(destDirPath));
    }

    public static boolean unzipFiles(Collection<File> zipFiles, File destDir) {
        if (zipFiles == null || destDir == null) {
            return false;
        }
        for (File zipFile : zipFiles) {
            if (RxZipTool.unzipFile(zipFile, destDir)) continue;
            return false;
        }
        return true;
    }

    public static boolean unzipFile(String zipFilePath, String destDirPath) {
        return RxZipTool.unzipFile(RxFileTool.getFileByPath(zipFilePath), RxFileTool.getFileByPath(destDirPath));
    }

    public static boolean unzipFile(File zipFile, File destDir) {
        return RxZipTool.unzipFileByKeyword(zipFile, destDir, null) != null;
    }

    public static List<File> unzipFileByKeyword(String zipFilePath, String destDirPath, String keyword) {
        return RxZipTool.unzipFileByKeyword(RxFileTool.getFileByPath(zipFilePath), RxFileTool.getFileByPath(destDirPath), keyword);
    }

    public static List<File> unzipFileByKeyword(File zipFile, File destDir, String passwd) {
        try {
            if (zipFile == null) {
                throw new ZipException("\u538b\u7f29\u6587\u4ef6\u4e0d\u5b58\u5728.");
            }
            if (destDir == null) {
                throw new ZipException("\u89e3\u538b\u7f29\u8def\u5f84\u4e0d\u5b58\u5728.");
            }
            if (destDir.isDirectory() && !destDir.exists()) {
                destDir.mkdir();
            }
            ZipFile zFile = new ZipFile(zipFile);
            zFile.setFileNameCharset("UTF-8");
            if (!zFile.isValidZipFile()) {
                throw new ZipException("\u538b\u7f29\u6587\u4ef6\u4e0d\u5408\u6cd5,\u53ef\u80fd\u88ab\u635f\u574f.");
            }
            if (zFile.isEncrypted()) {
                zFile.setPassword(passwd.toCharArray());
            }
            zFile.extractAll(destDir.getAbsolutePath());
            List headerList = zFile.getFileHeaders();
            ArrayList<File> extractedFileList = new ArrayList<File>();
            for (FileHeader fileHeader : headerList) {
                if (fileHeader.isDirectory()) continue;
                extractedFileList.add(new File(destDir, fileHeader.getFileName()));
            }
            return extractedFileList;
        }
        catch (ZipException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> getFilesPath(String zipFilePath) throws IOException {
        return RxZipTool.getFilesPath(RxFileTool.getFileByPath(zipFilePath));
    }

    public static List<String> getFilesPath(File zipFile) throws IOException {
        if (zipFile == null) {
            return null;
        }
        ArrayList<String> paths = new ArrayList<String>();
        Enumeration<?> entries = RxZipTool.getEntries(zipFile);
        while (entries.hasMoreElements()) {
            paths.add(((ZipEntry)entries.nextElement()).getName());
        }
        return paths;
    }

    public static List<String> getComments(String zipFilePath) throws IOException {
        return RxZipTool.getComments(RxFileTool.getFileByPath(zipFilePath));
    }

    public static List<String> getComments(File zipFile) throws IOException {
        if (zipFile == null) {
            return null;
        }
        ArrayList<String> comments = new ArrayList<String>();
        Enumeration<?> entries = RxZipTool.getEntries(zipFile);
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)entries.nextElement();
            comments.add(entry.getComment());
        }
        return comments;
    }

    public static Enumeration<?> getEntries(String zipFilePath) throws IOException {
        return RxZipTool.getEntries(RxFileTool.getFileByPath(zipFilePath));
    }

    public static Enumeration<?> getEntries(File zipFile) throws IOException {
        if (zipFile == null) {
            return null;
        }
        return new java.util.zip.ZipFile(zipFile).entries();
    }

    public static boolean fileToZip(String sourceFilePath, String zipFilePath, String fileName) {
        boolean flag = false;
        File sourceFile = new File(sourceFilePath);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        if (sourceFile.exists()) {
            try {
                File zipFile = new File(zipFilePath + "/" + fileName + ".zip");
                if (zipFile.exists()) {
                    System.out.println(zipFilePath + "\u76ee\u5f55\u4e0b\u5b58\u5728\u540d\u5b57\u4e3a:" + fileName + ".zip\u6253\u5305\u6587\u4ef6.");
                }
                File[] sourceFiles = sourceFile.listFiles();
                if (null == sourceFiles || sourceFiles.length < 1) {
                    System.out.println("\u5f85\u538b\u7f29\u7684\u6587\u4ef6\u76ee\u5f55\uff1a" + sourceFilePath + "\u91cc\u9762\u4e0d\u5b58\u5728\u6587\u4ef6\uff0c\u65e0\u9700\u538b\u7f29.");
                }
                fos = new FileOutputStream(zipFile);
                zos = new ZipOutputStream(new BufferedOutputStream(fos));
                byte[] bufs = new byte[10240];
                for (int i = 0; i < sourceFiles.length; ++i) {
                    ZipEntry zipEntry = new ZipEntry(sourceFiles[i].getName());
                    fis = new FileInputStream(sourceFiles[i]);
                    bis = new BufferedInputStream(fis, 10240);
                    int read = 0;
                    while ((read = bis.read(bufs, 0, 10240)) != -1) {
                        zos.write(bufs, 0, read);
                    }
                }
                flag = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (null != bis) {
                        bis.close();
                    }
                    if (null != zos) {
                        zos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        } else {
            System.out.println("\u5f85\u538b\u7f29\u7684\u6587\u4ef6\u76ee\u5f55\uff1a" + sourceFilePath + "\u4e0d\u5b58\u5728.");
        }
        return flag;
    }

    public static String zipEncrypt(String src, String dest, boolean isCreateDir, String passwd) {
        File srcFile = new File(src);
        dest = RxZipTool.buildDestinationZipFilePath(srcFile, dest);
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        if (!RxDataTool.isNullString(passwd)) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(0);
            parameters.setPassword(passwd.toCharArray());
        }
        try {
            ZipFile zipFile = new ZipFile(dest);
            if (srcFile.isDirectory()) {
                if (!isCreateDir) {
                    File[] subFiles = srcFile.listFiles();
                    ArrayList temp = new ArrayList();
                    Collections.addAll(temp, subFiles);
                    zipFile.addFiles(temp, parameters);
                    return dest;
                }
                zipFile.addFolder(srcFile, parameters);
            } else {
                zipFile.addFile(srcFile, parameters);
            }
            return dest;
        }
        catch (ZipException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String buildDestinationZipFilePath(File srcFile, String destParam) {
        if (RxDataTool.isNullString(destParam)) {
            if (srcFile.isDirectory()) {
                destParam = srcFile.getParent() + File.separator + srcFile.getName() + ".zip";
            } else {
                String fileName = srcFile.getName().substring(0, srcFile.getName().lastIndexOf("."));
                destParam = srcFile.getParent() + File.separator + fileName + ".zip";
            }
        } else {
            RxZipTool.createDestDirectoryIfNecessary(destParam);
            if (destParam.endsWith(File.separator)) {
                String fileName = "";
                fileName = srcFile.isDirectory() ? srcFile.getName() : srcFile.getName().substring(0, srcFile.getName().lastIndexOf("."));
                destParam = destParam + fileName + ".zip";
            }
        }
        return destParam;
    }

    private static void createDestDirectoryIfNecessary(String destParam) {
        File destDir = null;
        destDir = destParam.endsWith(File.separator) ? new File(destParam) : new File(destParam.substring(0, destParam.lastIndexOf(File.separator)));
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
    }

    public static String zipEncryptRargo(String src, String dest, boolean isCreateDir, String passwd, int unit) {
        File srcFile = new File(src);
        dest = RxZipTool.buildDestinationZipFilePath(srcFile, dest);
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        if (!RxDataTool.isNullString(passwd)) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(0);
            parameters.setPassword(passwd.toCharArray());
        }
        try {
            ZipFile zipFile = new ZipFile(dest);
            if (srcFile.isDirectory()) {
                if (!isCreateDir) {
                    File[] subFiles = srcFile.listFiles();
                    ArrayList temp = new ArrayList();
                    Collections.addAll(temp, subFiles);
                    zipFile.createZipFile(temp, parameters, true, (long)(unit * 1000));
                    return dest;
                }
                zipFile.createZipFileFromFolder(srcFile, parameters, true, (long)(unit * 1000));
                int partsize = (int)RxZipTool.zipInfo(dest) / unit;
                System.out.println("\u5206\u5272\u6210\u529f\uff01\u603b\u5171\u5206\u5272\u6210\u4e86" + (partsize + 1) + "\u4e2a\u6587\u4ef6\uff01");
            } else {
                zipFile.createZipFile(srcFile, parameters, true, (long)(unit * 1000));
            }
            return dest;
        }
        catch (ZipException var9) {
            var9.printStackTrace();
            return null;
        }
    }

    public static double zipInfo(String zipFile) throws ZipException {
        ZipFile zip = new ZipFile(zipFile);
        zip.setFileNameCharset("GBK");
        List list = zip.getFileHeaders();
        long zipCompressedSize = 0L;
        for (FileHeader head : list) {
            zipCompressedSize += head.getCompressedSize();
        }
        double size = (double)zipCompressedSize / 1.0 / 1024.0;
        return size;
    }

    public static boolean removeDirFromZipArchive(String file, String removeDir) {
        try {
            FileHeader dirHeader;
            ZipFile zipFile = new ZipFile(file);
            zipFile.setFileNameCharset("GBK");
            if (!removeDir.endsWith(File.separator)) {
                removeDir = removeDir + File.separator;
            }
            if (null == (dirHeader = zipFile.getFileHeader(removeDir))) {
                return false;
            }
            List headersList = zipFile.getFileHeaders();
            ArrayList<String> removeHeaderNames = new ArrayList<String>();
            int len = headersList.size();
            for (int i = 0; i < len; ++i) {
                FileHeader subHeader = (FileHeader)headersList.get(i);
                if (!subHeader.getFileName().startsWith(dirHeader.getFileName()) || subHeader.getFileName().equals(dirHeader.getFileName())) continue;
                removeHeaderNames.add(subHeader.getFileName());
            }
            for (String headerNameString : removeHeaderNames) {
                zipFile.removeFile(headerNameString);
            }
            zipFile.removeFile(dirHeader);
            return true;
        }
        catch (ZipException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void Unzip(final File zipFile, String dest, String passwd, String charset, final Handler handler, final boolean isDeleteZipFile) {
        try {
            ZipFile zFile = new ZipFile(zipFile);
            if (TextUtils.isEmpty((CharSequence)charset)) {
                charset = "UTF-8";
            }
            zFile.setFileNameCharset(charset);
            if (!zFile.isValidZipFile()) {
                throw new ZipException("Compressed files are not illegal, may be damaged.");
            }
            File destDir = new File(dest);
            if (destDir.isDirectory() && !destDir.exists()) {
                destDir.mkdir();
            }
            if (zFile.isEncrypted()) {
                zFile.setPassword(passwd.toCharArray());
            }
            final ProgressMonitor progressMonitor = zFile.getProgressMonitor();
            Thread progressThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Bundle bundle = null;
                    Message msg = null;
                    try {
                        int percentDone = 0;
                        if (handler == null) {
                            return;
                        }
                        handler.sendEmptyMessage(0);
                        do {
                            Thread.sleep(1000L);
                            percentDone = progressMonitor.getPercentDone();
                            bundle = new Bundle();
                            bundle.putInt("PERCENT", percentDone);
                            msg = new Message();
                            msg.what = 1;
                            msg.setData(bundle);
                            handler.sendMessage(msg);
                        } while (percentDone < 100);
                        handler.sendEmptyMessage(2);
                    }
                    catch (InterruptedException e) {
                        bundle = new Bundle();
                        bundle.putString("ERROR", e.getMessage());
                        msg = new Message();
                        msg.what = 3;
                        msg.setData(bundle);
                        handler.sendMessage(msg);
                        e.printStackTrace();
                    }
                    finally {
                        if (isDeleteZipFile) {
                            zipFile.deleteOnExit();
                        }
                    }
                }
            });
            progressThread.start();
            zFile.setRunInThread(true);
            zFile.extractAll(dest);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
    }

    public class CompressKeys {
        public static final String PERCENT = "PERCENT";
        public static final String ERROR = "ERROR";
    }

    public class CompressStatus {
        public static final int START = 0;
        public static final int HANDLING = 1;
        public static final int COMPLETED = 2;
        public static final int ERROR = 3;
    }
}

