/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit.demodata.bank;

import com.tamsiree.rxkit.demodata.bank.BankCardNumberGenerator$Companion$WhenMappings;
import com.tamsiree.rxkit.demodata.bank.BankCardTypeEnum;
import com.tamsiree.rxkit.demodata.bank.BankNameEnum;
import com.tamsiree.rxkit.demodata.base.GenericGenerator;
import com.tamsiree.rxkit.demodata.kit.LuhnUtils;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/tamsiree/rxkit/demodata/bank/BankCardNumberGenerator;", "Lcom/tamsiree/rxkit/demodata/base/GenericGenerator;", "()V", "generate", "", "Companion", "RxKit_release"})
public final class BankCardNumberGenerator
extends GenericGenerator {
    @NotNull
    private static final GenericGenerator instance;
    public static final Companion Companion;

    @Override
    @NotNull
    public String generate() {
        Random random = this.getRandomInstance();
        int prev = 622126 + random.nextInt(800);
        return Companion.generateByPrefix(prev);
    }

    private BankCardNumberGenerator() {
    }

    static {
        Companion = new Companion(null);
        instance = new BankCardNumberGenerator();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/tamsiree/rxkit/demodata/bank/BankCardNumberGenerator$Companion;", "", "()V", "instance", "Lcom/tamsiree/rxkit/demodata/base/GenericGenerator;", "getInstance", "()Lcom/tamsiree/rxkit/demodata/base/GenericGenerator;", "generate", "", "bankName", "Lcom/tamsiree/rxkit/demodata/bank/BankNameEnum;", "cardType", "Lcom/tamsiree/rxkit/demodata/bank/BankCardTypeEnum;", "generateByPrefix", "prefix", "", "RxKit_release"})
    public static final class Companion {
        @NotNull
        public final GenericGenerator getInstance() {
            return instance;
        }

        @NotNull
        public final String generateByPrefix(int prefix) {
            String bardNo;
            Random random = new Random(System.currentTimeMillis());
            String $this$trim$iv = bardNo = String.valueOf(prefix) + StringUtils.leftPad((String)(String.valueOf(random.nextInt(999999999)) + ""), (int)9, (String)"0");
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            $this$trim$iv = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            $i$f$trim = false;
            String string = $this$trim$iv;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] chs = cArray;
            int luhnSum = LuhnUtils.getLuhnSum(chs);
            char checkCode = luhnSum % 10 == 0 ? (char)'0' : (char)(10 - luhnSum % 10 + 48);
            return bardNo + checkCode;
        }

        @NotNull
        public final String generate(@NotNull BankNameEnum bankName, @Nullable BankCardTypeEnum cardType) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)bankName), (String)"bankName");
            Integer[] candidatePrefixes = null;
            if (cardType == null) {
                candidatePrefixes = bankName.getAllCardPrefixes();
            } else {
                switch (BankCardNumberGenerator$Companion$WhenMappings.$EnumSwitchMapping$0[cardType.ordinal()]) {
                    case 1: {
                        candidatePrefixes = bankName.getDebitCardPrefixes();
                        break;
                    }
                    case 2: {
                        candidatePrefixes = bankName.getCreditCardPrefixes();
                        break;
                    }
                }
            }
            if (candidatePrefixes == null || candidatePrefixes.length == 0) {
                throw (Throwable)new RuntimeException("\u6ca1\u6709\u8be5\u94f6\u884c\u7684\u76f8\u5173\u5361\u53f7\u4fe1\u606f");
            }
            int prefix = candidatePrefixes[new Random().nextInt(candidatePrefixes.length)];
            return this.generateByPrefix(prefix);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

