/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.KeyguardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Xml;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.core.app.ActivityCompat;
import com.tamsiree.rxkit.RxBarTool;
import com.tamsiree.rxkit.RxDataTool;
import com.tamsiree.rxkit.RxTool;
import com.tamsiree.rxkit.TLog;
import com.tamsiree.rxkit.view.RxToast;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.xmlpull.v1.XmlSerializer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0016\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001bH\u0007J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0007J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u0004H\u0007J\u0018\u0010(\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0007J\"\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001b0*2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u0010-\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u00100\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020#H\u0007J\u0012\u00101\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u00102\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u00103\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u00104\u001a\u0002052\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u00106\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u00107\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u00108\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u00109\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010:\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010;\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010<\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u0010=\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010>\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010?\u001a\u00020@2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010A\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010B\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010C\u001a\u00020/2\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010D\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010E\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010F\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010G\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010H\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u0010I\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010J\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u0010K\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u0010L\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010M\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010N\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010O\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010P\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010Q\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0007J$\u0010R\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00042\b\u0010S\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010T\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010U\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0007R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\u0006R\u001a\u0010\n\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\u0006R\u001a\u0010\r\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0006R\u0011\u0010\u0010\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00048GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\u0006R\u001a\u0010\u0015\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\u0006\u00a8\u0006V"}, d2={"Lcom/tamsiree/rxkit/RxDeviceTool;", "", "()V", "appPackageName", "", "getAppPackageName", "()Ljava/lang/String;", "buildBrand", "buildBrand$annotations", "getBuildBrand", "buildBrandModel", "buildBrandModel$annotations", "getBuildBrandModel", "buildMANUFACTURER", "buildMANUFACTURER$annotations", "getBuildMANUFACTURER", "macAddress", "getMacAddress", "serialNumber", "serialNumber$annotations", "getSerialNumber", "uniqueSerialNumber", "uniqueSerialNumber$annotations", "getUniqueSerialNumber", "ThroughArray", "", "res", "Ljava/util/HashMap;", "callPhone", "context", "Landroid/content/Context;", "phoneNumber", "captureWithStatusBar", "Landroid/graphics/Bitmap;", "activity", "Landroid/app/Activity;", "captureWithoutStatusBar", "checkPermission", "", "permission", "dial", "getAllContactInfo", "", "getAllSMS", "getAndroidId", "getAppVersionName", "getAppVersionNo", "", "getContantNum", "getDeviceIdIMEI", "getDeviceInfo", "getDeviceSoftwareVersion", "getDisplayMetrics", "Landroid/util/DisplayMetrics;", "getIMEI", "getIMSI", "getLine1Number", "getNetworkCountryIso", "getNetworkOperator", "getNetworkOperatorName", "getNetworkType", "getPhoneStatus", "getPhoneType", "getScreenDensity", "", "getScreenHeight", "getScreenHeights", "getScreenRotation", "getScreenWidth", "getScreenWidths", "getSimCountryIso", "getSimOperator", "getSimOperatorName", "getSimSerialNumber", "getSimState", "getSubscriberId", "getVoiceMailNumber", "isLandscape", "isPhone", "isPortrait", "isScreenLock", "noScreenshots", "sendSms", "content", "setLandscape", "setPortrait", "RxKit_release"})
public final class RxDeviceTool {
    public static final RxDeviceTool INSTANCE;

    @JvmStatic
    public static final int getScreenHeight(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Display display = wm.getDefaultDisplay();
        Intrinsics.checkExpressionValueIsNotNull((Object)display, (String)"wm.defaultDisplay");
        return display.getHeight();
    }

    @JvmStatic
    public static final int getScreenWidth(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Display display = wm.getDefaultDisplay();
        Intrinsics.checkExpressionValueIsNotNull((Object)display, (String)"wm.defaultDisplay");
        return display.getWidth();
    }

    @JvmStatic
    public static final int getScreenWidths(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getDisplayMetrics().widthPixels;
    }

    @JvmStatic
    public static final int getScreenHeights(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getDisplayMetrics().heightPixels;
    }

    @JvmStatic
    public static final float getScreenDensity(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getDisplayMetrics().density;
    }

    @JvmStatic
    public static /* synthetic */ void uniqueSerialNumber$annotations() {
    }

    @NotNull
    public static final String getUniqueSerialNumber() {
        String phoneName = Build.MODEL;
        String manuFacturer = Build.MANUFACTURER;
        TLog.d$default("\u8be6\u7ec6\u5e8f\u5217\u53f7", manuFacturer + '-' + phoneName + '-' + RxDeviceTool.getSerialNumber(), null, 4, null);
        return manuFacturer + '-' + phoneName + '-' + RxDeviceTool.getSerialNumber();
    }

    @JvmStatic
    @Nullable
    public static final String getIMEI(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return RxDeviceTool.isPhone(context) ? RxDeviceTool.getDeviceIdIMEI(context) : RxDeviceTool.getAndroidId(context);
    }

    @JvmStatic
    @Nullable
    public static final String getIMSI(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return RxDeviceTool.getSubscriberId(context);
    }

    @JvmStatic
    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public static final String getDeviceIdIMEI(@NotNull Context context) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String id2 = null;
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager mTelephony = (TelephonyManager)object;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u8bfb\u53d6\u624b\u673a\u8bbe\u5907\u6743\u9650");
            return null;
        }
        if (mTelephony.getDeviceId() != null) {
            String string3 = mTelephony.getDeviceId();
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mTelephony.deviceId");
        } else {
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            String string4 = Settings.Secure.getString((ContentResolver)context2.getContentResolver(), (String)"android_id");
            string2 = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"Settings.Secure.getStrin\u2026ttings.Secure.ANDROID_ID)");
        }
        id2 = string2;
        return id2;
    }

    @JvmStatic
    @Nullable
    public static final String getDeviceSoftwareVersion(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u8bfb\u53d6\u624b\u673a\u8bbe\u5907\u6743\u9650");
            return null;
        }
        return tm.getDeviceSoftwareVersion();
    }

    @JvmStatic
    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public static final String getLine1Number(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_NUMBERS") != 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u8bfb\u53d6\u624b\u673a\u8bbe\u5907\u6743\u9650");
            return null;
        }
        return tm.getLine1Number();
    }

    @JvmStatic
    @NotNull
    public static final String getNetworkCountryIso(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        String string2 = tm.getNetworkCountryIso();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tm.networkCountryIso");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getNetworkOperator(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        String string2 = tm.getNetworkOperator();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tm.networkOperator");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getNetworkOperatorName(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        String string2 = tm.getNetworkOperatorName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tm.networkOperatorName");
        return string2;
    }

    @JvmStatic
    public static final int getNetworkType(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        return tm.getNetworkType();
    }

    @JvmStatic
    public static final int getPhoneType(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        return tm.getPhoneType();
    }

    @JvmStatic
    @NotNull
    public static final String getSimCountryIso(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        String string2 = tm.getSimCountryIso();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tm.simCountryIso");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getSimOperator(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        String string2 = tm.getSimOperator();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tm.simOperator");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getSimOperatorName(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        String string2 = tm.getSimOperatorName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tm.simOperatorName");
        return string2;
    }

    @JvmStatic
    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public static final String getSimSerialNumber(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u8bfb\u53d6\u624b\u673a\u8bbe\u5907\u4fe1\u606f\u6743\u9650");
            return null;
        }
        return tm.getSimSerialNumber();
    }

    @JvmStatic
    public static final int getSimState(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        return tm.getSimState();
    }

    @JvmStatic
    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public static final String getSubscriberId(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u8bfb\u53d6\u624b\u673a\u8bbe\u5907\u4fe1\u606f\u6743\u9650");
            return null;
        }
        return tm.getSubscriberId();
    }

    @JvmStatic
    @Nullable
    public static final String getVoiceMailNumber(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u8bfb\u53d6\u624b\u673a\u8bbe\u5907\u4fe1\u606f\u6743\u9650");
            return null;
        }
        return tm.getVoiceMailNumber();
    }

    @JvmStatic
    @SuppressLint(value={"HardwareIds"})
    @NotNull
    public static final String getAndroidId(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Settings.Secure.getStrin\u2026ttings.Secure.ANDROID_ID)");
        return string2;
    }

    @JvmStatic
    public static /* synthetic */ void buildBrandModel$annotations() {
    }

    @NotNull
    public static final String getBuildBrandModel() {
        String string2 = Build.MODEL;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Build.MODEL");
        return string2;
    }

    @JvmStatic
    public static /* synthetic */ void buildBrand$annotations() {
    }

    @NotNull
    public static final String getBuildBrand() {
        String string2 = Build.BRAND;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Build.BRAND");
        return string2;
    }

    @JvmStatic
    public static /* synthetic */ void buildMANUFACTURER$annotations() {
    }

    @NotNull
    public static final String getBuildMANUFACTURER() {
        String string2 = Build.MANUFACTURER;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Build.MANUFACTURER");
        return string2;
    }

    @JvmStatic
    public static /* synthetic */ void serialNumber$annotations() {
    }

    @SuppressLint(value={"PrivateApi", "HardwareIds"})
    @Nullable
    public static final String getSerialNumber() {
        String serial = null;
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.os.SystemProperties\")");
            Class<?> c = clazz;
            Method method = c.getMethod("get", String.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"c.getMethod(\"get\", String::class.java)");
            Method get = method;
            Object object = get.invoke(c, "ro.serialno");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            serial = (String)object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serial;
    }

    @NotNull
    public final String getAppPackageName() {
        String string2 = RxTool.getContext().getPackageName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"RxTool.getContext().packageName");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getAppVersionName(@Nullable Context context) {
        Context context2 = context;
        PackageManager packageManager = context2 != null ? context2.getPackageManager() : null;
        PackageInfo packInfo = null;
        try {
            PackageManager packageManager2 = packageManager;
            packInfo = packageManager2 != null ? packageManager2.getPackageInfo(context.getPackageName(), 0) : null;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        PackageInfo packageInfo = packInfo;
        if (packageInfo == null) {
            Intrinsics.throwNpe();
        }
        String string2 = packageInfo.versionName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"packInfo!!.versionName");
        return string2;
    }

    @JvmStatic
    public static final int getAppVersionNo(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packInfo = null;
        try {
            packInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        PackageInfo packageInfo = packInfo;
        if (packageInfo == null) {
            Intrinsics.throwNpe();
        }
        return packageInfo.versionCode;
    }

    @JvmStatic
    public static final boolean checkPermission(@NotNull Context context, @NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        boolean result = false;
        if (Build.VERSION.SDK_INT >= 23) {
            boolean clazz22;
            try {
                Class<?> clazz = Class.forName("android.content.Context");
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"android.content.Context\")");
                Class<?> clazz22 = clazz;
                Method method = clazz22.getMethod("checkSelfPermission", String.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"clazz.getMethod(\"checkSe\u2026ion\", String::class.java)");
                Method method2 = method;
                Object object = method2.invoke((Object)context, permission);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                int rest = (Integer)object;
                clazz22 = rest == 0;
            }
            catch (Exception e) {
                clazz22 = false;
            }
            result = clazz22;
        } else {
            PackageManager pm = context.getPackageManager();
            if (pm.checkPermission(permission, context.getPackageName()) == 0) {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @JvmStatic
    @Nullable
    public static final String getDeviceInfo(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            String mac;
            String device_id;
            JSONObject json;
            block26: {
                FileReader fileReader;
                json = new JSONObject();
                Object object = context.getSystemService("phone");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
                }
                TelephonyManager tm = (TelephonyManager)object;
                device_id = null;
                if (RxDeviceTool.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                    device_id = RxDeviceTool.getDeviceIdIMEI(context);
                }
                mac = null;
                FileReader fstream = null;
                try {
                    fileReader = new FileReader("/sys/class/net/wlan0/address");
                }
                catch (FileNotFoundException e) {
                    fileReader = new FileReader("/sys/class/net/eth0/address");
                }
                fstream = fileReader;
                BufferedReader in = null;
                in = new BufferedReader(fstream, 1024);
                mac = in.readLine();
                try {
                    fstream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break block26;
                catch (IOException e) {
                    try {
                        fstream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            fstream.close();
                        }
                        catch (IOException e4) {
                            e4.printStackTrace();
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e5) {
                                e5.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                }
            }
            json.put("mac", (Object)mac);
            if (TextUtils.isEmpty((CharSequence)device_id)) {
                device_id = mac;
            }
            if (TextUtils.isEmpty((CharSequence)device_id)) {
                device_id = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            }
            json.put("device_id", (Object)device_id);
            return json.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @JvmStatic
    public static final void ThroughArray(@NotNull HashMap<?, ?> res) {
        Intrinsics.checkParameterIsNotNull(res, (String)"res");
        Iterator<Map.Entry<?, ?>> ite = res.entrySet().iterator();
        while (ite.hasNext()) {
            Object value;
            Object key;
            Map.Entry<?, ?> entry;
            if (ite.next() == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map.Entry<*, *>");
            }
            if (entry.getKey() == null) {
                Intrinsics.throwNpe();
            }
            if (entry.getValue() == null) {
                Intrinsics.throwNpe();
            }
            TLog.d$default("MSG_AUTH_COMPLETE", key + "\uff1a " + value, null, 4, null);
        }
    }

    @JvmStatic
    @Nullable
    public static final String getMacAddress(@NotNull Context context) {
        String macAddress;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("wifi");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wifi = (WifiManager)object;
        WifiInfo info = wifi.getConnectionInfo();
        if (info != null && (macAddress = info.getMacAddress()) != null) {
            return StringsKt.replace$default((String)macAddress, (String)":", (String)"", (boolean)false, (int)4, null);
        }
        return null;
    }

    @NotNull
    public final String getMacAddress() {
        String macAddress = "";
        NetworkInterface networkInterface = null;
        try {
            if (NetworkInterface.getByName("eth0") != null) {
                networkInterface = NetworkInterface.getByName("eth0");
            } else if (NetworkInterface.getByName("wlan0") != null) {
                networkInterface = NetworkInterface.getByName("wlan0");
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (networkInterface == null) {
            return macAddress;
        }
        byte[] macArr = new byte[]{};
        try {
            byte[] byArray = networkInterface.getHardwareAddress();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"networkInterface.hardwareAddress");
            macArr = byArray;
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        StringBuilder buf = new StringBuilder();
        for (byte b : macArr) {
            String string2;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "%02X";
            Object[] objectArray = new Object[]{b};
            StringBuilder stringBuilder = buf;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            stringBuilder.append(string2);
        }
        String string4 = buf.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"buf.toString()");
        macAddress = string4;
        TLog.d$default("mac", "interfaceName=" + networkInterface.getName() + ", mac=" + macAddress, null, 4, null);
        macAddress = StringsKt.replace$default((String)macAddress, (String)":", (String)"", (boolean)false, (int)4, null);
        return macAddress;
    }

    @JvmStatic
    public static final boolean isPhone(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        return tm.getPhoneType() != 0;
    }

    @JvmStatic
    @Nullable
    public static final String getPhoneStatus(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u8bfb\u53d6\u624b\u673a\u8bbe\u5907\u4fe1\u606f\u6743\u9650");
            return null;
        }
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        String str = "";
        str = str + StringsKt.trimIndent((String)("\n            DeviceId(IMEI) = " + RxDeviceTool.getDeviceIdIMEI(context) + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            DeviceSoftwareVersion = " + tm.getDeviceSoftwareVersion() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            Line1Number = " + tm.getLine1Number() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            NetworkCountryIso = " + tm.getNetworkCountryIso() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            NetworkOperator = " + tm.getNetworkOperator() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            NetworkOperatorName = " + tm.getNetworkOperatorName() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            NetworkType = " + tm.getNetworkType() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            honeType = " + tm.getPhoneType() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            SimCountryIso = " + tm.getSimCountryIso() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            SimOperator = " + tm.getSimOperator() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            SimOperatorName = " + tm.getSimOperatorName() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            SimSerialNumber = " + tm.getSimSerialNumber() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            SimState = " + tm.getSimState() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            SubscriberId(IMSI) = " + tm.getSubscriberId() + "\n\n            "));
        str = str + StringsKt.trimIndent((String)("\n            VoiceMailNumber = " + tm.getVoiceMailNumber() + "\n\n            "));
        return str;
    }

    @JvmStatic
    public static final void dial(@NotNull Context context, @NotNull String phoneNumber) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)phoneNumber, (String)"phoneNumber");
        context.startActivity(new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + phoneNumber))));
    }

    @JvmStatic
    public static final void callPhone(@NotNull Context context, @NotNull String phoneNumber) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)phoneNumber, (String)"phoneNumber");
        if (!RxDataTool.Companion.isNullString(phoneNumber)) {
            String $this$trim$iv = phoneNumber;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String phoneNumber1 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            Intent intent = new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + phoneNumber1)));
            if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.CALL_PHONE") != 0) {
                return;
            }
            context.startActivity(intent);
        }
    }

    @JvmStatic
    public static final void sendSms(@NotNull Context context, @Nullable String phoneNumber, @Nullable String content) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Uri uri = Uri.parse((String)("smsto:" + (RxDataTool.Companion.isNullString(phoneNumber) ? "" : phoneNumber)));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.putExtra("sms_body", RxDataTool.Companion.isNullString(content) ? "" : content);
        context.startActivity(intent);
    }

    @JvmStatic
    @NotNull
    public static final List<HashMap<String, String>> getAllContactInfo(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SystemClock.sleep((long)3000L);
        ArrayList list = new ArrayList();
        ContentResolver resolver = context.getContentResolver();
        Uri raw_uri = Uri.parse((String)"content://com.android.contacts/raw_contacts");
        Uri date_uri = Uri.parse((String)"content://com.android.contacts/data");
        Cursor cursor = resolver.query(raw_uri, new String[]{"contact_id"}, null, null, null);
        while (true) {
            Cursor cursor2 = cursor;
            if (cursor2 == null) {
                Intrinsics.throwNpe();
            }
            if (!cursor2.moveToNext()) break;
            String contact_id = cursor.getString(0);
            if (RxDataTool.Companion.isNullString(contact_id)) continue;
            Cursor c = resolver.query(date_uri, new String[]{"data1", "mimetype"}, "raw_contact_id=?", new String[]{contact_id}, null);
            HashMap map = new HashMap();
            while (true) {
                Cursor cursor3 = c;
                if (cursor3 == null) {
                    Intrinsics.throwNpe();
                }
                if (!cursor3.moveToNext()) break;
                String data1 = c.getString(0);
                String mimetype = c.getString(1);
                if (Intrinsics.areEqual((Object)mimetype, (Object)"vnd.android.cursor.item/phone_v2")) {
                    Map map2 = map;
                    String string2 = data1;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data1");
                    map2.put("phone", string2);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)mimetype, (Object)"vnd.android.cursor.item/name")) continue;
                Map map3 = map;
                String string3 = data1;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"data1");
                map3.put("name", string3);
            }
            list.add(map);
            c.close();
        }
        cursor.close();
        return list;
    }

    @JvmStatic
    public static final void getContantNum(@NotNull Activity context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TLog.i$default("tips", "U should copy the following code.", null, 4, null);
        Intent intent = new Intent();
        intent.setAction("android.intent.action.PICK");
        intent.setType("vnd.android.cursor.dir/phone_v2");
        context.startActivityForResult(intent, 0);
    }

    @JvmStatic
    public static final void getAllSMS(@NotNull Context context) {
        Cursor cursor;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ContentResolver resolver = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://sms");
        Cursor cursor2 = cursor = resolver.query(uri, new String[]{"address", "date", "type", "body"}, null, null, null);
        if (cursor2 == null) {
            Intrinsics.throwNpe();
        }
        int count = cursor2.getCount();
        XmlSerializer xmlSerializer = Xml.newSerializer();
        try {
            xmlSerializer.setOutput((OutputStream)new FileOutputStream(new File("/mnt/sdcard/backupsms.xml")), "utf-8");
            xmlSerializer.startDocument("utf-8", Boolean.valueOf(true));
            xmlSerializer.startTag(null, "smss");
            while (cursor.moveToNext()) {
                SystemClock.sleep((long)1000L);
                xmlSerializer.startTag(null, "sms");
                xmlSerializer.startTag(null, "address");
                String address = cursor.getString(0);
                xmlSerializer.text(address);
                xmlSerializer.endTag(null, "address");
                xmlSerializer.startTag(null, "date");
                String date = cursor.getString(1);
                xmlSerializer.text(date);
                xmlSerializer.endTag(null, "date");
                xmlSerializer.startTag(null, "type");
                String type = cursor.getString(2);
                xmlSerializer.text(type);
                xmlSerializer.endTag(null, "type");
                xmlSerializer.startTag(null, "body");
                String body = cursor.getString(3);
                xmlSerializer.text(body);
                xmlSerializer.endTag(null, "body");
                xmlSerializer.endTag(null, "sms");
                String string2 = "address:" + address + "   date:" + date + "  type:" + type + "  body:" + body;
                boolean bl = false;
                System.out.println((Object)string2);
            }
            xmlSerializer.endTag(null, "smss");
            xmlSerializer.endDocument();
            xmlSerializer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JvmStatic
    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public static final void setLandscape(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        activity.setRequestedOrientation(0);
    }

    @JvmStatic
    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public static final void setPortrait(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        activity.setRequestedOrientation(1);
    }

    @JvmStatic
    public static final boolean isLandscape(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getConfiguration().orientation == 2;
    }

    @JvmStatic
    public static final boolean isPortrait(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getConfiguration().orientation == 1;
    }

    @JvmStatic
    public static final int getScreenRotation(@NotNull Activity activity) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        WindowManager windowManager = activity.getWindowManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)windowManager, (String)"activity.windowManager");
        Display display = windowManager.getDefaultDisplay();
        Intrinsics.checkExpressionValueIsNotNull((Object)display, (String)"activity.windowManager.defaultDisplay");
        switch (display.getRotation()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 90;
                break;
            }
            case 2: {
                n = 180;
                break;
            }
            case 3: {
                n = 270;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @JvmStatic
    @NotNull
    public static final Bitmap captureWithStatusBar(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
        View view = window.getDecorView();
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"activity.window.decorView");
        View view2 = view;
        view2.setDrawingCacheEnabled(true);
        view2.buildDrawingCache();
        Bitmap bmp = view2.getDrawingCache();
        int width = RxDeviceTool.getScreenWidth((Context)activity);
        int height = RxDeviceTool.getScreenHeight((Context)activity);
        Bitmap ret = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)width, (int)height);
        view2.destroyDrawingCache();
        Bitmap bitmap = ret;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"ret");
        return bitmap;
    }

    @JvmStatic
    @NotNull
    public static final Bitmap captureWithoutStatusBar(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
        View view = window.getDecorView();
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"activity.window.decorView");
        View view2 = view;
        view2.setDrawingCacheEnabled(true);
        view2.buildDrawingCache();
        Bitmap bmp = view2.getDrawingCache();
        int statusBarHeight = RxBarTool.getStatusBarHeight((Context)activity);
        int width = RxDeviceTool.getScreenWidth((Context)activity);
        int height = RxDeviceTool.getScreenHeight((Context)activity);
        Bitmap ret = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)statusBarHeight, (int)width, (int)(height - statusBarHeight));
        view2.destroyDrawingCache();
        Bitmap bitmap = ret;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"ret");
        return bitmap;
    }

    @JvmStatic
    @NotNull
    public static final DisplayMetrics getDisplayMetrics(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    @JvmStatic
    public static final boolean isScreenLock(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("keyguard");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.KeyguardManager");
        }
        KeyguardManager km = (KeyguardManager)object;
        return km.inKeyguardRestrictedInputMode();
    }

    @JvmStatic
    public static final void noScreenshots(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        activity.getWindow().addFlags(8192);
    }

    private RxDeviceTool() {
    }

    static {
        RxDeviceTool rxDeviceTool;
        INSTANCE = rxDeviceTool = new RxDeviceTool();
    }
}

