/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.location.Address;
import android.location.Criteria;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.tamsiree.rxkit.model.Gps;
import com.tamsiree.rxkit.view.RxToast;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002@AB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0007J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0007J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0007J$\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0007J\"\u0010&\u001a\u00020'2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0007J\"\u0010(\u001a\u00020'2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0007J\"\u0010)\u001a\u00020'2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0007J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0004H\u0007J\u0010\u0010,\u001a\u00020-2\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010.\u001a\u00020-2\u0006\u0010\"\u001a\u00020#H\u0007J\u001a\u0010/\u001a\u00020-2\u0006\u0010+\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000100H\u0007J\u0010\u00102\u001a\u0002032\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u00104\u001a\u00020-2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0007J*\u00105\u001a\u00020-2\u0006\u0010\"\u001a\u00020#2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002072\b\u00109\u001a\u0004\u0018\u00010\u000bH\u0007J\u0018\u0010:\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0018\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004H\u0002J\u0018\u0010>\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004H\u0002J\b\u0010?\u001a\u000203H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/tamsiree/rxkit/RxLocationTool;", "", "()V", "a", "", "criteria", "Landroid/location/Criteria;", "getCriteria", "()Landroid/location/Criteria;", "ee", "mListener", "Lcom/tamsiree/rxkit/RxLocationTool$OnLocationChangeListener;", "mLocationManager", "Landroid/location/LocationManager;", "myLocationListener", "Lcom/tamsiree/rxkit/RxLocationTool$MyLocationListener;", "pi", "BD09ToGCJ02", "Lcom/tamsiree/rxkit/model/Gps;", "bdLon", "bdLat", "BD09ToGPS84", "GCJ02ToBD09", "ggLon", "ggLat", "GCJ02ToGPS84", "lon", "lat", "GPS84ToBD09", "gpsLon", "gpsLat", "GPS84ToGCJ02", "getAddress", "Landroid/location/Address;", "context", "Landroid/content/Context;", "latitude", "longitude", "getCountryName", "", "getLocality", "getStreet", "gpsToDegree", "location", "isGpsEnabled", "", "isLocationEnabled", "isMove", "Landroid/location/Location;", "preLocation", "openGpsSettings", "", "outOfChina", "registerLocation", "minTime", "", "minDistance", "listener", "transform", "transformLat", "x", "y", "transformLon", "unRegisterLocation", "MyLocationListener", "OnLocationChangeListener", "RxKit_release"})
public final class RxLocationTool {
    public static final double pi = Math.PI;
    public static final double a = 6378245.0;
    public static final double ee = 0.006693421622965943;
    private static OnLocationChangeListener mListener;
    private static MyLocationListener myLocationListener;
    private static LocationManager mLocationManager;
    public static final RxLocationTool INSTANCE;

    @JvmStatic
    public static final boolean isGpsEnabled(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("location");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
        }
        LocationManager lm = (LocationManager)object;
        return lm.isProviderEnabled("gps");
    }

    @JvmStatic
    public static final boolean isLocationEnabled(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("location");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
        }
        LocationManager lm = (LocationManager)object;
        return lm.isProviderEnabled("network") || lm.isProviderEnabled("gps");
    }

    @JvmStatic
    public static final void openGpsSettings(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    @JvmStatic
    public static final boolean registerLocation(@NotNull Context context, long minTime, long minDistance, @Nullable OnLocationChangeListener listener) {
        Location location;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (listener == null) {
            return false;
        }
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)1);
            ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])new String[]{"android.permission.ACCESS_COARSE_LOCATION"}, (int)1);
            return false;
        }
        Object object = context.getSystemService("location");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
        }
        mLocationManager = (LocationManager)object;
        mListener = listener;
        if (!RxLocationTool.isLocationEnabled(context)) {
            RxToast.showToast(context, "\u65e0\u6cd5\u5b9a\u4f4d\uff0c\u8bf7\u6253\u5f00\u5b9a\u4f4d\u670d\u52a1", 500);
            return false;
        }
        LocationManager locationManager = mLocationManager;
        if (locationManager == null) {
            Intrinsics.throwNpe();
        }
        String provider = locationManager.getBestProvider(INSTANCE.getCriteria(), true);
        LocationManager locationManager2 = mLocationManager;
        if (locationManager2 == null) {
            Intrinsics.throwNpe();
        }
        if ((location = locationManager2.getLastKnownLocation(provider)) != null) {
            listener.getLastKnownLocation(location);
        }
        if (myLocationListener == null) {
            myLocationListener = new MyLocationListener();
        }
        LocationManager locationManager3 = mLocationManager;
        if (locationManager3 == null) {
            Intrinsics.throwNpe();
        }
        locationManager3.requestLocationUpdates(provider, minTime, (float)minDistance, (LocationListener)myLocationListener);
        return true;
    }

    @JvmStatic
    public static final void unRegisterLocation() {
        if (mLocationManager != null) {
            if (myLocationListener != null) {
                LocationManager locationManager = mLocationManager;
                if (locationManager == null) {
                    Intrinsics.throwNpe();
                }
                locationManager.removeUpdates((LocationListener)myLocationListener);
                myLocationListener = null;
            }
            mLocationManager = null;
        }
    }

    private final Criteria getCriteria() {
        Criteria criteria = new Criteria();
        criteria.setAccuracy(1);
        criteria.setSpeedRequired(true);
        criteria.setCostAllowed(true);
        criteria.setBearingRequired(true);
        criteria.setAltitudeRequired(true);
        criteria.setPowerRequirement(1);
        return criteria;
    }

    @JvmStatic
    @Nullable
    public static final Address getAddress(@Nullable Context context, double latitude, double longitude) {
        Geocoder geocoder = new Geocoder(context, Locale.getDefault());
        try {
            List addresses = geocoder.getFromLocation(latitude, longitude, 1);
            if (addresses.size() > 0) {
                return (Address)addresses.get(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final String getCountryName(@Nullable Context context, double latitude, double longitude) {
        String string2;
        Address address = RxLocationTool.getAddress(context, latitude, longitude);
        if (address == null) {
            string2 = "unknown";
        } else {
            String string3 = address.getCountryName();
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"address.countryName");
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getLocality(@Nullable Context context, double latitude, double longitude) {
        String string2;
        Address address = RxLocationTool.getAddress(context, latitude, longitude);
        if (address == null) {
            string2 = "unknown";
        } else {
            String string3 = address.getLocality();
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"address.locality");
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getStreet(@Nullable Context context, double latitude, double longitude) {
        String string2;
        Address address = RxLocationTool.getAddress(context, latitude, longitude);
        if (address == null) {
            string2 = "unknown";
        } else {
            String string3 = address.getAddressLine(0);
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"address.getAddressLine(0)");
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String gpsToDegree(double location) {
        boolean bl = false;
        double degree = Math.floor(location);
        double minute_temp = (location - degree) * (double)60;
        boolean bl2 = false;
        double minute = Math.floor(minute_temp);
        String second = new DecimalFormat("#.##").format((minute_temp - minute) * (double)60);
        return String.valueOf((int)degree) + "\u00b0" + (int)minute + "\u2032" + second + "\u2033";
    }

    @JvmStatic
    @Nullable
    public static final Gps GPS84ToGCJ02(double lon, double lat) {
        if (RxLocationTool.outOfChina(lon, lat)) {
            return null;
        }
        double dLat = INSTANCE.transformLat(lon - 105.0, lat - 35.0);
        double dLon = INSTANCE.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (6335552.717000426 / (magic * sqrtMagic) * Math.PI);
        dLon = dLon * 180.0 / (6378245.0 / sqrtMagic * Math.cos(radLat) * Math.PI);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new Gps(mgLon, mgLat);
    }

    @JvmStatic
    @NotNull
    public static final Gps GCJ02ToGPS84(double lon, double lat) {
        Gps gps = INSTANCE.transform(lon, lat);
        double lontitude = lon * (double)2 - gps.getLongitude();
        double latitude = lat * (double)2 - gps.getLatitude();
        return new Gps(lontitude, latitude);
    }

    @JvmStatic
    @NotNull
    public static final Gps GCJ02ToBD09(double ggLon, double ggLat) {
        double z = Math.sqrt(ggLon * ggLon + ggLat * ggLat) + 2.0E-5 * Math.sin(ggLat * Math.PI);
        double theta = Math.atan2(ggLat, ggLon) + 3.0E-6 * Math.cos(ggLon * Math.PI);
        double bdLon = z * Math.cos(theta) + 0.0065;
        double bdLat = z * Math.sin(theta) + 0.006;
        return new Gps(bdLon, bdLat);
    }

    @JvmStatic
    @NotNull
    public static final Gps BD09ToGCJ02(double bdLon, double bdLat) {
        double x = bdLon - 0.0065;
        double y = bdLat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * Math.PI);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * Math.PI);
        double ggLon = z * Math.cos(theta);
        double ggLat = z * Math.sin(theta);
        return new Gps(ggLon, ggLat);
    }

    @JvmStatic
    @NotNull
    public static final Gps BD09ToGPS84(double bdLon, double bdLat) {
        Gps gcj02 = RxLocationTool.BD09ToGCJ02(bdLon, bdLat);
        return RxLocationTool.GCJ02ToGPS84(gcj02.getLongitude(), gcj02.getLatitude());
    }

    @JvmStatic
    @NotNull
    public static final Gps GPS84ToBD09(double gpsLon, double gpsLat) {
        Gps gcj02;
        Gps gps = gcj02 = RxLocationTool.GPS84ToGCJ02(gpsLon, gpsLat);
        if (gps == null) {
            Intrinsics.throwNpe();
        }
        return RxLocationTool.GCJ02ToBD09(gps.getLongitude(), gcj02.getLatitude());
    }

    @JvmStatic
    public static final boolean outOfChina(double lon, double lat) {
        return lon < 72.004 || lon > 137.8347 || lat < 0.8293 || lat > 55.8271;
    }

    private final Gps transform(double lon, double lat) {
        if (RxLocationTool.outOfChina(lon, lat)) {
            return new Gps(lon, lat);
        }
        double dLat = this.transformLat(lon - 105.0, lat - 35.0);
        double dLon = this.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - 0.006693421622965943 * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (6335552.717000426 / (magic * sqrtMagic) * Math.PI);
        dLon = dLon * 180.0 / (6378245.0 / sqrtMagic * Math.cos(radLat) * Math.PI);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new Gps(mgLon, mgLat);
    }

    private final double transformLat(double x, double y) {
        double ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(y * Math.PI) + 40.0 * Math.sin(y / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(y / 12.0 * Math.PI) + (double)320 * Math.sin(y * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    private final double transformLon(double x, double y) {
        double ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(x * Math.PI) + 40.0 * Math.sin(x / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(x / 12.0 * Math.PI) + 300.0 * Math.sin(x / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    @JvmStatic
    public static final boolean isMove(@NotNull Location location, @Nullable Location preLocation) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        boolean isMove = false;
        if (preLocation != null) {
            double speed = (double)location.getSpeed() * 3.6;
            double distance = location.distanceTo(preLocation);
            double compass = Math.abs(preLocation.getBearing() - location.getBearing());
            double angle = 0.0;
            double d = angle = compass > (double)180 ? (double)360 - compass : compass;
            isMove = speed != 0.0 ? (speed < (double)35 && distance > (double)3 && distance < (double)10 ? angle > (double)10 : speed < (double)40 && distance > (double)10 && distance < (double)100 || speed < (double)50 && distance > (double)10 && distance < (double)100 || speed < (double)60 && distance > (double)10 && distance < (double)100 || speed < (double)9999 && distance > (double)100) : false;
        } else {
            isMove = true;
        }
        return isMove;
    }

    private RxLocationTool() {
    }

    static {
        RxLocationTool rxLocationTool;
        INSTANCE = rxLocationTool = new RxLocationTool();
    }

    public static final /* synthetic */ OnLocationChangeListener access$getMListener$p(RxLocationTool $this) {
        RxLocationTool rxLocationTool = $this;
        return mListener;
    }

    public static final /* synthetic */ void access$setMListener$p(RxLocationTool $this, OnLocationChangeListener onLocationChangeListener) {
        RxLocationTool rxLocationTool = $this;
        mListener = onLocationChangeListener;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J$\u0010\u0007\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH&\u00a8\u0006\u000e"}, d2={"Lcom/tamsiree/rxkit/RxLocationTool$OnLocationChangeListener;", "", "getLastKnownLocation", "", "location", "Landroid/location/Location;", "onLocationChanged", "onStatusChanged", "provider", "", "status", "", "extras", "Landroid/os/Bundle;", "RxKit_release"})
    public static interface OnLocationChangeListener {
        public void getLastKnownLocation(@NotNull Location var1);

        public void onLocationChanged(@NotNull Location var1);

        public void onStatusChanged(@Nullable String var1, int var2, @Nullable Bundle var3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/tamsiree/rxkit/RxLocationTool$MyLocationListener;", "Landroid/location/LocationListener;", "()V", "onLocationChanged", "", "location", "Landroid/location/Location;", "onProviderDisabled", "provider", "", "onProviderEnabled", "onStatusChanged", "status", "", "extras", "Landroid/os/Bundle;", "RxKit_release"})
    private static final class MyLocationListener
    implements LocationListener {
        public void onLocationChanged(@NotNull Location location) {
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            if (RxLocationTool.access$getMListener$p(INSTANCE) != null) {
                OnLocationChangeListener onLocationChangeListener = RxLocationTool.access$getMListener$p(INSTANCE);
                if (onLocationChangeListener == null) {
                    Intrinsics.throwNpe();
                }
                onLocationChangeListener.onLocationChanged(location);
            }
        }

        public void onStatusChanged(@NotNull String provider, int status, @NotNull Bundle extras) {
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            Intrinsics.checkParameterIsNotNull((Object)extras, (String)"extras");
            if (RxLocationTool.access$getMListener$p(INSTANCE) != null) {
                OnLocationChangeListener onLocationChangeListener = RxLocationTool.access$getMListener$p(INSTANCE);
                if (onLocationChangeListener == null) {
                    Intrinsics.throwNpe();
                }
                onLocationChangeListener.onStatusChanged(provider, status, extras);
            }
            switch (status) {
                case 2: {
                    Log.d((String)"onStatusChanged", (String)"\u5f53\u524dGPS\u72b6\u6001\u4e3a\u53ef\u89c1\u72b6\u6001");
                    break;
                }
                case 0: {
                    Log.d((String)"onStatusChanged", (String)"\u5f53\u524dGPS\u72b6\u6001\u4e3a\u670d\u52a1\u533a\u5916\u72b6\u6001");
                    break;
                }
                case 1: {
                    Log.d((String)"onStatusChanged", (String)"\u5f53\u524dGPS\u72b6\u6001\u4e3a\u6682\u505c\u670d\u52a1\u72b6\u6001");
                    break;
                }
            }
        }

        public void onProviderEnabled(@NotNull String provider) {
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        }

        public void onProviderDisabled(@NotNull String provider) {
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        }
    }
}

