/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxtool;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.KeyguardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Xml;
import android.view.View;
import android.view.WindowManager;
import androidx.core.app.ActivityCompat;
import com.tamsiree.rxtool.RxBarTool;
import com.tamsiree.rxtool.RxDataTool;
import com.tamsiree.rxtool.RxTool;
import com.tamsiree.rxtool.view.RxToast;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.xmlpull.v1.XmlSerializer;

public class RxDeviceTool {
    public static int getScreenHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        assert (wm != null);
        return wm.getDefaultDisplay().getHeight();
    }

    public static int getScreenWidth(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        assert (wm != null);
        return wm.getDefaultDisplay().getWidth();
    }

    public static int getScreenWidths(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeights(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static float getScreenDensity(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public static String getUniqueSerialNumber() {
        String phoneName = Build.MODEL;
        String manuFacturer = Build.MANUFACTURER;
        Log.d((String)"\u8be6\u7ec6\u5e8f\u5217\u53f7", (String)(manuFacturer + "-" + phoneName + "-" + RxDeviceTool.getSerialNumber()));
        return manuFacturer + "-" + phoneName + "-" + RxDeviceTool.getSerialNumber();
    }

    public static String getIMEI(Context context) {
        String deviceId = RxDeviceTool.isPhone(context) ? RxDeviceTool.getDeviceIdIMEI(context) : RxDeviceTool.getAndroidId(context);
        return deviceId;
    }

    public static String getIMSI(Context context) {
        return RxDeviceTool.getSubscriberId(context);
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getDeviceIdIMEI(Context context) {
        TelephonyManager mTelephony = (TelephonyManager)context.getSystemService("phone");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u8bfb\u53d6\u624b\u673a\u8bbe\u5907\u6743\u9650");
            return null;
        }
        String id2 = mTelephony.getDeviceId() != null ? mTelephony.getDeviceId() : Settings.Secure.getString((ContentResolver)context.getApplicationContext().getContentResolver(), (String)"android_id");
        return id2;
    }

    public static String getDeviceSoftwareVersion(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u8bfb\u53d6\u624b\u673a\u8bbe\u5907\u6743\u9650");
            return null;
        }
        return tm.getDeviceSoftwareVersion();
    }

    public static String getLine1Number(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_NUMBERS") != 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u8bfb\u53d6\u624b\u673a\u8bbe\u5907\u6743\u9650");
            return null;
        }
        return tm.getLine1Number();
    }

    public static String getNetworkCountryIso(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getNetworkCountryIso();
    }

    public static String getNetworkOperator(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getNetworkOperator();
    }

    public static String getNetworkOperatorName(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getNetworkOperatorName();
    }

    public static int getNetworkType(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getNetworkType();
    }

    public static int getPhoneType(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getPhoneType();
    }

    public static String getSimCountryIso(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getSimCountryIso();
    }

    public static String getSimOperator(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getSimOperator();
    }

    public static String getSimOperatorName(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getSimOperatorName();
    }

    public static String getSimSerialNumber(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u8bfb\u53d6\u624b\u673a\u8bbe\u5907\u4fe1\u606f\u6743\u9650");
            return null;
        }
        return tm.getSimSerialNumber();
    }

    public static int getSimState(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getSimState();
    }

    public static String getSubscriberId(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u8bfb\u53d6\u624b\u673a\u8bbe\u5907\u4fe1\u606f\u6743\u9650");
            return null;
        }
        return tm.getSubscriberId();
    }

    public static String getVoiceMailNumber(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u8bfb\u53d6\u624b\u673a\u8bbe\u5907\u4fe1\u606f\u6743\u9650");
            return null;
        }
        return tm.getVoiceMailNumber();
    }

    public static String getAndroidId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static String getBuildBrandModel() {
        return Build.MODEL;
    }

    public static String getBuildBrand() {
        return Build.BRAND;
    }

    public static String getBuildMANUFACTURER() {
        return Build.MANUFACTURER;
    }

    public static String getSerialNumber() {
        String serial = null;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class);
            serial = (String)get.invoke(c, "ro.serialno");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serial;
    }

    public static String getAppPackageName() {
        return RxTool.getContext().getPackageName();
    }

    public static String getAppVersionName(Context context) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packInfo = null;
        try {
            packInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        String version = packInfo.versionName;
        return version;
    }

    public static int getAppVersionNo(Context context) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packInfo = null;
        try {
            packInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        int version = packInfo.versionCode;
        return version;
    }

    public static boolean checkPermission(Context context, String permission2) {
        boolean result = false;
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                Class<?> clazz = Class.forName("android.content.Context");
                Method method = clazz.getMethod("checkSelfPermission", String.class);
                int rest = (Integer)method.invoke((Object)context, permission2);
                result = rest == 0;
            }
            catch (Exception e) {
                result = false;
            }
        } else {
            PackageManager pm = context.getPackageManager();
            if (pm.checkPermission(permission2, context.getPackageName()) == 0) {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDeviceInfo(Context context) {
        try {
            JSONObject json = new JSONObject();
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            String device_id = null;
            if (RxDeviceTool.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                device_id = RxDeviceTool.getDeviceIdIMEI(context);
            }
            String mac = null;
            FileReader fstream = null;
            try {
                fstream = new FileReader("/sys/class/net/wlan0/address");
            }
            catch (FileNotFoundException e) {
                fstream = new FileReader("/sys/class/net/eth0/address");
            }
            BufferedReader in = null;
            if (fstream != null) {
                try {
                    in = new BufferedReader(fstream, 1024);
                    mac = in.readLine();
                }
                catch (IOException e) {
                }
                finally {
                    if (fstream != null) {
                        try {
                            fstream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            json.put("mac", mac);
            if (TextUtils.isEmpty((CharSequence)device_id)) {
                device_id = mac;
            }
            if (TextUtils.isEmpty((CharSequence)device_id)) {
                device_id = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            }
            json.put("device_id", (Object)device_id);
            return json.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void ThroughArray(HashMap res) {
        for (Map.Entry entry : res.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Log.d((String)"MSG_AUTH_COMPLETE", (String)(key + "\uff1a " + value));
        }
    }

    public static String getMacAddress(Context context) {
        String macAddress;
        WifiManager wifi = (WifiManager)context.getSystemService("wifi");
        WifiInfo info = wifi.getConnectionInfo();
        if (info != null && (macAddress = info.getMacAddress()) != null) {
            return macAddress.replace(":", "");
        }
        return null;
    }

    public static String getMacAddress() {
        String macAddress = "";
        NetworkInterface networkInterface = null;
        try {
            if (NetworkInterface.getByName("eth0") != null) {
                networkInterface = NetworkInterface.getByName("eth0");
            } else if (NetworkInterface.getByName("wlan0") != null) {
                networkInterface = NetworkInterface.getByName("wlan0");
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (networkInterface == null) {
            return macAddress;
        }
        byte[] macArr = new byte[]{};
        try {
            macArr = networkInterface.getHardwareAddress();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        StringBuilder buf = new StringBuilder();
        for (byte b : macArr) {
            buf.append(String.format("%02X", b));
        }
        macAddress = buf.toString();
        Log.d((String)"mac", (String)("interfaceName=" + networkInterface.getName() + ", mac=" + macAddress));
        macAddress = macAddress.replace(":", "");
        return macAddress;
    }

    public static boolean isPhone(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getPhoneType() != 0;
    }

    public static String getPhoneStatus(Context context) {
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u8bfb\u53d6\u624b\u673a\u8bbe\u5907\u4fe1\u606f\u6743\u9650");
            return null;
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String str = "";
        str = str + "DeviceId(IMEI) = " + RxDeviceTool.getDeviceIdIMEI(context) + "\n";
        str = str + "DeviceSoftwareVersion = " + tm.getDeviceSoftwareVersion() + "\n";
        str = str + "Line1Number = " + tm.getLine1Number() + "\n";
        str = str + "NetworkCountryIso = " + tm.getNetworkCountryIso() + "\n";
        str = str + "NetworkOperator = " + tm.getNetworkOperator() + "\n";
        str = str + "NetworkOperatorName = " + tm.getNetworkOperatorName() + "\n";
        str = str + "NetworkType = " + tm.getNetworkType() + "\n";
        str = str + "honeType = " + tm.getPhoneType() + "\n";
        str = str + "SimCountryIso = " + tm.getSimCountryIso() + "\n";
        str = str + "SimOperator = " + tm.getSimOperator() + "\n";
        str = str + "SimOperatorName = " + tm.getSimOperatorName() + "\n";
        str = str + "SimSerialNumber = " + tm.getSimSerialNumber() + "\n";
        str = str + "SimState = " + tm.getSimState() + "\n";
        str = str + "SubscriberId(IMSI) = " + tm.getSubscriberId() + "\n";
        str = str + "VoiceMailNumber = " + tm.getVoiceMailNumber() + "\n";
        return str;
    }

    public static void dial(Context context, String phoneNumber) {
        context.startActivity(new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + phoneNumber))));
    }

    public static void callPhone(Context context, String phoneNumber) {
        if (!RxDataTool.isNullString(phoneNumber)) {
            String phoneNumber1 = phoneNumber.trim();
            Intent intent = new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + phoneNumber1)));
            if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.CALL_PHONE") != 0) {
                return;
            }
            context.startActivity(intent);
        }
    }

    public static void sendSms(Context context, String phoneNumber, String content) {
        Uri uri = Uri.parse((String)("smsto:" + (RxDataTool.isNullString(phoneNumber) ? "" : phoneNumber)));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.putExtra("sms_body", RxDataTool.isNullString(content) ? "" : content);
        context.startActivity(intent);
    }

    public static List<HashMap<String, String>> getAllContactInfo(Context context) {
        SystemClock.sleep((long)3000L);
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        ContentResolver resolver = context.getContentResolver();
        Uri raw_uri = Uri.parse((String)"content://com.android.contacts/raw_contacts");
        Uri date_uri = Uri.parse((String)"content://com.android.contacts/data");
        Cursor cursor = resolver.query(raw_uri, new String[]{"contact_id"}, null, null, null);
        while (cursor.moveToNext()) {
            String contact_id = cursor.getString(0);
            if (RxDataTool.isNullString(contact_id)) continue;
            Cursor c = resolver.query(date_uri, new String[]{"data1", "mimetype"}, "raw_contact_id=?", new String[]{contact_id}, null);
            HashMap<String, String> map = new HashMap<String, String>();
            while (c.moveToNext()) {
                String data1 = c.getString(0);
                String mimetype = c.getString(1);
                if (mimetype.equals("vnd.android.cursor.item/phone_v2")) {
                    map.put("phone", data1);
                    continue;
                }
                if (!mimetype.equals("vnd.android.cursor.item/name")) continue;
                map.put("name", data1);
            }
            list.add(map);
            c.close();
        }
        cursor.close();
        return list;
    }

    public static void getContantNum(Activity context) {
        Log.i((String)"tips", (String)"U should copy the following code.");
        Intent intent = new Intent();
        intent.setAction("android.intent.action.PICK");
        intent.setType("vnd.android.cursor.dir/phone_v2");
        context.startActivityForResult(intent, 0);
    }

    public static void getAllSMS(Context context) {
        ContentResolver resolver = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://sms");
        Cursor cursor = resolver.query(uri, new String[]{"address", "date", "type", "body"}, null, null, null);
        int count = cursor.getCount();
        XmlSerializer xmlSerializer = Xml.newSerializer();
        try {
            xmlSerializer.setOutput((OutputStream)new FileOutputStream(new File("/mnt/sdcard/backupsms.xml")), "utf-8");
            xmlSerializer.startDocument("utf-8", Boolean.valueOf(true));
            xmlSerializer.startTag(null, "smss");
            while (cursor.moveToNext()) {
                SystemClock.sleep((long)1000L);
                xmlSerializer.startTag(null, "sms");
                xmlSerializer.startTag(null, "address");
                String address = cursor.getString(0);
                xmlSerializer.text(address);
                xmlSerializer.endTag(null, "address");
                xmlSerializer.startTag(null, "date");
                String date = cursor.getString(1);
                xmlSerializer.text(date);
                xmlSerializer.endTag(null, "date");
                xmlSerializer.startTag(null, "type");
                String type = cursor.getString(2);
                xmlSerializer.text(type);
                xmlSerializer.endTag(null, "type");
                xmlSerializer.startTag(null, "body");
                String body = cursor.getString(3);
                xmlSerializer.text(body);
                xmlSerializer.endTag(null, "body");
                xmlSerializer.endTag(null, "sms");
                System.out.println("address:" + address + "   date:" + date + "  type:" + type + "  body:" + body);
            }
            xmlSerializer.endTag(null, "smss");
            xmlSerializer.endDocument();
            xmlSerializer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setLandscape(Activity activity) {
        activity.setRequestedOrientation(0);
    }

    public static void setPortrait(Activity activity) {
        activity.setRequestedOrientation(1);
    }

    public static boolean isLandscape(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    public static boolean isPortrait(Context context) {
        return context.getResources().getConfiguration().orientation == 1;
    }

    public static int getScreenRotation(Activity activity) {
        switch (activity.getWindowManager().getDefaultDisplay().getRotation()) {
            default: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: 
        }
        return 270;
    }

    public static Bitmap captureWithStatusBar(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bmp = view.getDrawingCache();
        int width = RxDeviceTool.getScreenWidth((Context)activity);
        int height = RxDeviceTool.getScreenHeight((Context)activity);
        Bitmap ret = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)width, (int)height);
        view.destroyDrawingCache();
        return ret;
    }

    public static Bitmap captureWithoutStatusBar(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bmp = view.getDrawingCache();
        int statusBarHeight = RxBarTool.getStatusBarHeight((Context)activity);
        int width = RxDeviceTool.getScreenWidth((Context)activity);
        int height = RxDeviceTool.getScreenHeight((Context)activity);
        Bitmap ret = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)statusBarHeight, (int)width, (int)(height - statusBarHeight));
        view.destroyDrawingCache();
        return ret;
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static boolean isScreenLock(Context context) {
        KeyguardManager km = (KeyguardManager)context.getSystemService("keyguard");
        return km.inKeyguardRestrictedInputMode();
    }

    public static void noScreenshots(Activity activity) {
        activity.getWindow().addFlags(8192);
    }
}

