/*
 * Decompiled with CFR 0.152.
 */
package pl.tajchert.houston;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.service.notification.StatusBarNotification;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import pl.tajchert.houston.HoustonLandReceiver;
import pl.tajchert.houston.NotificationCategory;
import pl.tajchert.houston.NotificationWrapper;

public class Houston
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private static final String TAG = Houston.class.getCanonicalName();
    private SharedPreferences sharedPreferences;
    private NotificationManager notificationManager;
    private Gson gson = new GsonBuilder().create();
    private static final String KEY_STORED = "houston_all_notifications_storage";
    private ArrayList<NotificationWrapper> allNotifications = new ArrayList();

    public Houston(Context context) {
        this(context.getSharedPreferences(context.getApplicationContext().getPackageName(), 0), context);
    }

    public Houston(SharedPreferences sharedPreferences, Context context) {
        this(sharedPreferences, (NotificationManager)context.getSystemService("notification"));
    }

    public Houston(SharedPreferences sharedPreferences, NotificationManager notificationManager) {
        this.sharedPreferences = sharedPreferences;
        this.notificationManager = notificationManager;
        this.allNotifications = this.readNotificationListFromStorage(sharedPreferences);
        this.sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    private ArrayList<NotificationWrapper> readNotificationListFromStorage(SharedPreferences sharedPreferences) {
        ArrayList notificationFromStorage = null;
        try {
            notificationFromStorage = (ArrayList)this.gson.fromJson(this.sharedPreferences.getString(KEY_STORED, ""), new TypeToken<List<NotificationWrapper>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            sharedPreferences.edit().remove(KEY_STORED).apply();
        }
        if (notificationFromStorage == null) {
            notificationFromStorage = new ArrayList();
        }
        return notificationFromStorage;
    }

    public void saveNotification(NotificationWrapper notificationWrapper) {
        if (this.allNotifications.contains(notificationWrapper)) {
            this.allNotifications.remove(notificationWrapper);
        }
        this.allNotifications.add(notificationWrapper);
        this.persistNotifications();
    }

    public void removeNotification(int id) {
        NotificationWrapper notificationWrapper = this.getNotification(id);
        if (notificationWrapper != null) {
            this.allNotifications.remove(notificationWrapper);
        }
        this.persistNotifications();
    }

    public NotificationWrapper getNotification(int id) {
        for (NotificationWrapper notificationWrapper : this.allNotifications) {
            if (notificationWrapper.id != id) continue;
            return notificationWrapper;
        }
        return null;
    }

    public ArrayList<NotificationWrapper> getNotifications(String categoryName) {
        ArrayList<NotificationWrapper> notificationWrappers = new ArrayList<NotificationWrapper>();
        for (NotificationWrapper notificationWrapper : this.allNotifications) {
            if (notificationWrapper.category == null || !categoryName.equals(notificationWrapper.category.title)) continue;
            notificationWrappers.add(notificationWrapper);
        }
        return notificationWrappers;
    }

    public ArrayList<NotificationWrapper> getNotifications(NotificationCategory notificationCategory) {
        ArrayList<NotificationWrapper> notificationWrappers = new ArrayList<NotificationWrapper>();
        for (NotificationWrapper notificationWrapper : this.allNotifications) {
            if (notificationWrapper.category == null || !notificationWrapper.category.equals(notificationCategory)) continue;
            notificationWrappers.add(notificationWrapper);
        }
        return notificationWrappers;
    }

    public ArrayList<NotificationWrapper> getNotifications() {
        return this.allNotifications;
    }

    public void persistNotifications() {
        this.sharedPreferences.edit().putString(KEY_STORED, this.gson.toJson(this.allNotifications)).apply();
    }

    @NonNull
    private NotificationWrapper createNotificationWrapper(int id) {
        NotificationWrapper notificationWrapper = new NotificationWrapper();
        notificationWrapper.id = id;
        notificationWrapper.showTime = System.currentTimeMillis();
        return notificationWrapper;
    }

    public Notification.Builder addDismissListener(Notification.Builder builder, int id, Context context) {
        Intent intent = new Intent(context, HoustonLandReceiver.class);
        Bundle intentExtras = new Bundle();
        intentExtras.putInt("pl.tajchert.houston_NOTIF_ID", id);
        intent.putExtras(intentExtras);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context.getApplicationContext(), (int)id, (Intent)intent, (int)0x8000000);
        builder.setDeleteIntent(pendingIntent);
        return builder;
    }

    public NotificationCompat.Builder addDismissListener(NotificationCompat.Builder builder, int id, Context context) {
        Intent intent = new Intent(context, HoustonLandReceiver.class);
        Bundle intentExtras = new Bundle();
        intentExtras.putInt("pl.tajchert.houston_NOTIF_ID", id);
        intent.putExtras(intentExtras);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context.getApplicationContext(), (int)id, (Intent)intent, (int)0x8000000);
        builder.setDeleteIntent(pendingIntent);
        return builder;
    }

    public void launch(int id, Notification notification) {
        this.notificationManager.notify(id, notification);
        this.saveNotification(this.createNotificationWrapper(id));
    }

    public void launch(int id, Notification notification, String category) {
        this.launch(id, notification);
        NotificationWrapper notificationWrapper = this.createNotificationWrapper(id);
        notificationWrapper.category = new NotificationCategory(category);
        this.saveNotification(notificationWrapper);
    }

    public void refreshList() {
        if (Build.VERSION.SDK_INT >= 23) {
            StatusBarNotification[] activeNotifications = this.notificationManager.getActiveNotifications();
            if (activeNotifications != null) {
                ArrayList<NotificationWrapper> notificationWrappers = new ArrayList<NotificationWrapper>(this.allNotifications);
                for (StatusBarNotification notif : activeNotifications) {
                    NotificationWrapper notificationWrapper = this.getNotification(notif.getId());
                    if (notificationWrapper == null) continue;
                    notificationWrappers.remove(notificationWrapper);
                }
                for (NotificationWrapper notificationWrapper : notificationWrappers) {
                    this.land(notificationWrapper.id);
                }
            } else {
                this.landAll();
            }
        }
    }

    public void land(int id) {
        this.notificationManager.cancel(id);
        NotificationWrapper notificationWrapper = this.getNotification(id);
        this.allNotifications.remove(notificationWrapper);
        this.persistNotifications();
    }

    public void landAll(String category) {
        ArrayList<NotificationWrapper> notifications = this.getNotifications(category);
        for (NotificationWrapper notificationWrapper : notifications) {
            this.notificationManager.cancel(notificationWrapper.id);
            this.allNotifications.remove(notificationWrapper);
        }
        this.persistNotifications();
    }

    public void landAll() {
        this.notificationManager.cancelAll();
        this.allNotifications.clear();
        this.persistNotifications();
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String s) {
        if (KEY_STORED.equals(s)) {
            this.allNotifications = this.readNotificationListFromStorage(sharedPreferences);
        }
    }

    public void onDestroy() {
        this.sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }
}

