/*
 * Decompiled with CFR 0.152.
 */
package com.proximities.sdk.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.proximities.sdk.R;
import com.proximities.sdk.a.a;
import com.proximities.sdk.fragment.BaseFavoritesFragment;
import com.proximities.sdk.json.model.transmitter.Campaign;
import java.util.ArrayList;
import java.util.List;

public class DefaultFavoritesFragment
extends BaseFavoritesFragment {
    private SwipeRefreshLayout refreshLayout;
    private RecyclerView recycler;
    private TextView reconnection;
    private LinearLayout mLayoutNoFavorites;
    private List<Campaign> favorites = new ArrayList<Campaign>();
    private a adapter;

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.prxsc_default_fav_fragment, viewGroup, false);
        this.recycler = (RecyclerView)view.findViewById(R.id.recycler_fav);
        this.reconnection = (TextView)view.findViewById(R.id.reconnection);
        this.refreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_container);
        this.mLayoutNoFavorites = (LinearLayout)view.findViewById(R.id.layout_no_favorites);
        this.refreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                DefaultFavoritesFragment.this.refreshFavorites();
            }
        });
        this.reconnection.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DefaultFavoritesFragment.this.refreshFavorites();
            }
        });
        this.reconnection.setVisibility(8);
        this.recycler.setVisibility(0);
        this.adapter = new a((Context)this.getActivity(), this.favorites, this);
        this.recycler.setAdapter((RecyclerView.Adapter)this.adapter);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.refreshLayout.setRefreshing(true);
        this.refreshFavorites();
    }

    @Override
    public void onGetFavorites(List<Campaign> list) {
        super.onGetFavorites(list);
        this.refreshLayout.setRefreshing(true);
        this.reconnection.setVisibility(8);
        this.recycler.setVisibility(0);
        this.favorites.clear();
        if (list != null && list.size() > 0) {
            this.mLayoutNoFavorites.setVisibility(8);
            this.favorites.addAll(list);
        } else {
            this.mLayoutNoFavorites.setVisibility(0);
        }
        this.adapter.notifyDataSetChanged();
        this.refreshLayout.setRefreshing(false);
    }

    @Override
    public void onGetFavoritesError() {
        super.onGetFavoritesError();
        this.refreshLayout.setRefreshing(false);
        this.reconnection.setVisibility(0);
        this.recycler.setVisibility(8);
    }

    public void onStart() {
        super.onStart();
        this.recycler.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this.getActivity(), 2));
    }

    public void onStop() {
        super.onStop();
    }
}

