package com.proximities.sdk.request.api;

import android.content.Context;

import com.android.volley.DefaultRetryPolicy;
import com.proximities.sdk.corekit.CoreKitInstance;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.interfaces.LogInterface;
import com.proximities.sdk.json.model.log.BaseLogResponse;
import com.proximities.sdk.json.model.log.CampaignLogs;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.LogUtils;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 01/01/15.
 */
public final class LogRequest implements Response.Listener<BaseLogResponse>, Response.ErrorListener {

    private static final String TAG = LogUtils.makeLogTag(LogRequest.class);
    private Context ctx;
    private String wsLogs;
    private LogInterface mCallback;
    private List<CampaignLogs> logsQueue;

    public LogRequest(Context ctx, LogInterface callback) {
        this.ctx = ctx;
        this.mCallback = callback;
        logsQueue = new ArrayList<>();
        wsLogs = BuildConfig.HOST + ctx.getString(R.string.prxsc_ws_logs);
    }

    public void executePost(CampaignLogs logs) {
        logsQueue.add(logs);
        LOGD(TAG, "POST : " + wsLogs);
        Map<String, String> params = Header.getInstance().makeHeader(ctx, "POST&" + wsLogs);
        GsonRequest<BaseLogResponse> request = new GsonRequest(
                Request.Method.POST,
                wsLogs,
                logs,
                BaseLogResponse.class,
                params,
                this,
                this);
        request.setRetryPolicy(new DefaultRetryPolicy(
                0,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseLogResponse baseLogs) {
        removeFirstQueueItem();
        if(mCallback != null){
            mCallback.onSendLogSuccess(baseLogs);
        }
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        if(mCallback != null && logsQueue.size() > 0){
            mCallback.onSendLogError(logsQueue.get(0));
            removeFirstQueueItem();
        }
    }

    private void removeFirstQueueItem(){
        logsQueue.remove(0);
    }

}
