package com.proximities.sdk.request;

import android.content.Context;
import android.telephony.TelephonyManager;

import com.proximities.sdk.json.WsHeader;
import com.proximities.sdk.util.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;

import java.io.InputStreamReader;
import java.net.HttpURLConnection;

import static com.proximities.sdk.util.LogUtils.LOGD;
import static com.proximities.sdk.util.LogUtils.makeLogTag;

/**
 * Created by aat on 19/11/14.
 */
public class BaseRestRequest {

    private static final String TAG = makeLogTag(BaseRestRequest.class);

    private final Class<?> typeReturned;
    private Context ctx;
    private String baseUrl;

    public BaseRestRequest(Class<?> type, String baseUrl, Context ctx) {
        this.typeReturned = type;
        this.baseUrl = baseUrl;
        this.ctx = ctx;
    }

    private Request.Builder okHttpReqBuilder() throws Exception {
        Request.Builder builder = new Request.Builder()
                .url(baseUrl)
                .header("accept", "application/json")
                .addHeader("language", Utils.getCurrentLanguage(ctx))
                .addHeader("device", "android")
                .addHeader("phone-id", ((TelephonyManager) ctx.getSystemService(Context.TELEPHONY_SERVICE)).getDeviceId());

        return builder;
    }

    private WsHeader GET() throws Exception {
        OkHttpClient client = new OkHttpClient();
        Request request = okHttpReqBuilder().build();
        LOGD(TAG, "Headers sent");
        LOGD(TAG, request.headers().toString());
        Response resp = client.newCall(request).execute();

        WsHeader wsHeader = null;
        LOGD(TAG, "GET " + baseUrl);
        LOGD(TAG, resp.headers().toString());
        int statusCode = resp.code();
        LOGD(TAG, "Status : " + statusCode);
        if (statusCode == HttpURLConnection.HTTP_OK) {  // 200
            Gson gson = new GsonBuilder().create();
            gson.fromJson(new InputStreamReader(resp.body().byteStream()), typeReturned);
            // baseWs = (BaseWs) mapper.readValue(new BufferedInputStream(resp.body().byteStream()), typeReturned);
        } /*else if (statusCode == HttpURLConnection.HTTP_NOT_FOUND || statusCode == HttpURLConnection.HTTP_INTERNAL_ERROR) {
            try {
                baseWs = mapper.readValue(new BufferedInputStream(resp.body().byteStream()), ErrorData.class);
            } catch(Exception e) {
                baseWs = new BaseWs();
            }
        }*/ else {
            wsHeader = new WsHeader();
        }
        if(wsHeader != null) {
            wsHeader.setStatusCode(statusCode);
            wsHeader.setEtag(resp.header("Etag"));
        }
        return wsHeader;
    }


}
