/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.rules;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.github.stkent.amplify.App;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;

public final class VersionNameChangedRule
implements IEventBasedRule<String> {
    @NonNull
    private final String appVersionName;

    public VersionNameChangedRule(@NonNull Context context) {
        this(new App(context).getVersionName());
    }

    @VisibleForTesting(otherwise=2)
    VersionNameChangedRule(@NonNull String appVersionName) {
        this.appVersionName = appVersionName;
    }

    @Override
    public boolean shouldAllowFeedbackPromptByDefault() {
        return true;
    }

    @Override
    public boolean shouldAllowFeedbackPrompt(@NonNull String cachedEventValue) {
        return !cachedEventValue.equals(this.appVersionName);
    }

    @Override
    @NonNull
    public String getDescription() {
        return "VersionNameChangedRule with current app version name " + this.appVersionName;
    }
}

