/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.managers;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.tracking.Amplify;
import com.github.stkent.amplify.tracking.interfaces.IEvent;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;
import com.github.stkent.amplify.tracking.interfaces.IEventsManager;
import com.github.stkent.amplify.tracking.interfaces.ISettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseEventsManager<T>
implements IEventsManager<T> {
    private static final String AMPLIFY_TRACKING_KEY_PREFIX = "AMPLIFY_";
    private final ISettings<T> settings;
    private final ConcurrentHashMap<String, List<IEventBasedRule<T>>> internalMap;

    @NonNull
    protected abstract String getTrackedEventDimensionDescription();

    @NonNull
    protected abstract String getEventTrackingStatusStringSuffix(@NonNull T var1);

    @NonNull
    protected abstract T getUpdatedTrackingValue(@Nullable T var1);

    protected BaseEventsManager(@NonNull ISettings<T> settings) {
        this.settings = settings;
        this.internalMap = new ConcurrentHashMap();
    }

    @Override
    public void addEventBasedRule(@NonNull IEvent event, @NonNull IEventBasedRule<T> rule) {
        String eventTrackingKey = event.getTrackingKey();
        if (!this.isTrackingEvent(eventTrackingKey)) {
            this.internalMap.put(eventTrackingKey, new ArrayList());
        }
        this.internalMap.get(eventTrackingKey).add(rule);
        Amplify.getLogger().d("Registered " + rule.getDescription() + " for event " + eventTrackingKey);
    }

    @Override
    public void notifyEventTriggered(@NonNull IEvent event) {
        String eventTrackingKey = event.getTrackingKey();
        if (this.isTrackingEvent(eventTrackingKey)) {
            T cachedTrackingValue = this.getCachedTrackingValue(eventTrackingKey);
            T updatedTrackingValue = this.getUpdatedTrackingValue(cachedTrackingValue);
            if (cachedTrackingValue == null) {
                Amplify.getLogger().d("Setting " + this.getTrackedEventDimensionDescription().toLowerCase(Locale.US) + " of " + eventTrackingKey + " event to " + updatedTrackingValue);
            } else if (!updatedTrackingValue.equals(cachedTrackingValue)) {
                Amplify.getLogger().d("Updating " + this.getTrackedEventDimensionDescription().toLowerCase(Locale.US) + " of " + eventTrackingKey + " event from " + cachedTrackingValue + " to " + updatedTrackingValue);
            }
            this.settings.writeTrackingValue(this.getPersistenceTrackingKey(eventTrackingKey), updatedTrackingValue);
        }
    }

    @Override
    public boolean shouldAllowFeedbackPrompt() {
        boolean result = true;
        for (Map.Entry<String, List<IEventBasedRule<T>>> rules : this.internalMap.entrySet()) {
            String eventTrackingKey = rules.getKey();
            for (IEventBasedRule<T> rule : rules.getValue()) {
                T cachedEventValue = this.getCachedTrackingValue(eventTrackingKey);
                if (cachedEventValue != null) {
                    Amplify.getLogger().d(eventTrackingKey + " event " + this.getEventTrackingStatusStringSuffix(cachedEventValue));
                    if (rule.shouldAllowFeedbackPrompt(cachedEventValue)) continue;
                    this.logPromptBlockedMessage(rule, eventTrackingKey);
                    result = false;
                    continue;
                }
                Amplify.getLogger().d("No tracked value for " + this.getTrackedEventDimensionDescription().toLowerCase(Locale.US) + " of " + eventTrackingKey + " event");
                if (rule.shouldAllowFeedbackPromptByDefault()) continue;
                this.logPromptBlockedMessage(rule, eventTrackingKey);
                result = false;
            }
        }
        return result;
    }

    private boolean isTrackingEvent(@NonNull String eventTrackingKey) {
        return this.internalMap.containsKey(eventTrackingKey);
    }

    private String getPersistenceTrackingKey(@NonNull String eventTrackingKey) {
        return AMPLIFY_TRACKING_KEY_PREFIX + eventTrackingKey + "_" + this.getTrackingKeySuffix().toUpperCase(Locale.US);
    }

    @NonNull
    private String getTrackingKeySuffix() {
        return this.getTrackedEventDimensionDescription().trim().toUpperCase(Locale.US).replaceAll("\\s+", "_");
    }

    @Nullable
    private T getCachedTrackingValue(@NonNull String eventTrackingKey) {
        return this.settings.readTrackingValue(this.getPersistenceTrackingKey(eventTrackingKey));
    }

    private void logPromptBlockedMessage(@NonNull IEventBasedRule<T> rule, @NonNull String eventTrackingKey) {
        Amplify.getLogger().d("Blocking feedback because of " + rule.getDescription() + " associated with " + eventTrackingKey + " event");
    }
}

