/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.rules;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.github.stkent.amplify.App;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;

public final class VersionCodeChangedRule
implements IEventBasedRule<Integer> {
    private final int appVersionCode;

    public VersionCodeChangedRule(@NonNull Context context) {
        this(new App(context).getVersionCode());
    }

    @VisibleForTesting(otherwise=2)
    VersionCodeChangedRule(int appVersionCode) {
        this.appVersionCode = appVersionCode;
    }

    @Override
    public boolean shouldAllowFeedbackPromptByDefault() {
        return true;
    }

    @Override
    public boolean shouldAllowFeedbackPrompt(@NonNull Integer cachedEventValue) {
        return cachedEventValue < this.appVersionCode;
    }

    @Override
    @NonNull
    public String getDescription() {
        return "VersionCodeChangedRule with current app version code " + this.appVersionCode;
    }
}

