/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.tracking.interfaces.ISettings;
import java.util.Map;

public final class Settings<T>
implements ISettings<T> {
    private final SharedPreferences sharedPreferences;

    public Settings(@NonNull SharedPreferences sharedPreferences) {
        this.sharedPreferences = sharedPreferences;
    }

    @Override
    public void writeTrackingValue(@NonNull String trackingKey, T value) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        if (value.getClass().equals(String.class)) {
            editor.putString(trackingKey, (String)value);
        } else if (value.getClass().equals(Boolean.class)) {
            editor.putBoolean(trackingKey, ((Boolean)value).booleanValue());
        } else if (value.getClass().equals(Long.class)) {
            editor.putLong(trackingKey, ((Long)value).longValue());
        } else if (value.getClass().equals(Integer.class)) {
            editor.putInt(trackingKey, ((Integer)value).intValue());
        } else if (value.getClass().equals(Float.class)) {
            editor.putLong(trackingKey, ((Long)value).longValue());
        } else {
            throw new IllegalArgumentException("Event value must be one of String, Boolean, Long, Integer or Float");
        }
        editor.apply();
    }

    @Override
    @Nullable
    public T readTrackingValue(@NonNull String trackingKey) {
        Map map = this.sharedPreferences.getAll();
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).equals(trackingKey)) continue;
            return (T)entry.getValue();
        }
        return null;
    }
}

