/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.feedback;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.IApp;
import com.github.stkent.amplify.IDevice;
import com.github.stkent.amplify.IEnvironment;
import com.github.stkent.amplify.feedback.BaseEmailFeedbackCollector;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DefaultEmailFeedbackCollector
extends BaseEmailFeedbackCollector {
    public DefaultEmailFeedbackCollector(String ... recipients) {
        super(recipients);
    }

    @Override
    @NonNull
    protected String getSubjectLine(@NonNull IApp app, @NonNull IEnvironment environment, @NonNull IDevice device) {
        return app.getName() + " Android App Feedback";
    }

    @Override
    @NonNull
    protected String getBody(@NonNull IApp app, @NonNull IEnvironment environment, @NonNull IDevice device) {
        String androidVersionString = String.format("%s (%s)", environment.getAndroidVersionName(), environment.getAndroidVersionCode());
        String appVersionString = String.format("%s (%s)", app.getVersionName(), app.getVersionCode());
        return "Time Stamp: " + this.getCurrentUtcTimeStringForDate(new Date()) + "\n" + "App Version: " + appVersionString + "\n" + "Install Source: " + app.getInstallSource() + "\n" + "Android Version: " + androidVersionString + "\n" + "Device Manufacturer: " + device.getManufacturer() + "\n" + "Device Model: " + device.getModel() + "\n" + "Display Resolution: " + device.getResolution() + "\n" + "Display Density (Actual): " + device.getActualDensity() + "\n" + "Display Density (Bucket) " + device.getDensityBucket() + "\n" + "---------------------\n\n";
    }

    @NonNull
    private String getCurrentUtcTimeStringForDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss z", Locale.getDefault());
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(date);
    }
}

