/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.App;
import com.github.stkent.amplify.Device;
import com.github.stkent.amplify.Environment;
import com.github.stkent.amplify.feedback.IFeedbackCollector;
import com.github.stkent.amplify.logging.ILogger;
import com.github.stkent.amplify.logging.NoOpLogger;
import com.github.stkent.amplify.prompt.interfaces.IPromptView;
import com.github.stkent.amplify.tracking.PromptInteractionEvent;
import com.github.stkent.amplify.tracking.Settings;
import com.github.stkent.amplify.tracking.interfaces.IAppLevelEventRulesManager;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentBasedRule;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentBasedRulesManager;
import com.github.stkent.amplify.tracking.interfaces.IEvent;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;
import com.github.stkent.amplify.tracking.interfaces.IEventListener;
import com.github.stkent.amplify.tracking.interfaces.IEventsManager;
import com.github.stkent.amplify.tracking.interfaces.ISettings;
import com.github.stkent.amplify.tracking.managers.AppLevelEventRulesManager;
import com.github.stkent.amplify.tracking.managers.EnvironmentBasedRulesManager;
import com.github.stkent.amplify.tracking.managers.FirstEventTimeRulesManager;
import com.github.stkent.amplify.tracking.managers.LastEventTimeRulesManager;
import com.github.stkent.amplify.tracking.managers.LastEventVersionCodeRulesManager;
import com.github.stkent.amplify.tracking.managers.LastEventVersionNameRulesManager;
import com.github.stkent.amplify.tracking.managers.TotalEventCountRulesManager;
import com.github.stkent.amplify.tracking.rules.GooglePlayStoreRule;
import com.github.stkent.amplify.tracking.rules.MaximumCountRule;
import com.github.stkent.amplify.tracking.rules.VersionNameChangedRule;
import com.github.stkent.amplify.utils.ActivityReferenceManager;

public final class Amplify
implements IEventListener {
    private static final int DEFAULT_USER_GAVE_POSITIVE_FEEDBACK_MAXIMUM_COUNT = 1;
    private static final int DEFAULT_LAST_UPDATE_TIME_COOLDOWN_DAYS = 7;
    private static final int DEFAULT_LAST_CRASH_TIME_COOLDOWN_DAYS = 7;
    private static ILogger sharedLogger = new NoOpLogger();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Amplify sharedInstance;
    private final Context applicationContext;
    private final ActivityReferenceManager activityReferenceManager;
    private final IEnvironmentBasedRulesManager environmentBasedRulesManager;
    private final IAppLevelEventRulesManager appLevelEventRulesManager;
    private final IEventsManager<Long> firstEventTimeRulesManager;
    private final IEventsManager<Long> lastEventTimeRulesManager;
    private final IEventsManager<Integer> lastEventVersionCodeRulesManager;
    private final IEventsManager<String> lastEventVersionNameRulesManager;
    private final IEventsManager<Integer> totalEventCountRulesManager;
    private boolean alwaysShow;
    private IFeedbackCollector[] positiveFeedbackCollectors;
    private IFeedbackCollector[] criticalFeedbackCollectors;

    public static ILogger getLogger() {
        return sharedLogger;
    }

    public static void setLogger(@NonNull ILogger logger) {
        sharedLogger = logger;
    }

    public static Amplify initSharedInstance(@NonNull Application application) {
        return Amplify.initSharedInstance(application, "AMPLIFY_SHARED_PREFERENCES_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Amplify initSharedInstance(@NonNull Application application, @NonNull String backingSharedPreferencesName) {
        Class<Amplify> clazz = Amplify.class;
        synchronized (Amplify.class) {
            if (sharedInstance == null) {
                sharedInstance = new Amplify(application, backingSharedPreferencesName);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sharedInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Amplify getSharedInstance() {
        Class<Amplify> clazz = Amplify.class;
        synchronized (Amplify.class) {
            if (sharedInstance == null) {
                throw new IllegalStateException("You must call initSharedInstance before calling getSharedInstance.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sharedInstance;
        }
    }

    private Amplify(@NonNull Application application, @NonNull String sharedPrefsName) {
        this.applicationContext = application;
        this.activityReferenceManager = new ActivityReferenceManager();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityReferenceManager);
        Environment environment = new Environment((Context)application);
        this.environmentBasedRulesManager = new EnvironmentBasedRulesManager(environment);
        App app = new App((Context)application);
        SharedPreferences sharedPrefs = application.getSharedPreferences(sharedPrefsName, 0);
        this.appLevelEventRulesManager = new AppLevelEventRulesManager(new Settings<Long>(sharedPrefs), app);
        this.firstEventTimeRulesManager = new FirstEventTimeRulesManager((ISettings<Long>)new Settings<Long>(sharedPrefs));
        this.lastEventTimeRulesManager = new LastEventTimeRulesManager((ISettings<Long>)new Settings<Long>(sharedPrefs));
        this.lastEventVersionNameRulesManager = new LastEventVersionNameRulesManager(new Settings<String>(sharedPrefs), app);
        this.lastEventVersionCodeRulesManager = new LastEventVersionCodeRulesManager(new Settings<Integer>(sharedPrefs), app);
        this.totalEventCountRulesManager = new TotalEventCountRulesManager((ISettings<Integer>)new Settings<Integer>(sharedPrefs));
    }

    public Amplify setPositiveFeedbackCollectors(IFeedbackCollector ... feedbackCollectors) {
        this.positiveFeedbackCollectors = feedbackCollectors;
        return this;
    }

    public Amplify setCriticalFeedbackCollectors(IFeedbackCollector ... feedbackCollectors) {
        this.criticalFeedbackCollectors = feedbackCollectors;
        return this;
    }

    public Amplify applyAllDefaultRules() {
        return this.addEnvironmentBasedRule(new GooglePlayStoreRule()).setLastUpdateTimeCooldownDays(7).setLastCrashTimeCooldownDays(7).addTotalEventCountRule(PromptInteractionEvent.USER_GAVE_POSITIVE_FEEDBACK, new MaximumCountRule(1)).addLastEventVersionNameRule(PromptInteractionEvent.USER_GAVE_CRITICAL_FEEDBACK, new VersionNameChangedRule(this.applicationContext)).addLastEventVersionNameRule(PromptInteractionEvent.USER_DECLINED_CRITICAL_FEEDBACK, new VersionNameChangedRule(this.applicationContext)).addLastEventVersionNameRule(PromptInteractionEvent.USER_DECLINED_POSITIVE_FEEDBACK, new VersionNameChangedRule(this.applicationContext));
    }

    public Amplify addEnvironmentBasedRule(@NonNull IEnvironmentBasedRule rule) {
        this.environmentBasedRulesManager.addEnvironmentBasedRule(rule);
        return this;
    }

    public Amplify setInstallTimeCooldownDays(int cooldownPeriodDays) {
        this.appLevelEventRulesManager.setInstallTimeCooldownDays(cooldownPeriodDays);
        return this;
    }

    public Amplify setLastUpdateTimeCooldownDays(int cooldownPeriodDays) {
        this.appLevelEventRulesManager.setLastUpdateTimeCooldownDays(cooldownPeriodDays);
        return this;
    }

    public Amplify setLastCrashTimeCooldownDays(int cooldownPeriodDays) {
        this.appLevelEventRulesManager.setLastCrashTimeCooldownDays(cooldownPeriodDays);
        return this;
    }

    public Amplify addTotalEventCountRule(@NonNull IEvent event, @NonNull IEventBasedRule<Integer> rule) {
        this.totalEventCountRulesManager.addEventBasedRule(event, rule);
        return this;
    }

    public Amplify addFirstEventTimeRule(@NonNull IEvent event, @NonNull IEventBasedRule<Long> rule) {
        this.firstEventTimeRulesManager.addEventBasedRule(event, rule);
        return this;
    }

    public Amplify addLastEventTimeRule(@NonNull IEvent event, @NonNull IEventBasedRule<Long> rule) {
        this.lastEventTimeRulesManager.addEventBasedRule(event, rule);
        return this;
    }

    public Amplify addLastEventVersionCodeRule(@NonNull IEvent event, @NonNull IEventBasedRule<Integer> rule) {
        this.lastEventVersionCodeRulesManager.addEventBasedRule(event, rule);
        return this;
    }

    public Amplify addLastEventVersionNameRule(@NonNull IEvent event, @NonNull IEventBasedRule<String> rule) {
        this.lastEventVersionNameRulesManager.addEventBasedRule(event, rule);
        return this;
    }

    public Amplify setAlwaysShow(boolean alwaysShow) {
        this.alwaysShow = alwaysShow;
        return this;
    }

    @Override
    public void notifyEventTriggered(@NonNull IEvent event) {
        block5: {
            block4: {
                sharedLogger.d(event.getTrackingKey() + " event triggered");
                this.totalEventCountRulesManager.notifyEventTriggered(event);
                this.firstEventTimeRulesManager.notifyEventTriggered(event);
                this.lastEventTimeRulesManager.notifyEventTriggered(event);
                this.lastEventVersionCodeRulesManager.notifyEventTriggered(event);
                this.lastEventVersionNameRulesManager.notifyEventTriggered(event);
                if (event != PromptInteractionEvent.USER_GAVE_POSITIVE_FEEDBACK) break block4;
                Activity activity = this.activityReferenceManager.getValidatedActivity();
                if (activity == null) {
                    return;
                }
                for (IFeedbackCollector positiveFeedbackCollector : this.positiveFeedbackCollectors) {
                    if (!positiveFeedbackCollector.tryCollectingFeedback(activity, new App(this.applicationContext), new Environment(this.applicationContext), new Device(this.applicationContext))) continue;
                    return;
                }
                break block5;
            }
            if (event != PromptInteractionEvent.USER_GAVE_CRITICAL_FEEDBACK) break block5;
            Activity activity = this.activityReferenceManager.getValidatedActivity();
            if (activity == null) {
                return;
            }
            for (IFeedbackCollector criticalFeedbackCollector : this.criticalFeedbackCollectors) {
                if (!criticalFeedbackCollector.tryCollectingFeedback(activity, new App(this.applicationContext), new Environment(this.applicationContext), new Device(this.applicationContext))) continue;
                return;
            }
        }
    }

    public void promptIfReady(@NonNull IPromptView promptView) {
        if (!this.isConfigured()) {
            throw new IllegalStateException("Must finish configuration before attempting to prompt.");
        }
        if (this.shouldPrompt()) {
            promptView.getPresenter().start();
        }
    }

    public boolean shouldPrompt() {
        return this.alwaysShow | this.appLevelEventRulesManager.shouldAllowFeedbackPrompt() & this.environmentBasedRulesManager.shouldAllowFeedbackPrompt() & this.totalEventCountRulesManager.shouldAllowFeedbackPrompt() & this.firstEventTimeRulesManager.shouldAllowFeedbackPrompt() & this.lastEventTimeRulesManager.shouldAllowFeedbackPrompt() & this.lastEventVersionCodeRulesManager.shouldAllowFeedbackPrompt() & this.lastEventVersionNameRulesManager.shouldAllowFeedbackPrompt();
    }

    private boolean isConfigured() {
        return this.positiveFeedbackCollectors != null && this.criticalFeedbackCollectors != null;
    }
}

