/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.managers;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.Amplify;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentBasedRule;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentBasedRulesManager;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentCapabilitiesProvider;
import java.util.ArrayList;
import java.util.List;

public final class EnvironmentBasedRulesManager
implements IEnvironmentBasedRulesManager {
    @NonNull
    private final IEnvironmentCapabilitiesProvider environmentCapabilitiesProvider;
    @NonNull
    private final List<IEnvironmentBasedRule> environmentBasedRules = new ArrayList<IEnvironmentBasedRule>();

    public EnvironmentBasedRulesManager(@NonNull IEnvironmentCapabilitiesProvider environmentCapabilitiesProvider) {
        this.environmentCapabilitiesProvider = environmentCapabilitiesProvider;
    }

    @Override
    public void addEnvironmentBasedRule(@NonNull IEnvironmentBasedRule rule) {
        this.environmentBasedRules.add(rule);
    }

    @Override
    public boolean shouldAllowFeedbackPrompt() {
        for (IEnvironmentBasedRule rule : this.environmentBasedRules) {
            if (rule.shouldAllowFeedbackPrompt(this.environmentCapabilitiesProvider)) continue;
            Amplify.getLogger().d("Blocking feedback because of environment based rule: " + rule);
            return false;
        }
        return true;
    }
}

