/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.Logger;
import com.github.stkent.amplify.prompt.interfaces.IPromptView;
import com.github.stkent.amplify.tracking.AppEventTimeProvider;
import com.github.stkent.amplify.tracking.AppFeedbackDataProvider;
import com.github.stkent.amplify.tracking.EnvironmentCapabilitiesProvider;
import com.github.stkent.amplify.tracking.PromptInteractionEvent;
import com.github.stkent.amplify.tracking.interfaces.IAppLevelEventRulesManager;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentBasedRule;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentBasedRulesManager;
import com.github.stkent.amplify.tracking.interfaces.IEvent;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;
import com.github.stkent.amplify.tracking.interfaces.IEventListener;
import com.github.stkent.amplify.tracking.managers.AppLevelEventRulesManager;
import com.github.stkent.amplify.tracking.managers.EnvironmentBasedRulesManager;
import com.github.stkent.amplify.tracking.managers.FirstEventTimeRulesManager;
import com.github.stkent.amplify.tracking.managers.LastEventTimeRulesManager;
import com.github.stkent.amplify.tracking.managers.LastEventVersionCodeRulesManager;
import com.github.stkent.amplify.tracking.managers.LastEventVersionNameRulesManager;
import com.github.stkent.amplify.tracking.managers.TotalEventCountRulesManager;
import com.github.stkent.amplify.tracking.rules.GooglePlayStoreRule;
import com.github.stkent.amplify.tracking.rules.MaximumCountRule;
import com.github.stkent.amplify.tracking.rules.VersionNameChangedRule;
import com.github.stkent.amplify.utils.ActivityReferenceManager;
import com.github.stkent.amplify.utils.FeedbackUtil;
import com.github.stkent.amplify.utils.PlayStoreUtil;
import com.github.stkent.amplify.utils.appinfo.AppInfoUtil;
import com.github.stkent.amplify.utils.appinfo.IAppInfoProvider;

public final class Amplify
implements IEventListener {
    private static final int DEFAULT_USER_GAVE_POSITIVE_FEEDBACK_MAXIMUM_COUNT = 1;
    private static final int DEFAULT_LAST_UPDATE_TIME_COOLDOWN_DAYS = 7;
    private static final int DEFAULT_LAST_CRASH_TIME_COOLDOWN_DAYS = 7;
    private static Amplify sharedInstance;
    private final IAppInfoProvider appInfoProvider;
    private final IAppLevelEventRulesManager appLevelEventRulesManager;
    private final IEnvironmentBasedRulesManager environmentBasedRulesManager;
    private final FirstEventTimeRulesManager firstEventTimeRulesManager;
    private final LastEventTimeRulesManager lastEventTimeRulesManager;
    private final LastEventVersionCodeRulesManager lastEventVersionCodeRulesManager;
    private final LastEventVersionNameRulesManager lastEventVersionNameRulesManager;
    private final TotalEventCountRulesManager totalEventCountRulesManager;
    private final ActivityReferenceManager activityReferenceManager;
    private final ILogger logger;
    private boolean alwaysShow;
    private String packageName;
    private String feedbackEmailAddress;

    public static Amplify initSharedInstance(@NonNull Application app) {
        return Amplify.initSharedInstance(app, new Logger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Amplify initSharedInstance(@NonNull Application app, @NonNull ILogger logger) {
        Class<Amplify> clazz = Amplify.class;
        synchronized (Amplify.class) {
            if (sharedInstance == null) {
                sharedInstance = new Amplify(app, logger);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sharedInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Amplify getSharedInstance() {
        Class<Amplify> clazz = Amplify.class;
        synchronized (Amplify.class) {
            if (sharedInstance == null) {
                throw new IllegalStateException("You must call initSharedInstance before calling getSharedInstance.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sharedInstance;
        }
    }

    private Amplify(@NonNull Application app, @NonNull ILogger logger) {
        Context appContext = app.getApplicationContext();
        AppInfoUtil.initialize(appContext);
        this.appInfoProvider = AppInfoUtil.getSharedAppInfoProvider();
        AppEventTimeProvider appEventTimeProvider = new AppEventTimeProvider(this.appInfoProvider);
        EnvironmentCapabilitiesProvider environmentCapabilitiesProvider = new EnvironmentCapabilitiesProvider(this.appInfoProvider);
        this.appLevelEventRulesManager = new AppLevelEventRulesManager(appContext, appEventTimeProvider, logger);
        this.environmentBasedRulesManager = new EnvironmentBasedRulesManager(environmentCapabilitiesProvider, logger);
        this.firstEventTimeRulesManager = new FirstEventTimeRulesManager(appContext, logger);
        this.lastEventTimeRulesManager = new LastEventTimeRulesManager(appContext, logger);
        this.lastEventVersionNameRulesManager = new LastEventVersionNameRulesManager(appContext, this.appInfoProvider, logger);
        this.lastEventVersionCodeRulesManager = new LastEventVersionCodeRulesManager(appContext, this.appInfoProvider, logger);
        this.totalEventCountRulesManager = new TotalEventCountRulesManager(appContext, logger);
        this.activityReferenceManager = new ActivityReferenceManager();
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityReferenceManager);
        this.logger = logger;
    }

    public Amplify setFeedbackEmailAddress(@NonNull String feedbackEmailAddress) {
        this.feedbackEmailAddress = feedbackEmailAddress;
        return this;
    }

    public Amplify applyAllDefaultRules() {
        return this.addEnvironmentBasedRule(new GooglePlayStoreRule()).setLastUpdateTimeCooldownDays(7).setLastCrashTimeCooldownDays(7).addTotalEventCountRule(PromptInteractionEvent.USER_GAVE_POSITIVE_FEEDBACK, new MaximumCountRule(1)).addLastEventVersionNameRule(PromptInteractionEvent.USER_GAVE_CRITICAL_FEEDBACK, new VersionNameChangedRule()).addLastEventVersionNameRule(PromptInteractionEvent.USER_DECLINED_CRITICAL_FEEDBACK, new VersionNameChangedRule()).addLastEventVersionNameRule(PromptInteractionEvent.USER_DECLINED_POSITIVE_FEEDBACK, new VersionNameChangedRule());
    }

    public Amplify addEnvironmentBasedRule(@NonNull IEnvironmentBasedRule rule) {
        this.environmentBasedRulesManager.addEnvironmentBasedRule(rule);
        return this;
    }

    public Amplify setInstallTimeCooldownDays(int cooldownPeriodDays) {
        this.appLevelEventRulesManager.setInstallTimeCooldownDays(cooldownPeriodDays);
        return this;
    }

    public Amplify setLastUpdateTimeCooldownDays(int cooldownPeriodDays) {
        this.appLevelEventRulesManager.setLastUpdateTimeCooldownDays(cooldownPeriodDays);
        return this;
    }

    public Amplify setLastCrashTimeCooldownDays(int cooldownPeriodDays) {
        this.appLevelEventRulesManager.setLastCrashTimeCooldownDays(cooldownPeriodDays);
        return this;
    }

    public Amplify addTotalEventCountRule(@NonNull IEvent event, @NonNull IEventBasedRule<Integer> rule) {
        this.totalEventCountRulesManager.addEventBasedRule(event, rule);
        return this;
    }

    public Amplify addFirstEventTimeRule(@NonNull IEvent event, @NonNull IEventBasedRule<Long> rule) {
        this.firstEventTimeRulesManager.addEventBasedRule(event, rule);
        return this;
    }

    public Amplify addLastEventTimeRule(@NonNull IEvent event, @NonNull IEventBasedRule<Long> rule) {
        this.lastEventTimeRulesManager.addEventBasedRule(event, rule);
        return this;
    }

    public Amplify addLastEventVersionCodeRule(@NonNull IEvent event, @NonNull IEventBasedRule<Integer> rule) {
        this.lastEventVersionCodeRulesManager.addEventBasedRule(event, rule);
        return this;
    }

    public Amplify addLastEventVersionNameRule(@NonNull IEvent event, @NonNull IEventBasedRule<String> rule) {
        this.lastEventVersionNameRulesManager.addEventBasedRule(event, rule);
        return this;
    }

    public Amplify setLogLevel(@NonNull Logger.LogLevel logLevel) {
        this.logger.setLogLevel(logLevel);
        return this;
    }

    public Amplify setAlwaysShow(boolean alwaysShow) {
        this.alwaysShow = alwaysShow;
        return this;
    }

    public Amplify setPackageName(@NonNull String packageName) {
        this.packageName = packageName;
        return this;
    }

    @Override
    public void notifyEventTriggered(@NonNull IEvent event) {
        Activity activity;
        this.logger.d(event.getTrackingKey() + " event triggered");
        this.totalEventCountRulesManager.notifyEventTriggered(event);
        this.firstEventTimeRulesManager.notifyEventTriggered(event);
        this.lastEventTimeRulesManager.notifyEventTriggered(event);
        this.lastEventVersionCodeRulesManager.notifyEventTriggered(event);
        this.lastEventVersionNameRulesManager.notifyEventTriggered(event);
        if (event == PromptInteractionEvent.USER_GAVE_POSITIVE_FEEDBACK) {
            Activity activity2 = this.activityReferenceManager.getValidatedActivity();
            if (activity2 != null) {
                PlayStoreUtil.openPlayStoreToRate(activity2, this.packageName);
            }
        } else if (event == PromptInteractionEvent.USER_GAVE_CRITICAL_FEEDBACK && (activity = this.activityReferenceManager.getValidatedActivity()) != null) {
            FeedbackUtil feedbackUtil = new FeedbackUtil(new AppFeedbackDataProvider(this.appInfoProvider), new EnvironmentCapabilitiesProvider(this.appInfoProvider), this.feedbackEmailAddress, this.logger);
            feedbackUtil.showFeedbackEmailChooser(activity);
        }
    }

    public void promptIfReady(@NonNull IPromptView promptView) {
        if (this.feedbackEmailAddress == null) {
            throw new IllegalStateException("Must provide email address before attempting to prompt.");
        }
        if (this.shouldPrompt()) {
            promptView.getPresenter().start();
        }
    }

    public boolean shouldPrompt() {
        return this.alwaysShow | this.appLevelEventRulesManager.shouldAllowFeedbackPrompt() & this.environmentBasedRulesManager.shouldAllowFeedbackPrompt() & this.totalEventCountRulesManager.shouldAllowFeedbackPrompt() & this.firstEventTimeRulesManager.shouldAllowFeedbackPrompt() & this.lastEventTimeRulesManager.shouldAllowFeedbackPrompt() & this.lastEventVersionCodeRulesManager.shouldAllowFeedbackPrompt() & this.lastEventVersionNameRulesManager.shouldAllowFeedbackPrompt();
    }
}

