/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.prompt.BasePromptView;
import com.github.stkent.amplify.prompt.CustomLayoutPromptViewConfig;
import com.github.stkent.amplify.prompt.CustomLayoutQuestionView;
import com.github.stkent.amplify.prompt.CustomLayoutThanksView;
import com.github.stkent.amplify.prompt.interfaces.IPromptView;

public final class CustomLayoutPromptView
extends BasePromptView<CustomLayoutQuestionView, CustomLayoutThanksView>
implements IPromptView {
    private CustomLayoutPromptViewConfig config;

    public CustomLayoutPromptView(Context context) {
        this(context, null);
    }

    public CustomLayoutPromptView(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CustomLayoutPromptView(Context context, @Nullable AttributeSet attributeSet, int defStyleAttr) {
        super(context, attributeSet, defStyleAttr);
        this.init(attributeSet);
    }

    public void applyConfig(@NonNull CustomLayoutPromptViewConfig config) {
        if (this.isDisplayed()) {
            throw new IllegalStateException("Configuration cannot be changed after the prompt is first displayed.");
        }
        this.config = config;
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.config = this.config;
        return savedState;
    }

    @Override
    protected void onRestoreInstanceState(@NonNull Parcelable state) {
        SavedState savedState = (SavedState)state;
        Parcelable superSavedState = savedState.getSuperState();
        super.onRestoreInstanceState(superSavedState);
        this.applyConfig(savedState.config);
        this.restorePresenterState(superSavedState);
    }

    @Override
    protected boolean isConfigured() {
        return this.config.isValid();
    }

    @Override
    @NonNull
    protected CustomLayoutQuestionView getQuestionView() {
        return new CustomLayoutQuestionView(this.getContext(), this.config.getQuestionLayout());
    }

    @Override
    @Nullable
    protected CustomLayoutThanksView getThanksView() {
        if (this.config.getThanksLayout() != null) {
            return new CustomLayoutThanksView(this.getContext(), this.config.getThanksLayout());
        }
        return null;
    }

    private void init(@Nullable AttributeSet attributeSet) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.CustomLayoutPromptView, 0, 0);
        this.config = new CustomLayoutPromptViewConfig(typedArray);
        typedArray.recycle();
    }

    private static class SavedState
    extends View.BaseSavedState {
        private CustomLayoutPromptViewConfig config;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        protected SavedState(Parcelable superState) {
            super(superState);
        }

        protected SavedState(Parcel in) {
            super(in);
            this.config = (CustomLayoutPromptViewConfig)in.readParcelable(((Object)((Object)this)).getClass().getClassLoader());
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeParcelable((Parcelable)this.config, flags);
        }
    }
}

