/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.prompt.Question;
import com.github.stkent.amplify.prompt.Thanks;
import com.github.stkent.amplify.prompt.interfaces.IQuestion;
import com.github.stkent.amplify.prompt.interfaces.IThanks;
import com.github.stkent.amplify.utils.StringUtils;

public final class BasePromptViewConfig {
    private static final String DEFAULT_USER_OPINION_QUESTION_TITLE = "Enjoying the app?";
    private static final String DEFAULT_POSITIVE_FEEDBACK_QUESTION_TITLE = "Awesome! We'd love a Play Store review...";
    private static final String DEFAULT_CRITICAL_FEEDBACK_QUESTION_TITLE = "Bummer. Would you like to send feedback?";
    private static final String DEFAULT_USER_OPINION_QUESTION_POSITIVE_BUTTON_LABEL = "Yes!";
    private static final String DEFAULT_USER_OPINION_QUESTION_NEGATIVE_BUTTON_LABEL = "No";
    private static final String DEFAULT_FEEDBACK_QUESTION_POSITIVE_BUTTON_LABEL = "Sure thing!";
    private static final String DEFAULT_FEEDBACK_QUESTION_NEGATIVE_BUTTON_LABEL = "Not right now";
    private static final String DEFAULT_THANKS_TITLE = "Thanks for your feedback!";
    @Nullable
    private final String userOpinionQuestionTitle;
    @Nullable
    private final String userOpinionQuestionSubtitle;
    @Nullable
    private final String userOpinionQuestionPositiveButtonLabel;
    @Nullable
    private final String userOpinionQuestionNegativeButtonLabel;
    @Nullable
    private final String positiveFeedbackQuestionTitle;
    @Nullable
    private final String positiveFeedbackQuestionSubtitle;
    @Nullable
    private final String positiveFeedbackQuestionPositiveButtonLabel;
    @Nullable
    private final String positiveFeedbackQuestionNegativeButtonLabel;
    @Nullable
    private final String criticalFeedbackQuestionTitle;
    @Nullable
    private final String criticalFeedbackQuestionSubtitle;
    @Nullable
    private final String criticalFeedbackQuestionPositiveButtonLabel;
    @Nullable
    private final String criticalFeedbackQuestionNegativeButtonLabel;
    @Nullable
    private final String thanksTitle;
    @Nullable
    private final String thanksSubtitle;

    public BasePromptViewConfig(@NonNull TypedArray typedArray) {
        this.userOpinionQuestionTitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_user_opinion_question_title);
        this.userOpinionQuestionSubtitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_user_opinion_question_subtitle);
        this.userOpinionQuestionPositiveButtonLabel = typedArray.getString(R.styleable.BasePromptView_prompt_view_user_opinion_question_positive_button_label);
        this.userOpinionQuestionNegativeButtonLabel = typedArray.getString(R.styleable.BasePromptView_prompt_view_user_opinion_question_negative_button_label);
        this.positiveFeedbackQuestionTitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_positive_feedback_question_title);
        this.positiveFeedbackQuestionSubtitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_positive_feedback_question_subtitle);
        this.positiveFeedbackQuestionPositiveButtonLabel = typedArray.getString(R.styleable.BasePromptView_prompt_view_positive_feedback_question_positive_button_label);
        this.positiveFeedbackQuestionNegativeButtonLabel = typedArray.getString(R.styleable.BasePromptView_prompt_view_positive_feedback_question_negative_button_label);
        this.criticalFeedbackQuestionTitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_critical_feedback_question_title);
        this.criticalFeedbackQuestionSubtitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_critical_feedback_question_subtitle);
        this.criticalFeedbackQuestionPositiveButtonLabel = typedArray.getString(R.styleable.BasePromptView_prompt_view_critical_feedback_question_positive_button_label);
        this.criticalFeedbackQuestionNegativeButtonLabel = typedArray.getString(R.styleable.BasePromptView_prompt_view_critical_feedback_question_negative_button_label);
        this.thanksTitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_thanks_title);
        this.thanksSubtitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_thanks_subtitle);
    }

    protected BasePromptViewConfig(@Nullable String userOpinionQuestionTitle, @Nullable String userOpinionQuestionPositiveButtonLabel, @Nullable String userOpinionQuestionNegativeButtonLabel, @Nullable String positiveFeedbackQuestionTitle, @Nullable String positiveFeedbackQuestionPositiveButtonLabel, @Nullable String positiveFeedbackQuestionNegativeButtonLabel, @Nullable String criticalFeedbackQuestionTitle, @Nullable String criticalFeedbackQuestionPositiveButtonLabel, @Nullable String criticalFeedbackQuestionNegativeButtonLabel, @Nullable String thanksTitle, @Nullable String userOpinionQuestionSubtitle, @Nullable String positiveFeedbackQuestionSubtitle, @Nullable String criticalFeedbackQuestionSubtitle, @Nullable String thanksSubtitle) {
        this.userOpinionQuestionTitle = userOpinionQuestionTitle;
        this.userOpinionQuestionPositiveButtonLabel = userOpinionQuestionPositiveButtonLabel;
        this.userOpinionQuestionNegativeButtonLabel = userOpinionQuestionNegativeButtonLabel;
        this.positiveFeedbackQuestionTitle = positiveFeedbackQuestionTitle;
        this.positiveFeedbackQuestionPositiveButtonLabel = positiveFeedbackQuestionPositiveButtonLabel;
        this.positiveFeedbackQuestionNegativeButtonLabel = positiveFeedbackQuestionNegativeButtonLabel;
        this.criticalFeedbackQuestionTitle = criticalFeedbackQuestionTitle;
        this.criticalFeedbackQuestionPositiveButtonLabel = criticalFeedbackQuestionPositiveButtonLabel;
        this.criticalFeedbackQuestionNegativeButtonLabel = criticalFeedbackQuestionNegativeButtonLabel;
        this.thanksTitle = thanksTitle;
        this.userOpinionQuestionSubtitle = userOpinionQuestionSubtitle;
        this.positiveFeedbackQuestionSubtitle = positiveFeedbackQuestionSubtitle;
        this.criticalFeedbackQuestionSubtitle = criticalFeedbackQuestionSubtitle;
        this.thanksSubtitle = thanksSubtitle;
    }

    @NonNull
    public IQuestion getUserOpinionQuestion() {
        return new Question(this.getUserOpinionQuestionTitle(), this.userOpinionQuestionSubtitle, this.getUserOpinionQuestionPositiveButtonLabel(), this.getUserOpinionQuestionNegativeButtonLabel());
    }

    @NonNull
    public IQuestion getPositiveFeedbackQuestion() {
        return new Question(this.getPositiveFeedbackQuestionTitle(), this.positiveFeedbackQuestionSubtitle, this.getPositiveFeedbackQuestionPositiveButtonLabel(), this.getPositiveFeedbackQuestionNegativeButtonLabel());
    }

    @NonNull
    public IQuestion getCriticalFeedbackQuestion() {
        return new Question(this.getCriticalFeedbackQuestionTitle(), this.criticalFeedbackQuestionSubtitle, this.getCriticalFeedbackQuestionPositiveButtonLabel(), this.getCriticalFeedbackQuestionNegativeButtonLabel());
    }

    @NonNull
    public IThanks getThanks() {
        return new Thanks(this.getThanksTitle(), this.thanksSubtitle);
    }

    @NonNull
    private String getUserOpinionQuestionTitle() {
        return StringUtils.defaultIfBlank(this.userOpinionQuestionTitle, DEFAULT_USER_OPINION_QUESTION_TITLE);
    }

    @NonNull
    private String getUserOpinionQuestionPositiveButtonLabel() {
        return StringUtils.defaultIfBlank(this.userOpinionQuestionPositiveButtonLabel, DEFAULT_USER_OPINION_QUESTION_POSITIVE_BUTTON_LABEL);
    }

    @NonNull
    private String getUserOpinionQuestionNegativeButtonLabel() {
        return StringUtils.defaultIfBlank(this.userOpinionQuestionNegativeButtonLabel, DEFAULT_USER_OPINION_QUESTION_NEGATIVE_BUTTON_LABEL);
    }

    @NonNull
    private String getPositiveFeedbackQuestionTitle() {
        return StringUtils.defaultIfBlank(this.positiveFeedbackQuestionTitle, DEFAULT_POSITIVE_FEEDBACK_QUESTION_TITLE);
    }

    @NonNull
    private String getPositiveFeedbackQuestionPositiveButtonLabel() {
        return StringUtils.defaultIfBlank(this.positiveFeedbackQuestionPositiveButtonLabel, DEFAULT_FEEDBACK_QUESTION_POSITIVE_BUTTON_LABEL);
    }

    @NonNull
    private String getPositiveFeedbackQuestionNegativeButtonLabel() {
        return StringUtils.defaultIfBlank(this.positiveFeedbackQuestionNegativeButtonLabel, DEFAULT_FEEDBACK_QUESTION_NEGATIVE_BUTTON_LABEL);
    }

    @NonNull
    private String getCriticalFeedbackQuestionTitle() {
        return StringUtils.defaultIfBlank(this.criticalFeedbackQuestionTitle, DEFAULT_CRITICAL_FEEDBACK_QUESTION_TITLE);
    }

    @NonNull
    private String getCriticalFeedbackQuestionPositiveButtonLabel() {
        return StringUtils.defaultIfBlank(this.criticalFeedbackQuestionPositiveButtonLabel, DEFAULT_FEEDBACK_QUESTION_POSITIVE_BUTTON_LABEL);
    }

    @NonNull
    private String getCriticalFeedbackQuestionNegativeButtonLabel() {
        return StringUtils.defaultIfBlank(this.criticalFeedbackQuestionNegativeButtonLabel, DEFAULT_FEEDBACK_QUESTION_NEGATIVE_BUTTON_LABEL);
    }

    @NonNull
    private String getThanksTitle() {
        return StringUtils.defaultIfBlank(this.thanksTitle, DEFAULT_THANKS_TITLE);
    }

    public static final class Builder {
        @Nullable
        private String userOpinionQuestionTitle;
        @Nullable
        private String userOpinionQuestionPositiveButtonLabel;
        @Nullable
        private String userOpinionQuestionNegativeButtonLabel;
        @Nullable
        private String positiveFeedbackQuestionTitle;
        @Nullable
        private String positiveFeedbackQuestionPositiveButtonLabel;
        @Nullable
        private String positiveFeedbackQuestionNegativeButtonLabel;
        @Nullable
        private String criticalFeedbackQuestionTitle;
        @Nullable
        private String criticalFeedbackQuestionPositiveButtonLabel;
        @Nullable
        private String criticalFeedbackQuestionNegativeButtonLabel;
        @Nullable
        private String thanksTitle;
        @Nullable
        private String userOpinionQuestionSubtitle;
        @Nullable
        private String positiveFeedbackQuestionSubtitle;
        @Nullable
        private String criticalFeedbackQuestionSubtitle;
        @Nullable
        private String thanksSubtitle;

        public Builder setUserOpinionQuestionTitle(@NonNull String userOpinionQuestionTitle) {
            this.userOpinionQuestionTitle = userOpinionQuestionTitle;
            return this;
        }

        public Builder setUserOpinionQuestionPositiveButtonLabel(@NonNull String userOpinionQuestionPositiveButtonLabel) {
            this.userOpinionQuestionPositiveButtonLabel = userOpinionQuestionPositiveButtonLabel;
            return this;
        }

        public Builder setUserOpinionQuestionNegativeButtonLabel(@NonNull String userOpinionQuestionNegativeButtonLabel) {
            this.userOpinionQuestionNegativeButtonLabel = userOpinionQuestionNegativeButtonLabel;
            return this;
        }

        public Builder setPositiveFeedbackQuestionTitle(@NonNull String positiveFeedbackQuestionTitle) {
            this.positiveFeedbackQuestionTitle = positiveFeedbackQuestionTitle;
            return this;
        }

        public Builder setPositiveFeedbackQuestionPositiveButtonLabel(@NonNull String positiveFeedbackQuestionPositiveButtonLabel) {
            this.positiveFeedbackQuestionPositiveButtonLabel = positiveFeedbackQuestionPositiveButtonLabel;
            return this;
        }

        public Builder setPositiveFeedbackQuestionNegativeButtonLabel(@NonNull String positiveFeedbackQuestionNegativeButtonLabel) {
            this.positiveFeedbackQuestionNegativeButtonLabel = positiveFeedbackQuestionNegativeButtonLabel;
            return this;
        }

        public Builder setCriticalFeedbackQuestionTitle(@NonNull String criticalFeedbackQuestionTitle) {
            this.criticalFeedbackQuestionTitle = criticalFeedbackQuestionTitle;
            return this;
        }

        public Builder setCriticalFeedbackQuestionPositiveButtonLabel(@NonNull String criticalFeedbackQuestionPositiveButtonLabel) {
            this.criticalFeedbackQuestionPositiveButtonLabel = criticalFeedbackQuestionPositiveButtonLabel;
            return this;
        }

        public Builder setCriticalFeedbackQuestionNegativeButtonLabel(@NonNull String criticalFeedbackQuestionNegativeButtonLabel) {
            this.criticalFeedbackQuestionNegativeButtonLabel = criticalFeedbackQuestionNegativeButtonLabel;
            return this;
        }

        public Builder setThanksTitle(@NonNull String thanksTitle) {
            this.thanksTitle = thanksTitle;
            return this;
        }

        public Builder setUserOpinionQuestionSubtitle(@NonNull String userOpinionQuestionSubtitle) {
            this.userOpinionQuestionSubtitle = userOpinionQuestionSubtitle;
            return this;
        }

        public Builder setPositiveFeedbackQuestionSubtitle(@NonNull String positiveFeedbackQuestionSubtitle) {
            this.positiveFeedbackQuestionSubtitle = positiveFeedbackQuestionSubtitle;
            return this;
        }

        public Builder setCriticalFeedbackQuestionSubtitle(@NonNull String criticalFeedbackQuestionSubtitle) {
            this.criticalFeedbackQuestionSubtitle = criticalFeedbackQuestionSubtitle;
            return this;
        }

        public Builder setThanksSubtitle(@NonNull String thanksSubtitle) {
            this.thanksSubtitle = thanksSubtitle;
            return this;
        }

        public BasePromptViewConfig build() {
            return new BasePromptViewConfig(this.userOpinionQuestionTitle, this.userOpinionQuestionPositiveButtonLabel, this.userOpinionQuestionNegativeButtonLabel, this.positiveFeedbackQuestionTitle, this.positiveFeedbackQuestionPositiveButtonLabel, this.positiveFeedbackQuestionNegativeButtonLabel, this.criticalFeedbackQuestionTitle, this.criticalFeedbackQuestionPositiveButtonLabel, this.criticalFeedbackQuestionNegativeButtonLabel, this.thanksTitle, this.userOpinionQuestionSubtitle, this.positiveFeedbackQuestionSubtitle, this.criticalFeedbackQuestionSubtitle, this.thanksSubtitle);
        }
    }
}

