/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.utils;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.tracking.interfaces.IApplicationFeedbackDataProvider;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentCapabilitiesProvider;
import com.github.stkent.amplify.utils.ActivityStateUtil;
import com.github.stkent.amplify.utils.time.SystemTimeUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class FeedbackUtil {
    private final IApplicationFeedbackDataProvider applicationFeedbackDataProvider;
    private final IEnvironmentCapabilitiesProvider environmentCapabilitiesProvider;
    private final ILogger logger;
    private final String feedbackEmail;

    public FeedbackUtil(@NonNull IApplicationFeedbackDataProvider applicationFeedbackDataProvider, @NonNull IEnvironmentCapabilitiesProvider environmentCapabilitiesProvider, @NonNull String feedbackEmail, @NonNull ILogger logger) {
        this.applicationFeedbackDataProvider = applicationFeedbackDataProvider;
        this.environmentCapabilitiesProvider = environmentCapabilitiesProvider;
        this.feedbackEmail = feedbackEmail;
        this.logger = logger;
    }

    public void showFeedbackEmailChooser(@Nullable Activity activity) {
        Intent feedbackEmailIntent = this.getFeedbackEmailIntent();
        if (!this.environmentCapabilitiesProvider.canHandleIntent(feedbackEmailIntent)) {
            this.logger.e("Unable to present email client chooser.");
            return;
        }
        if (ActivityStateUtil.isActivityValid(activity)) {
            activity.startActivity(Intent.createChooser((Intent)this.getFeedbackEmailIntent(), (CharSequence)"Choose an email provider:"));
            activity.overridePendingTransition(0, 0);
        }
    }

    @NonNull
    private Intent getFeedbackEmailIntent() {
        String appName;
        try {
            appName = this.applicationFeedbackDataProvider.getApplicationNameString() + " ";
        }
        catch (PackageManager.NameNotFoundException e) {
            appName = "";
        }
        String feedbackEmailSubject = appName + "Android App Feedback" + " " + this.getDateString();
        String encodedFeedbackEmailSubject = Uri.encode((String)feedbackEmailSubject, (String)"UTF-8");
        String appInfo = this.getApplicationInfoString();
        StringBuilder uriStringBuilder = new StringBuilder("mailto:");
        try {
            uriStringBuilder.append(this.feedbackEmail);
        }
        catch (IllegalStateException e) {
            this.logger.e("Feedback email address was not defined");
        }
        uriStringBuilder.append("?subject=").append(encodedFeedbackEmailSubject).append("&body=").append(Uri.encode((String)appInfo));
        Uri uri = Uri.parse((String)uriStringBuilder.toString());
        return new Intent("android.intent.action.SENDTO", uri);
    }

    @NonNull
    private String getApplicationInfoString() {
        String applicationVersionDisplayString;
        try {
            applicationVersionDisplayString = this.applicationFeedbackDataProvider.getVersionDisplayString();
        }
        catch (PackageManager.NameNotFoundException e) {
            this.logger.e("Unable to determine application version information.");
            applicationVersionDisplayString = "Unknown";
        }
        return "\n\n\n---------------------\nDevice: " + this.applicationFeedbackDataProvider.getDeviceName() + "\n" + "App Version: " + applicationVersionDisplayString + "\n" + "Android OS Version: " + this.getAndroidOsVersionDisplayString() + "\n" + "Date: " + this.getDateString();
    }

    private String getDateString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy kk:mm:ss", Locale.getDefault());
        Date date = new Date(SystemTimeUtil.currentTimeMillis());
        return simpleDateFormat.format(date);
    }

    private String getAndroidOsVersionDisplayString() {
        return Build.VERSION.RELEASE + " - " + Build.VERSION.SDK_INT;
    }
}

