/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.content.Context;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.Logger;
import com.github.stkent.amplify.tracking.EnvironmentInfoProvider;
import com.github.stkent.amplify.tracking.IntegratedEvent;
import com.github.stkent.amplify.tracking.checks.CooldownDaysCheck;
import com.github.stkent.amplify.tracking.checks.GooglePlayStoreIsAvailableCheck;
import com.github.stkent.amplify.tracking.checks.MaximumCountCheck;
import com.github.stkent.amplify.tracking.checks.VersionChangedCheck;
import com.github.stkent.amplify.tracking.checks.WarmUpDaysCheck;
import com.github.stkent.amplify.tracking.initializers.ExceptionHandlingInitializer;
import com.github.stkent.amplify.tracking.initializers.ImmediateEventTriggerInitializer;
import com.github.stkent.amplify.tracking.interfaces.IAmplifyStateTracker;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentCheck;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentInfoProvider;
import com.github.stkent.amplify.tracking.interfaces.IEvent;
import com.github.stkent.amplify.tracking.interfaces.IEventCheck;
import com.github.stkent.amplify.tracking.interfaces.ITrackingInitializer;
import com.github.stkent.amplify.tracking.trackers.FirstTimeTracker;
import com.github.stkent.amplify.tracking.trackers.LastTimeTracker;
import com.github.stkent.amplify.tracking.trackers.LastVersionTracker;
import com.github.stkent.amplify.tracking.trackers.TotalCountTracker;
import com.github.stkent.amplify.views.AmplifyView;
import java.util.ArrayList;
import java.util.List;

public final class AmplifyStateTracker
implements IAmplifyStateTracker {
    private static IAmplifyStateTracker sharedInstance;
    private static final int ONE_WEEK = 7;
    private static final int ONE_DAY = 1;
    private final IEnvironmentInfoProvider environmentInfoProvider;
    private final List<IEnvironmentCheck> environmentChecks = new ArrayList<IEnvironmentCheck>();
    private final LastTimeTracker lastTimeTracker;
    private final FirstTimeTracker firstTimeTracker;
    private final LastVersionTracker lastVersionTracker;
    private final TotalCountTracker totalCountTracker;
    private final ILogger logger;
    private boolean alwaysShow;

    public static IAmplifyStateTracker get(@NonNull Context context) {
        return AmplifyStateTracker.get(context, new Logger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IAmplifyStateTracker get(@NonNull Context context, @NonNull ILogger logger) {
        Class<AmplifyStateTracker> clazz = AmplifyStateTracker.class;
        synchronized (AmplifyStateTracker.class) {
            if (sharedInstance == null) {
                sharedInstance = new AmplifyStateTracker(context, logger);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sharedInstance;
        }
    }

    private AmplifyStateTracker(@NonNull Context context, @NonNull ILogger logger) {
        Context applicationContext = context.getApplicationContext();
        this.environmentInfoProvider = new EnvironmentInfoProvider(applicationContext);
        this.logger = logger;
        this.lastTimeTracker = new LastTimeTracker(logger, applicationContext);
        this.firstTimeTracker = new FirstTimeTracker(logger, applicationContext);
        this.lastVersionTracker = new LastVersionTracker(logger, applicationContext);
        this.totalCountTracker = new TotalCountTracker(logger, applicationContext);
    }

    @Override
    public IAmplifyStateTracker configureWithDefaults() {
        return this.addEnvironmentCheck(new GooglePlayStoreIsAvailableCheck()).trackFirstEventTime(IntegratedEvent.APP_INSTALLED, new WarmUpDaysCheck(7L), new ImmediateEventTriggerInitializer()).trackTotalEventCount(IntegratedEvent.USER_GAVE_POSITIVE_FEEDBACK, new MaximumCountCheck(1)).trackLastEventTime(IntegratedEvent.USER_GAVE_CRITICAL_FEEDBACK, new CooldownDaysCheck(7L)).trackLastEventTime(IntegratedEvent.USER_DECLINED_CRITICAL_FEEDBACK, new CooldownDaysCheck(7L)).trackLastEventVersion(IntegratedEvent.USER_DECLINED_CRITICAL_FEEDBACK, new VersionChangedCheck()).trackLastEventTime(IntegratedEvent.USER_DECLINED_POSITIVE_FEEDBACK, new CooldownDaysCheck(7L)).trackLastEventVersion(IntegratedEvent.USER_DECLINED_POSITIVE_FEEDBACK, new VersionChangedCheck()).trackLastEventTime(IntegratedEvent.APP_CRASHED, new CooldownDaysCheck(7L), new ExceptionHandlingInitializer()).trackLastEventVersion(IntegratedEvent.USER_GAVE_CRITICAL_FEEDBACK, new VersionChangedCheck());
    }

    @Override
    public IAmplifyStateTracker setLogLevel(@NonNull Logger.LogLevel logLevel) {
        this.logger.setLogLevel(logLevel);
        return this;
    }

    @Override
    public IAmplifyStateTracker setAlwaysShow(boolean alwaysShow) {
        this.alwaysShow = alwaysShow;
        return this;
    }

    @Override
    public IAmplifyStateTracker trackTotalEventCount(@NonNull IEvent event, @NonNull IEventCheck<Integer> eventCheck) {
        this.totalCountTracker.trackEvent(event, eventCheck);
        return this;
    }

    @Override
    public IAmplifyStateTracker trackTotalEventCount(@NonNull IEvent event, @NonNull IEventCheck<Integer> eventCheck, @NonNull ITrackingInitializer trackingInitializer) {
        this.trackTotalEventCount(event, eventCheck);
        if (!this.totalCountTracker.containsEvent(event)) {
            trackingInitializer.initialize(this, event);
        }
        return this;
    }

    @Override
    public IAmplifyStateTracker trackFirstEventTime(@NonNull IEvent event, @NonNull IEventCheck<Long> eventCheck) {
        this.firstTimeTracker.trackEvent(event, eventCheck);
        return this;
    }

    @Override
    public IAmplifyStateTracker trackFirstEventTime(@NonNull IEvent event, @NonNull IEventCheck<Long> eventCheck, @NonNull ITrackingInitializer trackingInitializer) {
        this.trackFirstEventTime(event, eventCheck);
        if (!this.firstTimeTracker.containsEvent(event)) {
            trackingInitializer.initialize(this, event);
        }
        return this;
    }

    @Override
    public IAmplifyStateTracker trackLastEventTime(@NonNull IEvent event, @NonNull IEventCheck<Long> eventCheck) {
        this.lastTimeTracker.trackEvent(event, eventCheck);
        return this;
    }

    @Override
    public IAmplifyStateTracker trackLastEventTime(@NonNull IEvent event, @NonNull IEventCheck<Long> eventCheck, @NonNull ITrackingInitializer trackingInitializer) {
        this.trackLastEventTime(event, eventCheck);
        if (!this.lastTimeTracker.containsEvent(event)) {
            trackingInitializer.initialize(this, event);
        }
        return this;
    }

    @Override
    public IAmplifyStateTracker trackLastEventVersion(@NonNull IEvent event, @NonNull IEventCheck<String> eventCheck) {
        this.lastVersionTracker.trackEvent(event, eventCheck);
        return this;
    }

    @Override
    public IAmplifyStateTracker trackLastEventVersion(@NonNull IEvent event, @NonNull IEventCheck<String> eventCheck, @NonNull ITrackingInitializer trackingInitializer) {
        this.trackLastEventVersion(event, eventCheck);
        if (!this.lastVersionTracker.containsEvent(event)) {
            trackingInitializer.initialize(this, event);
        }
        return this;
    }

    @Override
    public IAmplifyStateTracker addEnvironmentCheck(@NonNull IEnvironmentCheck environmentCheck) {
        this.environmentChecks.add(environmentCheck);
        return this;
    }

    @Override
    public IAmplifyStateTracker notifyEventTriggered(@NonNull IEvent event) {
        this.logger.d("Triggered Event: " + event);
        this.totalCountTracker.notifyEventTriggered(event);
        this.firstTimeTracker.notifyEventTriggered(event);
        this.lastTimeTracker.notifyEventTriggered(event);
        this.lastVersionTracker.notifyEventTriggered(event);
        return this;
    }

    @Override
    public void promptIfReady(@NonNull AmplifyView amplifyView) {
        if (this.shouldAskForRating()) {
            amplifyView.injectDependencies(this, this.logger);
            amplifyView.show();
        }
    }

    @Override
    public boolean shouldAskForRating() {
        return this.alwaysShow | this.allEnvironmentChecksMet() & this.totalCountTracker.allowFeedbackPrompt() & this.firstTimeTracker.allowFeedbackPrompt() & this.lastTimeTracker.allowFeedbackPrompt() & this.lastVersionTracker.allowFeedbackPrompt();
    }

    private boolean allEnvironmentChecksMet() {
        for (IEnvironmentCheck environmentCheck : this.environmentChecks) {
            if (environmentCheck.isSatisfied(this.environmentInfoProvider)) continue;
            this.logger.d("Environment check not satisfied: " + environmentCheck);
            return false;
        }
        return true;
    }
}

