/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class FeedbackUtils {
    private static final int BASE_MESSAGE_LENGTH = 78;

    private FeedbackUtils() {
    }

    public static void showFeedbackEmailChooser(Activity activity) {
        activity.startActivity(Intent.createChooser((Intent)FeedbackUtils.getFeedbackEmailIntent(), (CharSequence)"Choose an email provider:"));
        activity.overridePendingTransition(0, 0);
    }

    public static boolean canHandleFeedbackEmailIntent(Context context) {
        List resolveInfoList = context.getPackageManager().queryIntentActivities(FeedbackUtils.getFeedbackEmailIntent(), 65536);
        return !resolveInfoList.isEmpty();
    }

    public static String getAppInfo() {
        return new StringBuilder(78).append("\n\n\n---------------------\nApp Version: ").append("0.1.0").append(" - ").append(1).append("\n").append("Android OS Version: ").append(Build.VERSION.RELEASE).append(" - ").append(Build.VERSION.SDK_INT).append("\n").append("Date: ").append(System.currentTimeMillis()).toString();
    }

    public static void getBitmapFromRootView(Activity activity, OnBitmapCapturedListener bitmapCapturedListener) {
        View view = activity.getWindow().getDecorView().getRootView();
        bitmapCapturedListener.onCapture(FeedbackUtils.getScreenBitmap(view), null);
    }

    public static List<Uri> getAttachmentList(Uri ... uris) {
        ArrayList<Uri> list = new ArrayList<Uri>(uris.length);
        list.addAll(Arrays.asList(uris));
        return list;
    }

    private static Intent getFeedbackEmailIntent() {
        Intent emailIntent = new Intent("android.intent.action.SENDTO");
        String feedbackMailTo = "mailto:" + emailIntent.toString();
        String feedbackEmailSubject = Uri.encode((String)"Android App Feedback", (String)"UTF-8");
        String appInfo = FeedbackUtils.getAppInfo();
        String uriString = feedbackMailTo + "?subject=" + feedbackEmailSubject + "&body=" + Uri.encode((String)appInfo);
        Uri uri = Uri.parse((String)uriString);
        emailIntent.setData(uri);
        return emailIntent;
    }

    private static Bitmap getScreenBitmap(View view) {
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        view.draw(canvas);
        return bitmap;
    }

    public static interface OnBitmapCapturedListener {
        public void onCapture(Bitmap var1, Bitmap var2);
    }
}

