/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.github.stkent.amplify.Question;
import com.github.stkent.amplify.QuestionView;
import com.github.stkent.amplify.R;

public class DefaultQuestionView
implements QuestionView {
    @NonNull
    private final View view;
    @NonNull
    private final TextView titleTextView;
    @NonNull
    private final Button positiveButton;
    @NonNull
    private final Button negativeButton;

    public DefaultQuestionView(@NonNull View view) {
        this.view = view;
        this.titleTextView = (TextView)view.findViewById(R.id.amp_title_text_view);
        if (this.titleTextView == null) {
            throw new IllegalArgumentException("Some string here");
        }
        this.positiveButton = (Button)view.findViewById(R.id.amp_positive_button);
        if (this.positiveButton == null) {
            throw new IllegalArgumentException("Some other string here");
        }
        this.negativeButton = (Button)view.findViewById(R.id.amp_negative_button);
        if (this.negativeButton == null) {
            throw new IllegalArgumentException("Some other other string here");
        }
    }

    @Override
    @NonNull
    public View getView() {
        return this.view;
    }

    @Override
    @NonNull
    public Button getPositiveButton() {
        return this.positiveButton;
    }

    @Override
    @NonNull
    public Button getNegativeButton() {
        return this.negativeButton;
    }

    @Override
    public void setQuestion(@NonNull Question question) {
        this.titleTextView.setText((CharSequence)question.getTitle());
        this.positiveButton.setText((CharSequence)question.getPositiveButtonText());
        this.negativeButton.setText((CharSequence)question.getNegativeButtonText());
    }
}

