/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore.utils;

import com.stonecraft.datastore.exceptions.CannotCompleteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static String FORMAT_DATE_ISO = "yyyy-MM-dd HH:mm:ss";
    public static String FORMAT_FILE_FRIENDLY_DATE_ISO = "yyyy-MM-dd HHmmss";
    public static String FORMAT_CACHE_BUSTER = "yyyyMMddHHmmss";
    public static String FORMAT_DAY_NTH = "dddd";
    public static String DAY_SUFFIX_ST = "st";
    public static String DAY_SUFFIX_RD = "rd";
    public static String DAY_SUFFIX_TH = "th";
    public static String DAY_SUFFIX_ND = "nd";

    public static Date getDateFromString(String dateString, String format) throws CannotCompleteException {
        try {
            SimpleDateFormat f = new SimpleDateFormat(format);
            return f.parse(dateString);
        }
        catch (ParseException e) {
            throw new CannotCompleteException("The date " + dateString + " with format " + format + " could not be made into a date object [" + e + "]");
        }
    }

    public static Date fromISODateString(String isoDateString) throws CannotCompleteException {
        return DateUtils.getDateFromString(isoDateString, FORMAT_DATE_ISO);
    }

    public static String toIsoString(Date date) {
        return DateUtils.formatDate(date, FORMAT_DATE_ISO);
    }

    public static String getIsoStringForNow() {
        Date date = new Date();
        return DateUtils.toIsoString(date);
    }

    @Deprecated
    public static String formatDate(Date date, String format) {
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(date);
    }

    public static String formatDate(Calendar cal, String format) {
        Date date = new Date(cal.getTimeInMillis());
        if (format.contains(FORMAT_DAY_NTH)) {
            String startStringFormat = format.substring(0, format.indexOf(FORMAT_DAY_NTH));
            String endStringFormat = format.substring(startStringFormat.length() + FORMAT_DAY_NTH.length(), format.length());
            String dayString = cal.get(5) + DateUtils.getDayOfMonthSuffix(cal.get(5));
            String startFormat = DateUtils.formatDate(date, startStringFormat);
            String endFormat = DateUtils.formatDate(date, endStringFormat);
            return startFormat + dayString + endFormat;
        }
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(date);
    }

    public static String getDayOfMonthSuffix(int n) {
        if (n >= 11 && n <= 13) {
            return DAY_SUFFIX_TH;
        }
        switch (n % 10) {
            case 1: {
                return DAY_SUFFIX_ST;
            }
            case 2: {
                return DAY_SUFFIX_ND;
            }
            case 3: {
                return DAY_SUFFIX_RD;
            }
        }
        return DAY_SUFFIX_TH;
    }
}

