/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import com.stonecraft.datastore.DbSchemaModel;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interfaces.IDBConnector;
import com.stonecraft.datastore.interfaces.ISchemaCreator;
import com.stonecraft.datastore.interfaces.ISyntaxer;

public abstract class DatabaseConnection
implements IDBConnector {
    protected ISyntaxer mySyntaxer;
    private String myName;
    private int myCurrentVersion;

    public DatabaseConnection(String name, int version, ISyntaxer syntaxer) {
        this.myName = name;
        this.myCurrentVersion = version;
        this.mySyntaxer = syntaxer;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public int getVersion() {
        return this.myCurrentVersion;
    }

    @Override
    public void createSchema(ISchemaCreator database) throws DatabaseException {
        DbSchemaModel schema = database.getSchema();
        this.startTransaction();
        for (String createStmt : schema.getTableCreateStmts()) {
            this.executeRawStatement(createStmt);
        }
        this.commit();
    }
}

