/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import com.stonecraft.datastore.DatabaseTask;
import com.stonecraft.datastore.Datastore;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interfaces.OnNonQueryComplete;
import com.stonecraft.datastore.view.DatabaseTable;
import java.util.ArrayList;
import java.util.List;

public class CreateTableTask
extends DatabaseTask {
    private static final int TABLE_CREATED = 1;
    private static final int TABLE_NOT_CREATED = 0;
    private DatabaseTable myTable;
    private List<OnNonQueryComplete> myStmtListeners;
    private int myResult;

    public CreateTableTask(int taskId, int token, Datastore datastore, DatabaseTable table) {
        super(taskId, token, datastore);
        this.myTable = table;
        this.myStmtListeners = new ArrayList<OnNonQueryComplete>();
        this.myResult = 0;
    }

    @Override
    public void startTask() throws DatabaseException {
        try {
            String createStatement = this.myTable.getCreateTableStmt();
            this.myDatastore.getActiveDatabase().executeRawStatement(createStatement);
            this.myResult = 1;
            this.notifyStmtListeners(null);
        }
        catch (DatabaseException e) {
            this.myResult = 0;
            this.notifyStmtListeners(e);
            throw e;
        }
        finally {
            this.notifyTaskListeners();
        }
    }

    public void addOnStmtCompleteListener(OnNonQueryComplete listener) {
        if (listener != null) {
            this.myStmtListeners.add(listener);
        }
    }

    public int getTaskResult() {
        return this.myResult;
    }

    @Override
    void notifyStmtListeners(DatabaseException e) {
        for (OnNonQueryComplete listener : this.myStmtListeners) {
            if (e != null) {
                listener.onNonQueryFailed(this.myToken, e);
                continue;
            }
            listener.onNonQueryComplete(this.myToken, this.myResult);
        }
    }
}

