/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.stonecraft.datastore.DbColumnName;
import com.stonecraft.datastore.RSData;
import com.stonecraft.datastore.exceptions.DatabaseException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;

public class DatabaseObjectInjector {
    public <T> T[] inject(RSData data, Class<T> classOfT) throws DatabaseException {
        Object[] returnClasses = (Object[])Array.newInstance(classOfT, data.getCount());
        data.moveToFirst();
        int count = 0;
        while (!data.isAfterLast()) {
            T injectedRow = this.getInjectedClass(data, classOfT);
            if (injectedRow != null) {
                returnClasses[count] = injectedRow;
            }
            data.next();
            ++count;
        }
        return returnClasses;
    }

    private <T> T getInjectedClass(RSData data, Class<T> classOfT) throws DatabaseException {
        try {
            Field[] fields = classOfT.getDeclaredFields();
            T rowClass = classOfT.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : fields) {
                DbColumnName annotation = field.getAnnotation(DbColumnName.class);
                if (!(annotation instanceof DbColumnName)) continue;
                field.setAccessible(true);
                DbColumnName InjectAnnotation = annotation;
                String column = InjectAnnotation.value();
                Class<?> fieldType = field.getType();
                if (!data.hasColumn(column)) continue;
                if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                    field.set(rowClass, data.getIntValue(column));
                    continue;
                }
                if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                    field.set(rowClass, data.getBooleanValue(column));
                    continue;
                }
                if (fieldType == Double.TYPE || fieldType == Double.class) {
                    field.set(rowClass, data.getDoubleValue(column));
                    continue;
                }
                if (fieldType == Float.TYPE || fieldType == Float.class) {
                    field.set(rowClass, Float.valueOf(data.getFloatValue(column)));
                    continue;
                }
                if (fieldType == String.class) {
                    field.set(rowClass, data.getStringValue(column));
                    continue;
                }
                if (fieldType == Calendar.class) {
                    field.set(rowClass, data.getCalendarValue(column));
                    continue;
                }
                if (fieldType == Date.class) {
                    field.set(rowClass, data.getDateValue(column));
                    continue;
                }
                if (fieldType == Byte[].class) {
                    field.set(rowClass, data.getBlobData(column));
                    continue;
                }
                if (fieldType != Bitmap.class) continue;
                byte[] bmpData = data.getBlobData(column);
                Bitmap bmp = BitmapFactory.decodeByteArray((byte[])bmpData, (int)0, (int)bmpData.length);
                field.set(rowClass, bmp);
            }
            return rowClass;
        }
        catch (Throwable e) {
            throw new DatabaseException("Failed to create an instance of the class to be injected with the data for this query", e);
        }
    }
}

