/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore.utils;

import android.util.Patterns;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class StringUtils {
    public static final String EmptyString = "";
    public static final int NO_CHAR_FOUND = -1;
    public static final String URL_ENCODED_COMMA = "%2c";
    public static final String URL_ENCODED_GREATER_THAN = "%3e";
    public static final String URL_ENCODED_LESS_THAN = "%3c";
    public static final String COMMA = ",";
    public static final String MORE_THAN = ">";
    public static final String LESS_THAN = "<";
    public static final char ESCAPE_CHAR = '\\';
    public static final char CHAR_COMMA = ',';

    private StringUtils() {
    }

    public static boolean isEmpty(String val) {
        return val == null || val.equals(EmptyString);
    }

    public static String removeLastChar(String val) {
        if (StringUtils.isEmpty(val)) {
            return val;
        }
        return val.substring(0, val.length() - 1);
    }

    public static String removeStringSuffix(String val, String suffix) {
        if (val.length() < suffix.length()) {
            return val;
        }
        String lastChar = val.substring(val.length() - suffix.length(), val.length());
        if (lastChar.equals(suffix)) {
            return val.substring(0, val.length() - suffix.length());
        }
        return val;
    }

    public static String convertListToDelimitedString(List<String> list, String delim, String escapeChar) {
        StringBuilder builder = new StringBuilder();
        for (String item : list) {
            if (StringUtils.isEmpty(escapeChar)) {
                builder.append(item + delim);
                continue;
            }
            builder.append(escapeChar + item + escapeChar + delim);
        }
        return StringUtils.removeStringSuffix(builder.toString(), delim);
    }

    public static String convertListToDelimitedString(List<String> list, String delim) {
        return StringUtils.convertListToDelimitedString(list, delim, null);
    }

    public static List<String> convertDelimitedStringToList(String data, char delim, char escapeChar) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (data == null || StringUtils.isEmpty(data)) {
            return returnList;
        }
        int lastIndex = 0;
        while (true) {
            int index = data.indexOf(delim, lastIndex);
            int start = lastIndex;
            if (start >= data.length()) break;
            if (data.charAt(start) == escapeChar) {
                ++start;
            }
            int end = index;
            if (index == -1) {
                end = data.length();
            }
            if (data.charAt(end - 1) == escapeChar) {
                --end;
            }
            returnList.add(data.substring(start, end));
            if (index == -1) break;
            lastIndex = index + 1;
        }
        return returnList;
    }

    public static String getStringNotNull(String val) {
        if (val == null) {
            val = EmptyString;
        }
        return val;
    }

    public static String formatIntToCurrency(float value) {
        DecimalFormat format = new DecimalFormat("#,##0");
        return "$" + format.format(value);
    }

    public static boolean isValidEmail(String address) {
        if (StringUtils.isEmpty(address)) {
            return false;
        }
        return Patterns.EMAIL_ADDRESS.matcher(address).matches();
    }
}

