/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interfaces.IDBConnector;
import com.stonecraft.datastore.interfaces.OnTaskCompleteListener;
import com.stonecraft.datastore.interfaces.Tasker;
import java.util.ArrayList;
import java.util.List;

abstract class DatabaseTask
implements Tasker {
    protected int myToken;
    protected IDBConnector myConnection;
    private int myTaskId;
    private List<OnTaskCompleteListener> myTaskListeners;
    private Runnable myRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                DatabaseTask.this.executeTask();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
    };

    public DatabaseTask(int taskId, int token, IDBConnector conn) {
        this.myTaskId = taskId;
        this.myToken = token;
        this.myConnection = conn;
        this.myTaskListeners = new ArrayList<OnTaskCompleteListener>();
    }

    public int getTaskId() {
        return this.myTaskId;
    }

    @Override
    public int getToken() {
        return this.myToken;
    }

    @Override
    public void addOnTaskCompleteListener(OnTaskCompleteListener listener) {
        if (listener != null) {
            this.myTaskListeners.add(listener);
        }
    }

    @Override
    public void removeOnTaskCompleteListener(OnTaskCompleteListener listener) {
        this.myTaskListeners.remove(listener);
    }

    public void Start() throws DatabaseException {
        new Thread(this.myRunnable).start();
    }

    @Override
    public void notifyTaskListeners() {
        for (OnTaskCompleteListener listener : this.myTaskListeners) {
            listener.onTaskComplete(this);
        }
    }

    public abstract void executeTask() throws DatabaseException;
}

