/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.frescoimageviewer;

import android.content.Context;
import android.view.MotionEvent;
import android.view.ViewConfiguration;

abstract class SwipeDirectionDetector {
    private int touchSlop;
    private float startX;
    private float startY;
    private boolean isDetected;

    public abstract void onDirectionDetected(Direction var1);

    public SwipeDirectionDetector(Context context) {
        this.touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.startX = event.getX();
                this.startY = event.getY();
                break;
            }
            case 1: 
            case 3: {
                if (!this.isDetected) {
                    this.onDirectionDetected(Direction.NOT_DETECTED);
                }
                this.startY = 0.0f;
                this.startX = 0.0f;
                this.isDetected = false;
                break;
            }
            case 2: {
                if (this.isDetected || !(this.getDistance(event) > (float)this.touchSlop)) break;
                this.isDetected = true;
                float x = event.getX();
                float y = event.getY();
                Direction direction = this.getDirection(this.startX, this.startY, x, y);
                this.onDirectionDetected(direction);
            }
        }
        return false;
    }

    public Direction getDirection(float x1, float y1, float x2, float y2) {
        double angle = this.getAngle(x1, y1, x2, y2);
        return Direction.get(angle);
    }

    public double getAngle(float x1, float y1, float x2, float y2) {
        double rad = Math.atan2(y1 - y2, x2 - x1) + Math.PI;
        return (rad * 180.0 / Math.PI + 180.0) % 360.0;
    }

    private float getDistance(MotionEvent ev) {
        float distanceSum = 0.0f;
        float dx = ev.getX(0) - this.startX;
        float dy = ev.getY(0) - this.startY;
        distanceSum = (float)((double)distanceSum + Math.sqrt(dx * dx + dy * dy));
        return distanceSum;
    }

    public static enum Direction {
        NOT_DETECTED,
        UP,
        DOWN,
        LEFT,
        RIGHT;


        public static Direction get(double angle) {
            if (Direction.inRange(angle, 45.0f, 135.0f)) {
                return UP;
            }
            if (Direction.inRange(angle, 0.0f, 45.0f) || Direction.inRange(angle, 315.0f, 360.0f)) {
                return RIGHT;
            }
            if (Direction.inRange(angle, 225.0f, 315.0f)) {
                return DOWN;
            }
            return LEFT;
        }

        private static boolean inRange(double angle, float init, float end) {
            return angle >= (double)init && angle < (double)end;
        }
    }
}

