/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.chatkit.messages;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.stfalcon.chatkit.R;
import com.stfalcon.chatkit.commons.ImageLoader;
import com.stfalcon.chatkit.commons.ViewHolder;
import com.stfalcon.chatkit.commons.models.IMessage;
import com.stfalcon.chatkit.commons.models.MessageContentType;
import com.stfalcon.chatkit.messages.MessagesListAdapter;
import com.stfalcon.chatkit.messages.MessagesListStyle;
import com.stfalcon.chatkit.utils.DateFormatter;
import com.stfalcon.chatkit.utils.RoundedImageView;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MessageHolders {
    private static final short VIEW_TYPE_DATE_HEADER = 130;
    private static final short VIEW_TYPE_TEXT_MESSAGE = 131;
    private static final short VIEW_TYPE_IMAGE_MESSAGE = 132;
    private Class<? extends ViewHolder<Date>> dateHeaderHolder = DefaultDateHeaderViewHolder.class;
    private int dateHeaderLayout;
    private HolderConfig<IMessage> incomingTextConfig;
    private HolderConfig<IMessage> outcomingTextConfig;
    private HolderConfig<MessageContentType.Image> incomingImageConfig;
    private HolderConfig<MessageContentType.Image> outcomingImageConfig;
    private List<ContentTypeConfig> customContentTypes = new ArrayList<ContentTypeConfig>();
    private ContentChecker contentChecker;

    public MessageHolders() {
        this.dateHeaderLayout = R.layout.item_date_header;
        this.incomingTextConfig = new HolderConfig(DefaultIncomingTextMessageViewHolder.class, R.layout.item_incoming_text_message);
        this.outcomingTextConfig = new HolderConfig(DefaultOutcomingTextMessageViewHolder.class, R.layout.item_outcoming_text_message);
        this.incomingImageConfig = new HolderConfig(DefaultIncomingImageMessageViewHolder.class, R.layout.item_incoming_image_message);
        this.outcomingImageConfig = new HolderConfig(DefaultOutcomingImageMessageViewHolder.class, R.layout.item_outcoming_image_message);
    }

    public MessageHolders setIncomingTextConfig(@NonNull Class<? extends BaseMessageViewHolder<? extends IMessage>> holder, @LayoutRes int layout2) {
        this.incomingTextConfig.holder = holder;
        this.incomingTextConfig.layout = layout2;
        return this;
    }

    public MessageHolders setIncomingTextConfig(@NonNull Class<? extends BaseMessageViewHolder<? extends IMessage>> holder, @LayoutRes int layout2, Object payload) {
        this.incomingTextConfig.holder = holder;
        this.incomingTextConfig.layout = layout2;
        this.incomingTextConfig.payload = payload;
        return this;
    }

    public MessageHolders setIncomingTextHolder(@NonNull Class<? extends BaseMessageViewHolder<? extends IMessage>> holder) {
        this.incomingTextConfig.holder = holder;
        return this;
    }

    public MessageHolders setIncomingTextHolder(@NonNull Class<? extends BaseMessageViewHolder<? extends IMessage>> holder, Object payload) {
        this.incomingTextConfig.holder = holder;
        this.incomingTextConfig.payload = payload;
        return this;
    }

    public MessageHolders setIncomingTextLayout(@LayoutRes int layout2) {
        this.incomingTextConfig.layout = layout2;
        return this;
    }

    public MessageHolders setIncomingTextLayout(@LayoutRes int layout2, Object payload) {
        this.incomingTextConfig.layout = layout2;
        this.incomingTextConfig.payload = payload;
        return this;
    }

    public MessageHolders setOutcomingTextConfig(@NonNull Class<? extends BaseMessageViewHolder<? extends IMessage>> holder, @LayoutRes int layout2) {
        this.outcomingTextConfig.holder = holder;
        this.outcomingTextConfig.layout = layout2;
        return this;
    }

    public MessageHolders setOutcomingTextConfig(@NonNull Class<? extends BaseMessageViewHolder<? extends IMessage>> holder, @LayoutRes int layout2, Object payload) {
        this.outcomingTextConfig.holder = holder;
        this.outcomingTextConfig.layout = layout2;
        this.outcomingTextConfig.payload = payload;
        return this;
    }

    public MessageHolders setOutcomingTextHolder(@NonNull Class<? extends BaseMessageViewHolder<? extends IMessage>> holder) {
        this.outcomingTextConfig.holder = holder;
        return this;
    }

    public MessageHolders setOutcomingTextHolder(@NonNull Class<? extends BaseMessageViewHolder<? extends IMessage>> holder, Object payload) {
        this.outcomingTextConfig.holder = holder;
        this.outcomingTextConfig.payload = payload;
        return this;
    }

    public MessageHolders setOutcomingTextLayout(@LayoutRes int layout2) {
        this.outcomingTextConfig.layout = layout2;
        return this;
    }

    public MessageHolders setOutcomingTextLayout(@LayoutRes int layout2, Object payload) {
        this.outcomingTextConfig.layout = layout2;
        this.outcomingTextConfig.payload = payload;
        return this;
    }

    public MessageHolders setIncomingImageConfig(@NonNull Class<? extends BaseMessageViewHolder<? extends MessageContentType.Image>> holder, @LayoutRes int layout2) {
        this.incomingImageConfig.holder = holder;
        this.incomingImageConfig.layout = layout2;
        return this;
    }

    public MessageHolders setIncomingImageConfig(@NonNull Class<? extends BaseMessageViewHolder<? extends MessageContentType.Image>> holder, @LayoutRes int layout2, Object payload) {
        this.incomingImageConfig.holder = holder;
        this.incomingImageConfig.layout = layout2;
        this.incomingImageConfig.payload = payload;
        return this;
    }

    public MessageHolders setIncomingImageHolder(@NonNull Class<? extends BaseMessageViewHolder<? extends MessageContentType.Image>> holder) {
        this.incomingImageConfig.holder = holder;
        return this;
    }

    public MessageHolders setIncomingImageHolder(@NonNull Class<? extends BaseMessageViewHolder<? extends MessageContentType.Image>> holder, Object payload) {
        this.incomingImageConfig.holder = holder;
        this.incomingImageConfig.payload = payload;
        return this;
    }

    public MessageHolders setIncomingImageLayout(@LayoutRes int layout2) {
        this.incomingImageConfig.layout = layout2;
        return this;
    }

    public MessageHolders setIncomingImageLayout(@LayoutRes int layout2, Object payload) {
        this.incomingImageConfig.layout = layout2;
        this.incomingImageConfig.payload = payload;
        return this;
    }

    public MessageHolders setOutcomingImageConfig(@NonNull Class<? extends BaseMessageViewHolder<? extends MessageContentType.Image>> holder, @LayoutRes int layout2) {
        this.outcomingImageConfig.holder = holder;
        this.outcomingImageConfig.layout = layout2;
        return this;
    }

    public MessageHolders setOutcomingImageConfig(@NonNull Class<? extends BaseMessageViewHolder<? extends MessageContentType.Image>> holder, @LayoutRes int layout2, Object payload) {
        this.outcomingImageConfig.holder = holder;
        this.outcomingImageConfig.layout = layout2;
        this.outcomingImageConfig.payload = payload;
        return this;
    }

    public MessageHolders setOutcomingImageHolder(@NonNull Class<? extends BaseMessageViewHolder<? extends MessageContentType.Image>> holder) {
        this.outcomingImageConfig.holder = holder;
        return this;
    }

    public MessageHolders setOutcomingImageHolder(@NonNull Class<? extends BaseMessageViewHolder<? extends MessageContentType.Image>> holder, Object payload) {
        this.outcomingImageConfig.holder = holder;
        this.outcomingImageConfig.payload = payload;
        return this;
    }

    public MessageHolders setOutcomingImageLayout(@LayoutRes int layout2) {
        this.outcomingImageConfig.layout = layout2;
        return this;
    }

    public MessageHolders setOutcomingImageLayout(@LayoutRes int layout2, Object payload) {
        this.outcomingImageConfig.layout = layout2;
        this.outcomingImageConfig.payload = payload;
        return this;
    }

    public MessageHolders setDateHeaderConfig(@NonNull Class<? extends ViewHolder<Date>> holder, @LayoutRes int layout2) {
        this.dateHeaderHolder = holder;
        this.dateHeaderLayout = layout2;
        return this;
    }

    public MessageHolders setDateHeaderHolder(@NonNull Class<? extends ViewHolder<Date>> holder) {
        this.dateHeaderHolder = holder;
        return this;
    }

    public MessageHolders setDateHeaderLayout(@LayoutRes int layout2) {
        this.dateHeaderLayout = layout2;
        return this;
    }

    public <TYPE extends MessageContentType> MessageHolders registerContentType(byte type, @NonNull Class<? extends BaseMessageViewHolder<TYPE>> holder, @LayoutRes int incomingLayout, @LayoutRes int outcomingLayout, @NonNull ContentChecker contentChecker) {
        return this.registerContentType(type, holder, incomingLayout, holder, outcomingLayout, contentChecker);
    }

    public <TYPE extends MessageContentType> MessageHolders registerContentType(byte type, @NonNull Class<? extends BaseMessageViewHolder<TYPE>> incomingHolder, @LayoutRes int incomingLayout, @NonNull Class<? extends BaseMessageViewHolder<TYPE>> outcomingHolder, @LayoutRes int outcomingLayout, @NonNull ContentChecker contentChecker) {
        if (type == 0) {
            throw new IllegalArgumentException("content type must be greater or less than '0'!");
        }
        this.customContentTypes.add(new ContentTypeConfig(type, new HolderConfig(incomingHolder, incomingLayout), new HolderConfig(outcomingHolder, outcomingLayout)));
        this.contentChecker = contentChecker;
        return this;
    }

    protected ViewHolder getHolder(ViewGroup parent, int viewType, MessagesListStyle messagesListStyle) {
        switch (viewType) {
            case 130: {
                return this.getHolder(parent, this.dateHeaderLayout, this.dateHeaderHolder, messagesListStyle, null);
            }
            case 131: {
                return this.getHolder(parent, this.incomingTextConfig, messagesListStyle);
            }
            case -131: {
                return this.getHolder(parent, this.outcomingTextConfig, messagesListStyle);
            }
            case 132: {
                return this.getHolder(parent, this.incomingImageConfig, messagesListStyle);
            }
            case -132: {
                return this.getHolder(parent, this.outcomingImageConfig, messagesListStyle);
            }
        }
        for (ContentTypeConfig typeConfig : this.customContentTypes) {
            if (Math.abs(typeConfig.type) != Math.abs(viewType)) continue;
            if (viewType > 0) {
                return this.getHolder(parent, typeConfig.incomingConfig, messagesListStyle);
            }
            return this.getHolder(parent, typeConfig.outcomingConfig, messagesListStyle);
        }
        throw new IllegalStateException("Wrong message view type. Please, report this issue on GitHub with full stacktrace in description.");
    }

    protected void bind(ViewHolder holder, final Object item, boolean isSelected, ImageLoader imageLoader, View.OnClickListener onMessageClickListener, View.OnLongClickListener onMessageLongClickListener, DateFormatter.Formatter dateHeadersFormatter, final SparseArray<MessagesListAdapter.OnMessageViewClickListener> clickListenersArray) {
        if (item instanceof IMessage) {
            ((BaseMessageViewHolder)holder).isSelected = isSelected;
            ((BaseMessageViewHolder)holder).imageLoader = imageLoader;
            holder.itemView.setOnLongClickListener(onMessageLongClickListener);
            holder.itemView.setOnClickListener(onMessageClickListener);
            for (int i = 0; i < clickListenersArray.size(); ++i) {
                final int key = clickListenersArray.keyAt(i);
                final View view = holder.itemView.findViewById(key);
                if (view == null) continue;
                view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ((MessagesListAdapter.OnMessageViewClickListener)clickListenersArray.get(key)).onMessageViewClick(view, (IMessage)item);
                    }
                });
            }
        } else if (item instanceof Date) {
            ((DefaultDateHeaderViewHolder)holder).dateHeadersFormatter = dateHeadersFormatter;
        }
        holder.onBind(item);
    }

    protected int getViewType(Object item, String senderId) {
        int viewType;
        boolean isOutcoming = false;
        if (item instanceof IMessage) {
            IMessage message = (IMessage)item;
            isOutcoming = message.getUser().getId().contentEquals(senderId);
            viewType = this.getContentViewType(message);
        } else {
            viewType = 130;
        }
        return isOutcoming ? viewType * -1 : viewType;
    }

    private ViewHolder getHolder(ViewGroup parent, HolderConfig holderConfig, MessagesListStyle style) {
        return this.getHolder(parent, holderConfig.layout, holderConfig.holder, style, holderConfig.payload);
    }

    private <HOLDER extends ViewHolder> ViewHolder getHolder(ViewGroup parent, @LayoutRes int layout2, Class<HOLDER> holderClass, MessagesListStyle style, Object payload) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(layout2, parent, false);
        try {
            ViewHolder holder;
            Constructor<HOLDER> constructor = null;
            try {
                constructor = holderClass.getDeclaredConstructor(View.class, Object.class);
                constructor.setAccessible(true);
                holder = (ViewHolder)((Object)constructor.newInstance(v, payload));
            }
            catch (NoSuchMethodException e) {
                constructor = holderClass.getDeclaredConstructor(View.class);
                constructor.setAccessible(true);
                holder = (ViewHolder)((Object)constructor.newInstance(v));
            }
            if (holder instanceof DefaultMessageViewHolder && style != null) {
                ((DefaultMessageViewHolder)((Object)holder)).applyStyle(style);
            }
            return holder;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Somehow we couldn't create the ViewHolder for message. Please, report this issue on GitHub with full stacktrace in description.", e);
        }
    }

    private short getContentViewType(IMessage message) {
        if (message instanceof MessageContentType.Image && ((MessageContentType.Image)message).getImageUrl() != null) {
            return 132;
        }
        if (message instanceof MessageContentType) {
            for (int i = 0; i < this.customContentTypes.size(); ++i) {
                ContentTypeConfig config = this.customContentTypes.get(i);
                if (this.contentChecker == null) {
                    throw new IllegalArgumentException("ContentChecker cannot be null when using custom content types!");
                }
                boolean hasContent = this.contentChecker.hasContentFor(message, config.type);
                if (!hasContent) continue;
                return config.type;
            }
        }
        return 131;
    }

    private class HolderConfig<T extends IMessage> {
        protected Class<? extends BaseMessageViewHolder<? extends T>> holder;
        protected int layout;
        protected Object payload;

        HolderConfig(Class<? extends BaseMessageViewHolder<? extends T>> holder, int layout2) {
            this.holder = holder;
            this.layout = layout2;
        }

        HolderConfig(Class<? extends BaseMessageViewHolder<? extends T>> holder, int layout2, Object payload) {
            this.holder = holder;
            this.layout = layout2;
            this.payload = payload;
        }
    }

    private static class ContentTypeConfig<TYPE extends MessageContentType> {
        private byte type;
        private HolderConfig<TYPE> incomingConfig;
        private HolderConfig<TYPE> outcomingConfig;

        private ContentTypeConfig(byte type, HolderConfig<TYPE> incomingConfig, HolderConfig<TYPE> outcomingConfig) {
            this.type = type;
            this.incomingConfig = incomingConfig;
            this.outcomingConfig = outcomingConfig;
        }
    }

    private static class DefaultOutcomingImageMessageViewHolder
    extends OutcomingImageMessageViewHolder<MessageContentType.Image> {
        public DefaultOutcomingImageMessageViewHolder(View itemView) {
            super(itemView, null);
        }
    }

    private static class DefaultIncomingImageMessageViewHolder
    extends IncomingImageMessageViewHolder<MessageContentType.Image> {
        public DefaultIncomingImageMessageViewHolder(View itemView) {
            super(itemView, null);
        }
    }

    private static class DefaultOutcomingTextMessageViewHolder
    extends OutcomingTextMessageViewHolder<IMessage> {
        public DefaultOutcomingTextMessageViewHolder(View itemView) {
            super(itemView, null);
        }
    }

    private static class DefaultIncomingTextMessageViewHolder
    extends IncomingTextMessageViewHolder<IMessage> {
        public DefaultIncomingTextMessageViewHolder(View itemView) {
            super(itemView, null);
        }
    }

    static interface DefaultMessageViewHolder {
        public void applyStyle(MessagesListStyle var1);
    }

    public static abstract class BaseOutcomingMessageViewHolder<MESSAGE extends IMessage>
    extends BaseMessageViewHolder<MESSAGE>
    implements DefaultMessageViewHolder {
        protected TextView time;

        @Deprecated
        public BaseOutcomingMessageViewHolder(View itemView) {
            super(itemView);
            this.init(itemView);
        }

        public BaseOutcomingMessageViewHolder(View itemView, Object payload) {
            super(itemView, payload);
            this.init(itemView);
        }

        @Override
        public void onBind(MESSAGE message) {
            if (this.time != null) {
                this.time.setText((CharSequence)DateFormatter.format(message.getCreatedAt(), DateFormatter.Template.TIME));
            }
        }

        @Override
        public void applyStyle(MessagesListStyle style) {
            if (this.time != null) {
                this.time.setTextColor(style.getOutcomingTimeTextColor());
                this.time.setTextSize(0, (float)style.getOutcomingTimeTextSize());
                this.time.setTypeface(this.time.getTypeface(), style.getOutcomingTimeTextStyle());
            }
        }

        private void init(View itemView) {
            this.time = (TextView)itemView.findViewById(R.id.messageTime);
        }
    }

    public static abstract class BaseIncomingMessageViewHolder<MESSAGE extends IMessage>
    extends BaseMessageViewHolder<MESSAGE>
    implements DefaultMessageViewHolder {
        protected TextView time;
        protected ImageView userAvatar;

        @Deprecated
        public BaseIncomingMessageViewHolder(View itemView) {
            super(itemView);
            this.init(itemView);
        }

        public BaseIncomingMessageViewHolder(View itemView, Object payload) {
            super(itemView, payload);
            this.init(itemView);
        }

        @Override
        public void onBind(MESSAGE message) {
            if (this.time != null) {
                this.time.setText((CharSequence)DateFormatter.format(message.getCreatedAt(), DateFormatter.Template.TIME));
            }
            if (this.userAvatar != null) {
                boolean isAvatarExists = this.imageLoader != null && message.getUser().getAvatar() != null && !message.getUser().getAvatar().isEmpty();
                this.userAvatar.setVisibility(isAvatarExists ? 0 : 8);
                if (isAvatarExists) {
                    this.imageLoader.loadImage(this.userAvatar, message.getUser().getAvatar());
                }
            }
        }

        @Override
        public void applyStyle(MessagesListStyle style) {
            if (this.time != null) {
                this.time.setTextColor(style.getIncomingTimeTextColor());
                this.time.setTextSize(0, (float)style.getIncomingTimeTextSize());
                this.time.setTypeface(this.time.getTypeface(), style.getIncomingTimeTextStyle());
            }
            if (this.userAvatar != null) {
                this.userAvatar.getLayoutParams().width = style.getIncomingAvatarWidth();
                this.userAvatar.getLayoutParams().height = style.getIncomingAvatarHeight();
            }
        }

        private void init(View itemView) {
            this.time = (TextView)itemView.findViewById(R.id.messageTime);
            this.userAvatar = (ImageView)itemView.findViewById(R.id.messageUserAvatar);
        }
    }

    public static class DefaultDateHeaderViewHolder
    extends ViewHolder<Date>
    implements DefaultMessageViewHolder {
        protected TextView text;
        protected String dateFormat;
        protected DateFormatter.Formatter dateHeadersFormatter;

        public DefaultDateHeaderViewHolder(View itemView) {
            super(itemView);
            this.text = (TextView)itemView.findViewById(R.id.messageText);
        }

        @Override
        public void onBind(Date date) {
            if (this.text != null) {
                String formattedDate = null;
                if (this.dateHeadersFormatter != null) {
                    formattedDate = this.dateHeadersFormatter.format(date);
                }
                this.text.setText((CharSequence)(formattedDate == null ? DateFormatter.format(date, this.dateFormat) : formattedDate));
            }
        }

        @Override
        public void applyStyle(MessagesListStyle style) {
            if (this.text != null) {
                this.text.setTextColor(style.getDateHeaderTextColor());
                this.text.setTextSize(0, (float)style.getDateHeaderTextSize());
                this.text.setTypeface(this.text.getTypeface(), style.getDateHeaderTextStyle());
                this.text.setPadding(style.getDateHeaderPadding(), style.getDateHeaderPadding(), style.getDateHeaderPadding(), style.getDateHeaderPadding());
            }
            this.dateFormat = style.getDateHeaderFormat();
            this.dateFormat = this.dateFormat == null ? DateFormatter.Template.STRING_DAY_MONTH_YEAR.get() : this.dateFormat;
        }
    }

    public static class OutcomingImageMessageViewHolder<MESSAGE extends MessageContentType.Image>
    extends BaseOutcomingMessageViewHolder<MESSAGE> {
        protected ImageView image;
        protected View imageOverlay;

        @Deprecated
        public OutcomingImageMessageViewHolder(View itemView) {
            super(itemView);
            this.init(itemView);
        }

        public OutcomingImageMessageViewHolder(View itemView, Object payload) {
            super(itemView, payload);
            this.init(itemView);
        }

        @Override
        public void onBind(MESSAGE message) {
            super.onBind(message);
            if (this.image != null && this.imageLoader != null) {
                this.imageLoader.loadImage(this.image, message.getImageUrl());
            }
            if (this.imageOverlay != null) {
                this.imageOverlay.setSelected(this.isSelected());
            }
        }

        @Override
        public final void applyStyle(MessagesListStyle style) {
            super.applyStyle(style);
            if (this.time != null) {
                this.time.setTextColor(style.getOutcomingImageTimeTextColor());
                this.time.setTextSize(0, (float)style.getOutcomingImageTimeTextSize());
                this.time.setTypeface(this.time.getTypeface(), style.getOutcomingImageTimeTextStyle());
            }
            if (this.imageOverlay != null) {
                ViewCompat.setBackground((View)this.imageOverlay, (Drawable)style.getOutcomingImageOverlayDrawable());
            }
        }

        private void init(View itemView) {
            this.image = (ImageView)itemView.findViewById(R.id.image);
            this.imageOverlay = itemView.findViewById(R.id.imageOverlay);
            if (this.image != null && this.image instanceof RoundedImageView) {
                ((RoundedImageView)this.image).setCorners(R.dimen.message_bubble_corners_radius, R.dimen.message_bubble_corners_radius, 0, R.dimen.message_bubble_corners_radius);
            }
        }
    }

    public static class IncomingImageMessageViewHolder<MESSAGE extends MessageContentType.Image>
    extends BaseIncomingMessageViewHolder<MESSAGE> {
        protected ImageView image;
        protected View imageOverlay;

        @Deprecated
        public IncomingImageMessageViewHolder(View itemView) {
            super(itemView);
            this.init(itemView);
        }

        public IncomingImageMessageViewHolder(View itemView, Object payload) {
            super(itemView, payload);
            this.init(itemView);
        }

        @Override
        public void onBind(MESSAGE message) {
            super.onBind(message);
            if (this.image != null && this.imageLoader != null) {
                this.imageLoader.loadImage(this.image, message.getImageUrl());
            }
            if (this.imageOverlay != null) {
                this.imageOverlay.setSelected(this.isSelected());
            }
        }

        @Override
        public final void applyStyle(MessagesListStyle style) {
            super.applyStyle(style);
            if (this.time != null) {
                this.time.setTextColor(style.getIncomingImageTimeTextColor());
                this.time.setTextSize(0, (float)style.getIncomingImageTimeTextSize());
                this.time.setTypeface(this.time.getTypeface(), style.getIncomingImageTimeTextStyle());
            }
            if (this.imageOverlay != null) {
                ViewCompat.setBackground((View)this.imageOverlay, (Drawable)style.getIncomingImageOverlayDrawable());
            }
        }

        private void init(View itemView) {
            this.image = (ImageView)itemView.findViewById(R.id.image);
            this.imageOverlay = itemView.findViewById(R.id.imageOverlay);
            if (this.image != null && this.image instanceof RoundedImageView) {
                ((RoundedImageView)this.image).setCorners(R.dimen.message_bubble_corners_radius, R.dimen.message_bubble_corners_radius, R.dimen.message_bubble_corners_radius, 0);
            }
        }
    }

    public static class OutcomingTextMessageViewHolder<MESSAGE extends IMessage>
    extends BaseOutcomingMessageViewHolder<MESSAGE> {
        protected ViewGroup bubble;
        protected TextView text;

        @Deprecated
        public OutcomingTextMessageViewHolder(View itemView) {
            super(itemView);
            this.init(itemView);
        }

        public OutcomingTextMessageViewHolder(View itemView, Object payload) {
            super(itemView, payload);
            this.init(itemView);
        }

        @Override
        public void onBind(MESSAGE message) {
            super.onBind(message);
            if (this.bubble != null) {
                this.bubble.setSelected(this.isSelected());
            }
            if (this.text != null) {
                this.text.setText((CharSequence)message.getText());
            }
        }

        @Override
        public final void applyStyle(MessagesListStyle style) {
            super.applyStyle(style);
            if (this.bubble != null) {
                this.bubble.setPadding(style.getOutcomingDefaultBubblePaddingLeft(), style.getOutcomingDefaultBubblePaddingTop(), style.getOutcomingDefaultBubblePaddingRight(), style.getOutcomingDefaultBubblePaddingBottom());
                ViewCompat.setBackground((View)this.bubble, (Drawable)style.getOutcomingBubbleDrawable());
            }
            if (this.text != null) {
                this.text.setTextColor(style.getOutcomingTextColor());
                this.text.setTextSize(0, (float)style.getOutcomingTextSize());
                this.text.setTypeface(this.text.getTypeface(), style.getOutcomingTextStyle());
                this.text.setAutoLinkMask(style.getTextAutoLinkMask());
                this.text.setLinkTextColor(style.getOutcomingTextLinkColor());
                this.configureLinksBehavior(this.text);
            }
        }

        private void init(View itemView) {
            this.bubble = (ViewGroup)itemView.findViewById(R.id.bubble);
            this.text = (TextView)itemView.findViewById(R.id.messageText);
        }
    }

    public static class IncomingTextMessageViewHolder<MESSAGE extends IMessage>
    extends BaseIncomingMessageViewHolder<MESSAGE> {
        protected ViewGroup bubble;
        protected TextView text;

        @Deprecated
        public IncomingTextMessageViewHolder(View itemView) {
            super(itemView);
            this.init(itemView);
        }

        public IncomingTextMessageViewHolder(View itemView, Object payload) {
            super(itemView, payload);
            this.init(itemView);
        }

        @Override
        public void onBind(MESSAGE message) {
            super.onBind(message);
            if (this.bubble != null) {
                this.bubble.setSelected(this.isSelected());
            }
            if (this.text != null) {
                this.text.setText((CharSequence)message.getText());
            }
        }

        @Override
        public void applyStyle(MessagesListStyle style) {
            super.applyStyle(style);
            if (this.bubble != null) {
                this.bubble.setPadding(style.getIncomingDefaultBubblePaddingLeft(), style.getIncomingDefaultBubblePaddingTop(), style.getIncomingDefaultBubblePaddingRight(), style.getIncomingDefaultBubblePaddingBottom());
                ViewCompat.setBackground((View)this.bubble, (Drawable)style.getIncomingBubbleDrawable());
            }
            if (this.text != null) {
                this.text.setTextColor(style.getIncomingTextColor());
                this.text.setTextSize(0, (float)style.getIncomingTextSize());
                this.text.setTypeface(this.text.getTypeface(), style.getIncomingTextStyle());
                this.text.setAutoLinkMask(style.getTextAutoLinkMask());
                this.text.setLinkTextColor(style.getIncomingTextLinkColor());
                this.configureLinksBehavior(this.text);
            }
        }

        private void init(View itemView) {
            this.bubble = (ViewGroup)itemView.findViewById(R.id.bubble);
            this.text = (TextView)itemView.findViewById(R.id.messageText);
        }
    }

    public static abstract class BaseMessageViewHolder<MESSAGE extends IMessage>
    extends ViewHolder<MESSAGE> {
        boolean isSelected;
        protected Object payload;
        protected ImageLoader imageLoader;

        @Deprecated
        public BaseMessageViewHolder(View itemView) {
            super(itemView);
        }

        public BaseMessageViewHolder(View itemView, Object payload) {
            super(itemView);
            this.payload = payload;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public boolean isSelectionModeEnabled() {
            return MessagesListAdapter.isSelectionModeEnabled;
        }

        public ImageLoader getImageLoader() {
            return this.imageLoader;
        }

        protected void configureLinksBehavior(TextView text) {
            text.setLinksClickable(false);
            text.setMovementMethod((MovementMethod)new LinkMovementMethod(){

                public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
                    boolean result = false;
                    if (!MessagesListAdapter.isSelectionModeEnabled) {
                        result = super.onTouchEvent(widget, buffer, event);
                    }
                    BaseMessageViewHolder.this.itemView.onTouchEvent(event);
                    return result;
                }
            });
        }
    }

    public static interface ContentChecker<MESSAGE extends IMessage> {
        public boolean hasContentFor(MESSAGE var1, byte var2);
    }
}

