/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.chatkit.messages;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.widget.Space;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.stfalcon.chatkit.R;
import com.stfalcon.chatkit.messages.MessageInputStyle;
import java.lang.reflect.Field;

public class MessageInput
extends RelativeLayout
implements View.OnClickListener,
TextWatcher {
    protected EditText messageInput;
    protected ImageButton messageSendButton;
    protected Space buttonSpace;
    private CharSequence input;
    private InputListener inputListener;

    public MessageInput(Context context) {
        super(context);
        this.init(context);
    }

    public MessageInput(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MessageInput(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public void setInputListener(InputListener inputListener) {
        this.inputListener = inputListener;
    }

    public EditText getInputEditText() {
        return this.messageInput;
    }

    public ImageButton getButton() {
        return this.messageSendButton;
    }

    public void onClick(View view) {
        boolean isSubmitted;
        int id2 = view.getId();
        if (id2 == R.id.messageSendButton && (isSubmitted = this.onSubmit())) {
            this.messageInput.setText((CharSequence)"");
        }
    }

    public void onTextChanged(CharSequence s, int start, int count, int after) {
        this.input = s;
        this.messageSendButton.setEnabled(this.input.length() > 0);
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void afterTextChanged(Editable editable) {
    }

    private boolean onSubmit() {
        return this.inputListener != null && this.inputListener.onSubmit(this.input);
    }

    private void init(Context context, AttributeSet attrs) {
        this.init(context);
        MessageInputStyle style = MessageInputStyle.parse(context, attrs);
        this.messageInput.setMaxLines(style.getInputMaxLines());
        this.messageInput.setHint((CharSequence)style.getInputHint());
        this.messageInput.setText((CharSequence)style.getInputText());
        this.messageInput.setTextSize(0, (float)style.getInputTextSize());
        this.messageInput.setTextColor(style.getInputTextColor());
        this.messageInput.setHintTextColor(style.getInputHintColor());
        this.messageInput.setBackground(style.getInputBackground());
        this.setCursor(style.getInputCursorDrawable());
        this.messageSendButton.setBackground(style.getInputButtonBackground());
        this.messageSendButton.setImageDrawable(style.getInputButtonIcon());
        this.messageSendButton.getLayoutParams().width = style.getInputButtonWidth();
        this.messageSendButton.getLayoutParams().height = style.getInputButtonHeight();
        this.buttonSpace.getLayoutParams().width = style.getInputButtonMargin();
        if (this.getPaddingLeft() == 0 && this.getPaddingRight() == 0 && this.getPaddingTop() == 0 && this.getPaddingBottom() == 0) {
            this.setPadding(style.getInputDefaultPaddingLeft(), style.getInputDefaultPaddingTop(), style.getInputDefaultPaddingRight(), style.getInputDefaultPaddingBottom());
        }
    }

    private void init(Context context) {
        MessageInput.inflate((Context)context, (int)R.layout.view_message_input, (ViewGroup)this);
        this.messageInput = (EditText)this.findViewById(R.id.messageInput);
        this.messageSendButton = (ImageButton)this.findViewById(R.id.messageSendButton);
        this.buttonSpace = (Space)this.findViewById(R.id.buttonSpace);
        this.messageSendButton.setOnClickListener((View.OnClickListener)this);
        this.messageInput.addTextChangedListener((TextWatcher)this);
        this.messageInput.setText((CharSequence)"");
    }

    private void setCursor(Drawable drawable2) {
        try {
            Field f = TextView.class.getDeclaredField("mCursorDrawableRes");
            f.setAccessible(true);
            f.set(this.messageInput, drawable2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface InputListener {
        public boolean onSubmit(CharSequence var1);
    }
}

