/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal.widget;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.support.annotation.CallSuper;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.RestrictTo;
import android.support.graphics.drawable.AnimatedVectorDrawableCompat;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.stepstone.stepper.R;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class StepTab
extends RelativeLayout {
    private static final float ALPHA_TRANSPARENT = 0.0f;
    private static final float ALPHA_INACTIVE_STEP_TITLE = 0.54f;
    private static final float ALPHA_OPAQUE = 1.0f;
    private static final float HALF_SIZE_SCALE = 0.5f;
    private static final float FULL_SIZE_SCALE = 1.0f;
    @ColorInt
    private int mUnselectedColor;
    @ColorInt
    private int mSelectedColor;
    @ColorInt
    private int mErrorColor;
    @ColorInt
    private int mTitleColor;
    private final TextView mStepNumber;
    private final View mStepDivider;
    private final TextView mStepTitle;
    private final ImageView mStepDoneIndicator;
    private final ImageView mStepIconBackground;
    private Typeface mNormalTypeface;
    private Typeface mBoldTypeface;
    private AbstractState mCurrentState = new InactiveNumberState();
    private AccelerateInterpolator mAccelerateInterpolator = new AccelerateInterpolator();

    public StepTab(Context context) {
        this(context, null);
    }

    public StepTab(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StepTab(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.ms_step_tab, (ViewGroup)this, true);
        this.mSelectedColor = ContextCompat.getColor((Context)context, (int)R.color.ms_selectedColor);
        this.mUnselectedColor = ContextCompat.getColor((Context)context, (int)R.color.ms_unselectedColor);
        this.mErrorColor = ContextCompat.getColor((Context)context, (int)R.color.ms_errorColor);
        this.mStepNumber = (TextView)this.findViewById(R.id.ms_stepNumber);
        this.mStepDoneIndicator = (ImageView)this.findViewById(R.id.ms_stepDoneIndicator);
        this.mStepIconBackground = (ImageView)this.findViewById(R.id.ms_stepIconBackground);
        this.mStepDivider = this.findViewById(R.id.ms_stepDivider);
        this.mStepTitle = (TextView)this.findViewById(R.id.ms_stepTitle);
        this.mTitleColor = this.mStepTitle.getCurrentTextColor();
        Typeface typeface = this.mStepTitle.getTypeface();
        this.mNormalTypeface = Typeface.create((Typeface)typeface, (int)0);
        this.mBoldTypeface = Typeface.create((Typeface)typeface, (int)1);
        Drawable avd = this.createCircleToWarningDrawable();
        this.mStepIconBackground.setImageDrawable(avd);
    }

    public void toggleDividerVisibility(boolean show) {
        this.mStepDivider.setVisibility(show ? 0 : 8);
    }

    public void updateState(boolean error, boolean done, boolean current) {
        this.mStepTitle.setTypeface(current ? this.mBoldTypeface : this.mNormalTypeface);
        if (error) {
            this.mCurrentState.changeToWarning();
        } else if (done) {
            this.mCurrentState.changeToDone();
        } else if (current) {
            this.mCurrentState.changeToActiveNumber();
        } else {
            this.mCurrentState.changeToInactiveNumber();
        }
    }

    public void setStepTitle(CharSequence title) {
        this.mStepTitle.setText(title);
    }

    public void setStepNumber(CharSequence number) {
        this.mStepNumber.setText(number);
    }

    public void setUnselectedColor(int unselectedColor) {
        this.mUnselectedColor = unselectedColor;
    }

    public void setSelectedColor(int selectedColor) {
        this.mSelectedColor = selectedColor;
    }

    public void setErrorColor(int errorColor) {
        this.mErrorColor = errorColor;
    }

    public void setDividerWidth(int dividerWidth) {
        this.mStepDivider.getLayoutParams().width = dividerWidth != -1 ? dividerWidth : this.getResources().getDimensionPixelOffset(R.dimen.ms_step_tab_divider_length);
    }

    private Drawable createCircleToWarningDrawable() {
        return this.createAnimatedVectorDrawable(R.drawable.ms_animated_vector_circle_to_warning_24dp);
    }

    private Drawable createWarningToCircleDrawable() {
        return this.createAnimatedVectorDrawable(R.drawable.ms_animated_vector_warning_to_circle_24dp);
    }

    public Drawable createAnimatedVectorDrawable(@DrawableRes int animatedVectorDrawableResId) {
        return AnimatedVectorDrawableCompat.create((Context)this.getContext(), (int)animatedVectorDrawableResId);
    }

    private class WarningState
    extends AbstractState {
        private WarningState() {
        }

        @Override
        protected void changeToDone() {
            this.animateViewIn((View)StepTab.this.mStepDoneIndicator);
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mSelectedColor);
            StepTab.this.mStepTitle.setTextColor(StepTab.this.mTitleColor);
            super.changeToDone();
        }

        @Override
        protected void changeToInactiveNumber() {
            this.animateViewIn((View)StepTab.this.mStepNumber);
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mUnselectedColor);
            StepTab.this.mStepTitle.setTextColor(StepTab.this.mTitleColor);
            StepTab.this.mStepTitle.setAlpha(0.54f);
            super.changeToInactiveNumber();
        }

        @Override
        protected void changeToActiveNumber() {
            this.animateViewIn((View)StepTab.this.mStepNumber);
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mSelectedColor);
            StepTab.this.mStepTitle.setTextColor(StepTab.this.mTitleColor);
            super.changeToActiveNumber();
        }

        private void animateViewIn(View view) {
            Drawable avd = StepTab.this.createWarningToCircleDrawable();
            StepTab.this.mStepIconBackground.setImageDrawable(avd);
            ((Animatable)avd).start();
            view.setVisibility(0);
            view.setAlpha(0.0f);
            view.setScaleX(0.5f);
            view.setScaleY(0.5f);
            view.animate().setInterpolator((TimeInterpolator)StepTab.this.mAccelerateInterpolator).alpha(1.0f).scaleX(1.0f).scaleY(1.0f);
        }
    }

    private class DoneState
    extends AbstractState {
        private DoneState() {
        }

        @Override
        protected void changeToInactiveNumber() {
            StepTab.this.mStepDoneIndicator.setVisibility(8);
            StepTab.this.mStepNumber.setVisibility(0);
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mUnselectedColor);
            StepTab.this.mStepTitle.setAlpha(0.54f);
            super.changeToInactiveNumber();
        }

        @Override
        protected void changeToActiveNumber() {
            StepTab.this.mStepDoneIndicator.setVisibility(8);
            StepTab.this.mStepNumber.setVisibility(0);
            super.changeToActiveNumber();
        }

        @Override
        protected void changeToWarning() {
            Drawable avd = StepTab.this.createCircleToWarningDrawable();
            StepTab.this.mStepIconBackground.setImageDrawable(avd);
            ((Animatable)avd).start();
            super.changeToWarning();
        }
    }

    private class ActiveNumberState
    extends AbstractNumberState {
        private ActiveNumberState() {
        }

        @Override
        protected void changeToInactiveNumber() {
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mUnselectedColor);
            StepTab.this.mStepTitle.setAlpha(0.54f);
            super.changeToInactiveNumber();
        }
    }

    private class InactiveNumberState
    extends AbstractNumberState {
        private InactiveNumberState() {
        }

        @Override
        protected void changeToInactiveNumber() {
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mUnselectedColor);
            StepTab.this.mStepTitle.setTextColor(StepTab.this.mTitleColor);
            StepTab.this.mStepTitle.setAlpha(0.54f);
            super.changeToInactiveNumber();
        }

        @Override
        protected void changeToActiveNumber() {
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mSelectedColor);
            StepTab.this.mStepTitle.setAlpha(1.0f);
            super.changeToActiveNumber();
        }

        @Override
        protected void changeToDone() {
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mSelectedColor);
            StepTab.this.mStepTitle.setAlpha(1.0f);
            super.changeToDone();
        }
    }

    private abstract class AbstractNumberState
    extends AbstractState {
        private AbstractNumberState() {
        }

        @Override
        @CallSuper
        protected void changeToWarning() {
            Drawable avd = StepTab.this.createCircleToWarningDrawable();
            StepTab.this.mStepIconBackground.setImageDrawable(avd);
            ((Animatable)avd).start();
            super.changeToWarning();
        }

        @Override
        @CallSuper
        protected void changeToDone() {
            StepTab.this.mStepDoneIndicator.setVisibility(0);
            StepTab.this.mStepNumber.setVisibility(8);
            super.changeToDone();
        }
    }

    private abstract class AbstractState {
        private AbstractState() {
        }

        @CallSuper
        protected void changeToInactiveNumber() {
            StepTab.this.mCurrentState = new InactiveNumberState();
        }

        @CallSuper
        protected void changeToActiveNumber() {
            StepTab.this.mCurrentState = new ActiveNumberState();
        }

        @CallSuper
        protected void changeToDone() {
            StepTab.this.mCurrentState = new DoneState();
        }

        @CallSuper
        protected void changeToWarning() {
            StepTab.this.mStepDoneIndicator.setVisibility(8);
            StepTab.this.mStepNumber.setVisibility(8);
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mErrorColor);
            StepTab.this.mStepTitle.setTextColor(StepTab.this.mErrorColor);
            StepTab.this.mCurrentState = new WarningState();
        }
    }
}

