/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.type;

import android.support.annotation.NonNull;
import com.stepstone.stepper.R;
import com.stepstone.stepper.StepperLayout;
import com.stepstone.stepper.adapter.StepAdapter;
import com.stepstone.stepper.internal.TabsContainer;
import com.stepstone.stepper.type.AbstractStepperType;
import com.stepstone.stepper.viewmodel.StepViewModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TabsStepperType
extends AbstractStepperType {
    private static final List<CharSequence> EDIT_MODE_STEP_TITLES = Arrays.asList("Step 1", "Step 2");
    private final TabsContainer mTabsContainer;

    public TabsStepperType(StepperLayout stepperLayout) {
        super(stepperLayout);
        this.mTabsContainer = (TabsContainer)stepperLayout.findViewById(R.id.ms_stepTabsContainer);
        this.mTabsContainer.setVisibility(0);
        this.mTabsContainer.setSelectedColor(stepperLayout.getSelectedColor());
        this.mTabsContainer.setUnselectedColor(stepperLayout.getUnselectedColor());
        this.mTabsContainer.setErrorColor(stepperLayout.getErrorColor());
        this.mTabsContainer.setDividerWidth(stepperLayout.getTabStepDividerWidth());
        this.mTabsContainer.setListener(stepperLayout);
        if (stepperLayout.isInEditMode()) {
            this.mTabsContainer.setSteps(EDIT_MODE_STEP_TITLES);
            this.mTabsContainer.setVisibility(0);
        }
    }

    @Override
    public void onStepSelected(int newStepPosition) {
        this.mTabsContainer.setCurrentStep(newStepPosition);
    }

    @Override
    public void setErrorStep(int stepPosition, boolean hasError) {
        this.mTabsContainer.setErrorStep(stepPosition, hasError);
    }

    @Override
    public void showErrorStateOnBack(boolean mShowErrorStateOnBack) {
        this.mTabsContainer.setShowErrorStateOnBack(mShowErrorStateOnBack);
    }

    @Override
    public void onNewAdapter(@NonNull StepAdapter stepAdapter) {
        ArrayList<CharSequence> titles = new ArrayList<CharSequence>();
        int stepCount = stepAdapter.getCount();
        for (int i = 0; i < stepCount; ++i) {
            StepViewModel stepViewModel = stepAdapter.getViewModel(i);
            titles.add(stepViewModel.getTitle());
        }
        this.mTabsContainer.setSteps(titles);
        this.mTabsContainer.setVisibility(stepCount > 1 ? 0 : 8);
    }
}

