/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.type;

import android.support.annotation.NonNull;
import com.stepstone.stepper.R;
import com.stepstone.stepper.StepperLayout;
import com.stepstone.stepper.adapter.StepAdapter;
import com.stepstone.stepper.internal.DottedProgressBar;
import com.stepstone.stepper.type.AbstractStepperType;

public class DotsStepperType
extends AbstractStepperType {
    private static final int EDIT_MODE_DOT_COUNT = 3;
    private final DottedProgressBar mDottedProgressBar;

    public DotsStepperType(StepperLayout stepperLayout) {
        super(stepperLayout);
        this.mDottedProgressBar = (DottedProgressBar)stepperLayout.findViewById(R.id.ms_stepDottedProgressBar);
        this.mDottedProgressBar.setSelectedColor(this.getSelectedColor());
        this.mDottedProgressBar.setUnselectedColor(this.getUnselectedColor());
        if (stepperLayout.isInEditMode()) {
            this.mDottedProgressBar.setDotCount(3);
            this.mDottedProgressBar.setVisibility(0);
        }
    }

    @Override
    public void onStepSelected(int newStepPosition) {
        this.mDottedProgressBar.setCurrent(newStepPosition, true);
    }

    @Override
    public void onNewAdapter(@NonNull StepAdapter stepAdapter) {
        int stepCount = stepAdapter.getCount();
        this.mDottedProgressBar.setDotCount(stepCount);
        this.mDottedProgressBar.setVisibility(stepCount > 1 ? 0 : 8);
    }
}

