/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.LinearLayout;
import com.stepstone.stepper.R;
import com.stepstone.stepper.util.TintUtil;

public class DottedProgressBar
extends LinearLayout {
    private static final float FULL_SCALE = 1.0f;
    private static final float HALF_SCALE = 0.5f;
    private static final int DURATION_IMMEDIATE = 0;
    private static final int SCALE_ANIMATION_DEFAULT_DURATION = 300;
    @ColorInt
    private int mUnselectedColor;
    @ColorInt
    private int mSelectedColor;
    private int mDotCount;
    private int mCurrent;

    public DottedProgressBar(Context context) {
        this(context, null);
    }

    public DottedProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DottedProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mSelectedColor = ContextCompat.getColor((Context)context, (int)R.color.ms_selectedColor);
        this.mUnselectedColor = ContextCompat.getColor((Context)context, (int)R.color.ms_unselectedColor);
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.DottedProgressBar, defStyleAttr, 0);
            if (a.hasValue(R.styleable.DottedProgressBar_ms_activeDotColor)) {
                this.mSelectedColor = a.getColor(R.styleable.DottedProgressBar_ms_activeDotColor, this.mSelectedColor);
            }
            if (a.hasValue(R.styleable.DottedProgressBar_ms_inactiveDotColor)) {
                this.mUnselectedColor = a.getColor(R.styleable.DottedProgressBar_ms_inactiveDotColor, this.mUnselectedColor);
            }
            a.recycle();
        }
    }

    public void setUnselectedColor(@ColorInt int unselectedColor) {
        this.mUnselectedColor = unselectedColor;
    }

    public void setSelectedColor(@ColorInt int selectedColor) {
        this.mSelectedColor = selectedColor;
    }

    public void setDotCount(int dotCount) {
        this.mDotCount = dotCount;
        this.removeAllViews();
        for (int i = 0; i < dotCount; ++i) {
            View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.ms_dot, (ViewGroup)this, false);
            this.addView(view);
        }
        this.setCurrent(0, false);
    }

    public void setCurrent(int current, boolean shouldAnimate) {
        this.mCurrent = current;
        this.update(shouldAnimate);
    }

    private void update(boolean shouldAnimate) {
        for (int i = 0; i < this.mDotCount; ++i) {
            AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();
            if (i == this.mCurrent) {
                this.getChildAt(i).animate().scaleX(1.0f).scaleY(1.0f).setDuration(shouldAnimate ? 300L : 0L).setInterpolator((TimeInterpolator)interpolator).start();
                this.colorChildAtPosition(i, true);
                continue;
            }
            this.getChildAt(i).animate().scaleX(0.5f).scaleY(0.5f).setDuration(shouldAnimate ? 300L : 0L).setInterpolator((TimeInterpolator)interpolator).start();
            this.colorChildAtPosition(i, false);
        }
    }

    private void colorChildAtPosition(int i, boolean selected) {
        Drawable d = this.getChildAt(i).getBackground();
        TintUtil.tintDrawable(d, selected ? this.mSelectedColor : this.mUnselectedColor);
    }
}

