/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import com.stepstone.stepper.R;
import com.stepstone.stepper.util.TintUtil;

public class ColorableProgressBar
extends ProgressBar {
    @ColorInt
    private int mProgressColor;
    @ColorInt
    private int mProgressBackgroundColor;

    public ColorableProgressBar(Context context) {
        this(context, null);
    }

    public ColorableProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ColorableProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mProgressColor = ContextCompat.getColor((Context)context, (int)R.color.ms_selectedColor);
        this.mProgressBackgroundColor = ContextCompat.getColor((Context)context, (int)R.color.ms_unselectedColor);
        super.setProgressDrawable(ContextCompat.getDrawable((Context)context, (int)R.drawable.ms_colorable_progress_bar));
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ColorableProgressBar, defStyleAttr, 0);
            if (a.hasValue(R.styleable.ColorableProgressBar_ms_progressPrimaryColor)) {
                this.mProgressColor = a.getColor(R.styleable.ColorableProgressBar_ms_progressPrimaryColor, this.mProgressColor);
            }
            if (a.hasValue(R.styleable.ColorableProgressBar_ms_progressBackgroundColor)) {
                this.mProgressBackgroundColor = a.getColor(R.styleable.ColorableProgressBar_ms_progressBackgroundColor, this.mProgressBackgroundColor);
            }
            a.recycle();
        }
        this.updateProgressDrawable();
    }

    public void setProgressDrawable(Drawable d) {
    }

    public void setProgressDrawableTiled(Drawable d) {
    }

    public void setProgressColor(@ColorInt int progressColor) {
        this.mProgressColor = progressColor;
        this.updateProgressDrawable();
    }

    public void setProgressBackgroundColor(@ColorInt int backgroundColor) {
        this.mProgressBackgroundColor = backgroundColor;
        this.updateProgressDrawable();
    }

    private void updateProgressDrawable() {
        LayerDrawable progressBarDrawable = (LayerDrawable)this.getProgressDrawable();
        Drawable backgroundDrawable = progressBarDrawable.findDrawableByLayerId(0x1020000);
        Drawable progressDrawable = progressBarDrawable.findDrawableByLayerId(16908301);
        TintUtil.tintDrawable(backgroundDrawable, this.mProgressBackgroundColor);
        TintUtil.tintDrawable(progressDrawable, this.mProgressColor);
    }
}

