/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal.type;

import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.util.SparseArray;
import com.stepstone.stepper.R;
import com.stepstone.stepper.StepperLayout;
import com.stepstone.stepper.VerificationError;
import com.stepstone.stepper.adapter.StepAdapter;
import com.stepstone.stepper.internal.type.AbstractStepperType;
import com.stepstone.stepper.internal.widget.TabsContainer;
import com.stepstone.stepper.viewmodel.StepViewModel;
import java.util.ArrayList;
import java.util.Arrays;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class TabsStepperType
extends AbstractStepperType {
    private final TabsContainer mTabsContainer;

    public TabsStepperType(StepperLayout stepperLayout) {
        super(stepperLayout);
        this.mTabsContainer = (TabsContainer)stepperLayout.findViewById(R.id.ms_stepTabsContainer);
        this.mTabsContainer.setSelectedColor(stepperLayout.getSelectedColor());
        this.mTabsContainer.setUnselectedColor(stepperLayout.getUnselectedColor());
        this.mTabsContainer.setErrorColor(stepperLayout.getErrorColor());
        this.mTabsContainer.setDividerWidth(stepperLayout.getTabStepDividerWidth());
        this.mTabsContainer.setListener(stepperLayout);
        if (stepperLayout.isInEditMode()) {
            this.mTabsContainer.setSteps(Arrays.asList(new StepViewModel.Builder(null).setTitle("Step 1").create(), new StepViewModel.Builder(null).setTitle("Step 2").setSubtitle("Optional").create()));
            this.mTabsContainer.updateSteps(0, (SparseArray<VerificationError>)new SparseArray(), false);
            this.mTabsContainer.setVisibility(0);
        }
    }

    @Override
    public void onStepSelected(int newStepPosition, boolean userTriggeredChange) {
        if (!this.mStepperLayout.isShowErrorStateEnabled()) {
            this.mStepErrors.clear();
        }
        this.mTabsContainer.updateSteps(newStepPosition, (SparseArray<VerificationError>)this.mStepErrors, this.mStepperLayout.isShowErrorMessageEnabled());
    }

    @Override
    public void onNewAdapter(@NonNull StepAdapter stepAdapter) {
        super.onNewAdapter(stepAdapter);
        ArrayList<StepViewModel> stepViewModels = new ArrayList<StepViewModel>();
        int stepCount = stepAdapter.getCount();
        for (int i = 0; i < stepCount; ++i) {
            stepViewModels.add(stepAdapter.getViewModel(i));
        }
        this.mTabsContainer.setSteps(stepViewModels);
        this.mTabsContainer.setVisibility(stepCount > 1 ? 0 : 8);
    }
}

