/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.test;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.test.espresso.matcher.BoundedMatcher;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.stepstone.stepper.R;
import com.stepstone.stepper.StepperLayout;
import com.stepstone.stepper.internal.widget.StepTab;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class StepperLayoutTabSubtitleMatcher
extends BoundedMatcher<View, StepperLayout> {
    private static final String TAG = "StepperLayoutTabSubtMa";
    @IntRange(from=0L)
    private final int tabPosition;
    @NonNull
    private final Matcher<View> subtitleMatcher;

    private StepperLayoutTabSubtitleMatcher(@IntRange(from=0L) int tabPosition, @NonNull Matcher<View> subtitleMatcher) {
        super(StepperLayout.class);
        this.tabPosition = tabPosition;
        this.subtitleMatcher = subtitleMatcher;
    }

    public void describeTo(Description description) {
        description.appendText(" at position: ").appendValue((Object)this.tabPosition).appendText(" with message: ").appendValue(this.subtitleMatcher);
    }

    protected boolean matchesSafely(StepperLayout view) {
        ViewGroup tabsContainer = (ViewGroup)view.findViewById(R.id.ms_stepTabsInnerContainer);
        int childCount = tabsContainer.getChildCount();
        if (childCount == 0) {
            Log.e((String)TAG, (String)"No tabs found!");
            return false;
        }
        if (this.tabPosition < 0 || this.tabPosition >= childCount) {
            Log.e((String)TAG, (String)("Invalid tab position: " + this.tabPosition));
            return false;
        }
        StepTab stepTab = (StepTab)tabsContainer.getChildAt(this.tabPosition);
        TextView subtitleTextView = (TextView)stepTab.findViewById(R.id.ms_stepSubtitle);
        return this.subtitleMatcher.matches((Object)subtitleTextView);
    }

    public static Matcher<View> tabAtPositionHasSubtitle(@IntRange(from=0L) int tabPosition, @NonNull Matcher<View> subtitleMatcher) {
        return new StepperLayoutTabSubtitleMatcher(tabPosition, subtitleMatcher);
    }
}

